/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGeneratePropertiesHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCPropertyInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToPropertyIntentionAction
extends OCGeneratePropertiesHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Convert to property" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "getText"));
        }
        return "Convert to property";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    @Nullable
    public OCInstanceVariableSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "locateCandidate"));
        }
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        }
        return symbol instanceof OCInstanceVariableSymbol ? (OCInstanceVariableSymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "isAvailable"));
        }
        return OCSearchScope.isInProjectSources(this.locateCandidate(project, editor, file2));
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "getParent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/intentions/OCConvertToPropertyIntentionAction", "getParent"));
        }
        OCInstanceVariableSymbol ivar = this.locateCandidate(project, editor, file2);
        return ivar != null ? ((OCClassSymbol)ivar.getParent()).getMainInterface() : null;
    }

    @Override
    protected boolean replaceAllIvars() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(OCGenerateFromIvarsActionContext actionContext) {
        return Conditions.alwaysTrue();
    }

    @Override
    protected void performAction(Project project, Editor editor, final PsiFile file2, final OCGenerateFromIvarsActionContext context, final List<OCInstanceVariableSymbol> ivars) {
        final OCInstanceVariableSymbol ivar = this.locateCandidate(project, editor, file2);
        if (ivar == null) {
            return;
        }
        OCPropertySymbol associatedProperty = ivar.getAssociatedProperty();
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
        final String propName = associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler2 = new OCBaseLocalConvertibleHandler("Introduce Property"){

            protected OCPropertyInplaceIntroducer createIntroducer(Project project, final Editor editor, PsiElement expression, List<PsiElement> occurrences, String refactoringName) {
                return new OCPropertyInplaceIntroducer(project, editor, expression, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = new PsiElement[]{};
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToPropertyIntentionAction.this.performAction(file2, context, ivars, this.getInputName(), (OCPropertySymbol.PropertySemantics)((Object)this.mySemantics.compute()), this.myReadonly, this.isConvertUsages(), this.myPutToPrivateCategoryCB != null && this.myPutToPrivateCategoryCB.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateSynthesize() {
                        return false;
                    }

                    @Override
                    protected boolean askToConvertUsages() {
                        if (!OCCompilerHelper.supportsAutosynthesis(file2)) {
                            return false;
                        }
                        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
                        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class);
                        return !(parent instanceof OCQualifiedExpression);
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!propName.equals(ivar.getName())) {
                            return new String[]{propName, ivar.getName()};
                        }
                        return new String[]{propName};
                    }
                };
            }
        };
        handler2.invoke(project, editor, element, ivar.getResolvedType(), true, false, propName, (OCSymbol)ivar.getParent());
    }
}

