/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCUnusedCodeInspection;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;

public class OCUnusedInstanceVariableInspection
extends OCUnusedCodeInspection {
    @Override
    @NotNull
    public OCUnusedCodeInspection.UnusedVisitor buildVisitor() {
        OCUnusedCodeInspection.UnusedVisitor unusedVisitor = new OCUnusedCodeInspection.UnusedVisitor(){

            @Override
            public void visitInstanceVariableList(OCInstanceVariablesList list) {
                for (OCDeclaration declaration : list.getDeclarations()) {
                    for (OCDeclarator declarator : declaration.getDeclarators()) {
                        this.checkSymbolUsed(declarator, declarator.getSymbol());
                    }
                }
            }

            @Override
            public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator, boolean hasWrites) {
                if (symbol == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/inspections/OCUnusedInstanceVariableInspection$1", "checkFromBatchMode"));
                }
                if (declarator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarator", "com/jetbrains/cidr/lang/inspections/OCUnusedInstanceVariableInspection$1", "checkFromBatchMode"));
                }
                if (symbol instanceof OCInstanceVariableSymbol && (((OCInstanceVariableSymbol)symbol).getParent() instanceof OCInterfaceSymbol || symbol.getAssociatedSymbol() == null)) {
                    this.checkSymbolUsed(declarator, symbol, hasWrites);
                }
            }
        };
        if (unusedVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCUnusedInstanceVariableInspection", "buildVisitor"));
        }
        return unusedVisitor;
    }
}

