/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCConvertIfToTernaryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimplifyInspection
extends OCInspections.GeneralCpp {
    private static Key<Map<PsiElement, Pair<PsiElement, Simplifier>>> SIMPLIFIABLE_ELEMENTS = Key.create((String)"SIMPLIFIABLE_ELEMENTS");
    public boolean enableSimplifyEqualToYesNo = true;
    public boolean enableSimplifyIfWithConstantBranch = false;
    private static Set<String> GOOD_MACROS = ContainerUtil.set((Object[])new String[]{"YES", "NO", "true", "false", "TRUE", "FALSE"});

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        CheckBox checkBox1 = new CheckBox("Simplify \"condition == true\"", (InspectionProfileEntry)this, "enableSimplifyEqualToYesNo");
        CheckBox checkBox2 = new CheckBox("Simplify \"condition1 ? true : condition2\"", (InspectionProfileEntry)this, "enableSimplifyIfWithConstantBranch");
        panel.add((Component)checkBox1);
        panel.add((Component)checkBox2);
        return panel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Simplifiable statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "getDisplayName"));
        }
        return "Simplifiable statement";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "buildVisitor"));
        }
        final HashMap map = new HashMap();
        session.putUserData(SIMPLIFIABLE_ELEMENTS, map);
        SimplifyVisitor simplifyVisitor = new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, PsiElement simplified, Simplifier simplifier) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$1", "simplify"));
                }
                if (simplified != null) {
                    map.put(element, Pair.create((Object)simplified, (Object)simplifier));
                }
            }
        };
        if (simplifyVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "buildVisitor"));
        }
        return simplifyVisitor;
    }

    public static void simplify(PsiElement element) {
        element.accept((PsiElementVisitor)new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$2", "simplify"));
                }
                if (simplified != null) {
                    OCSimplifyInspection.getSimplifyFix(element, simplified).invoke(element.getProject(), null, element.getContainingFile());
                } else {
                    this.visitElement(element);
                }
            }

            public void visitElement(PsiElement element) {
                for (PsiElement child : element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "inspectionFinished"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "inspectionFinished"));
        }
        Map map = (Map)session.getUserData(SIMPLIFIABLE_ELEMENTS);
        assert (map != null);
        block0: for (PsiElement element : map.keySet()) {
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                Pair parentInspection = (Pair)map.get(parent);
                if (parentInspection != null && !((Simplifier)parentInspection.getSecond()).isWarningDisabled(this)) continue block0;
            }
            Pair pair = (Pair)map.get(element);
            PsiElement simplified = (PsiElement)pair.getFirst();
            OCDeclarationOrExpression warningElement = element instanceof OCIfStatement ? ((OCIfStatement)element).getCondition() : (element instanceof OCLoopStatement ? ((OCLoopStatement)element).getCondition() : element);
            String message = OCSimplifyInspection.getSimplifyMessage(element, simplified);
            IntentionAction fix = OCSimplifyInspection.getSimplifyFix(element, simplified);
            ProblemHighlightType highlightType = ((Simplifier)pair.getSecond()).isWarningDisabled(this) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), warningElement, message, "CIDR", highlightType, fix);
        }
    }

    public static String getSimplifyMessage(PsiElement element, PsiElement simplified) {
        if (element instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)element).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)element).getElseBranch();
            if (simplified == thenBranch) {
                return thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, new OCResolveContext(element)) ? "'if' statement has identical branches" : "Condition is always true";
            }
            if (simplified == elseBranch || simplified instanceof OCEmptyStatement) {
                return "Condition is always false";
            }
            return "Statement can be simplified";
        }
        if (element instanceof OCLoopStatement) {
            return "Condition is always false";
        }
        return "Expression can be simplified to '" + OCElementUtil.getTextWithMacros(simplified) + "'";
    }

    public static IntentionAction getSimplifyFix(final PsiElement element, final PsiElement simplified) {
        final String subject = OCSimplifyInspection.getStatementName(element);
        if (element instanceof OCStatement && element.getParent() instanceof OCBlockStatement && simplified instanceof OCBlockStatement) {
            return new OCChangeElementIntentionAction(element, ((OCBlockStatement)simplified).getStatements(), "Simplify " + subject);
        }
        if (simplified instanceof OCEmptyStatement) {
            return new OCRemoveElementsIntentionAction(element, "Remove " + subject);
        }
        if (simplified instanceof OCExpression && element instanceof OCIfStatement) {
            return new OCConvertIfToTernaryIntentionAction(){

                @Override
                @NotNull
                public String getText() {
                    String string = "Simplify " + subject;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$3", "getText"));
                    }
                    return string;
                }

                @Override
                protected OCConvertIfToTernaryIntentionAction.Converter createConverter(PsiElement _) {
                    return new OCConvertIfToTernaryIntentionAction.Converter(this, element);
                }

                @Override
                protected OCExpression getNewExpression(OCConvertIfToTernaryIntentionAction.Converter converter) {
                    return (OCExpression)simplified;
                }
            };
        }
        return new OCChangeElementIntentionAction(element, simplified, "Simplify " + (element instanceof OCExpression ? "expression" : subject));
    }

    private static String getStatementName(PsiElement element) {
        if (element instanceof OCIfStatement) {
            return "'if' statement";
        }
        if (element instanceof OCWhileStatement) {
            return "'while' statement";
        }
        if (element instanceof OCDoWhileStatement) {
            return "'do-while' statement";
        }
        if (element instanceof OCForStatement) {
            return "'for' statement";
        }
        return "statement";
    }

    @Nullable
    public static OCStatement simplifyStatementWithConstCondition(boolean conditionValue, @NotNull OCStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "simplifyStatementWithConstCondition"));
        }
        if (statement instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)statement).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)statement).getElseBranch();
            return conditionValue ? thenBranch : (elseBranch != null ? elseBranch : OCSimplifyInspection.createEmptyStatement(statement));
        }
        if (statement instanceof OCWhileStatement) {
            return conditionValue ? null : OCSimplifyInspection.createEmptyStatement(statement);
        }
        if (statement instanceof OCDoWhileStatement) {
            return conditionValue ? null : ((OCDoWhileStatement)statement).getBody();
        }
        if (statement instanceof OCForStatement) {
            OCStatement initializer = ((OCForStatement)statement).getInitializer();
            return conditionValue ? null : (initializer != null ? initializer : OCSimplifyInspection.createEmptyStatement(statement));
        }
        throw new UnsupportedOperationException(statement.getClass().getCanonicalName());
    }

    @Nullable
    public static OCExpression simplifyLogicExpression(boolean conditionValue, @NotNull OCBinaryExpression expression, PsiElement element) {
        OCExpression otherOperand;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "simplifyLogicExpression"));
        }
        OCElementType sign = expression.getOperationSign();
        if (PsiTreeUtil.isAncestor((PsiElement)expression.getLeft(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression.getRight();
        } else if (PsiTreeUtil.isAncestor((PsiElement)expression.getRight(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression.getLeft();
        } else {
            return null;
        }
        return Simplifier.trySimplifyLogicExpression(conditionValue, expression.getLeft(), otherOperand, sign);
    }

    private static OCStatement createEmptyStatement(PsiElement context) {
        return OCElementFactory.statementFromText(";", context);
    }

    @Nullable
    private static OCExpression simplify(@Nullable OCExpression expression) {
        OCExpression simplified = null;
        if (expression == null || OCSimplifyInspection.isOverloadedOperatorUsage(expression)) {
            return expression;
        }
        if (expression instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)expression;
            simplified = new Simplifier().trySimplifyCondExpr(condExpr.getCondition(), condExpr.getPositiveExpression(true), condExpr.getNegativeExpression());
        } else if (expression instanceof OCBinaryExpression) {
            OCBinaryExpression binaryExpr = (OCBinaryExpression)expression;
            simplified = new Simplifier().trySimplifyBinaryExpr(binaryExpr.getLeft(), binaryExpr.getRight(), binaryExpr.getOperationSign());
        } else if (expression instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpr = (OCUnaryExpression)expression;
            simplified = Simplifier.trySimplifyUnaryExpr(unaryExpr.getOperand(), unaryExpr.getOperationSign());
        } else if (expression instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expression)) {
            simplified = OCSimplifyInspection.simplify(((OCParenthesizedExpression)expression).getOperand());
        }
        return simplified != null ? simplified : expression;
    }

    private static boolean hasMacros(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if ((!(child instanceof OCMacroCall) || GOOD_MACROS.contains(((OCMacroCall)child).getTextWithMacros())) && !OCSimplifyInspection.hasMacros(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T nullIfHasMacros(T value, PsiElement element) {
        OCMacroRange range;
        if (OCElementUtil.isPartOfMacroSubstitution(element) && (range = OCElementUtil.getRangeInMacroCall(element)) != null && range.getMacroCall() != null && !GOOD_MACROS.contains(range.getMacroCall().getTextWithMacros())) {
            return null;
        }
        return OCSimplifyInspection.hasMacros(element) ? null : (T)value;
    }

    private static boolean isOverloadedOperatorUsage(@NotNull OCExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection", "isOverloadedOperatorUsage"));
        }
        PsiReference reference = expr.getReference();
        return reference instanceof OCOperatorReference && !((OCOperatorReference)reference).resolveToSymbols().isEmpty();
    }

    private static class Simplifier {
        private boolean equalToYesNoUsed;
        private boolean ifWithConstBranchUsed;
        private static Map<OCElementType, OCElementType> oppositeOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EXCLEQ), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GT), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LT)});

        private Simplifier() {
        }

        public boolean isWarningDisabled(OCSimplifyInspection inspection) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            return this.equalToYesNoUsed && !inspection.enableSimplifyEqualToYesNo || this.ifWithConstBranchUsed && !inspection.enableSimplifyIfWithConstantBranch;
        }

        @Nullable
        private PsiElement trySimplifyIfStatement(@NotNull OCIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$Simplifier", "trySimplifyIfStatement"));
            }
            OCDeclarationOrExpression condition = statement.getCondition();
            OCExpression expression = condition != null ? condition.getExpression() : null;
            OCStatement thenBranch = statement.getThenBranch();
            OCStatement elseBranch = statement.getElseBranch();
            if (expression == null) {
                return null;
            }
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(expression), condition);
            if (conditionValue != null) {
                return OCSimplifyInspection.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) != 0, statement);
            }
            if (thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, new OCResolveContext(statement)) && !OCCodeInsightUtil.hasSideEffects(condition)) {
                return thenBranch;
            }
            OCConvertIfToTernaryIntentionAction oCConvertIfToTernaryIntentionAction = new OCConvertIfToTernaryIntentionAction();
            ((Object)((Object)oCConvertIfToTernaryIntentionAction)).getClass();
            OCConvertIfToTernaryIntentionAction.Converter converter = new OCConvertIfToTernaryIntentionAction.Converter(oCConvertIfToTernaryIntentionAction, condition);
            if (!converter.isAvailable()) {
                return null;
            }
            return this.trySimplifyCondExpr(converter.getCondition(), converter.getThenExpression(), converter.getElseExpression());
        }

        private static PsiElement trySimplifyLoopStatement(@NotNull OCLoopStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$Simplifier", "trySimplifyLoopStatement"));
            }
            PsiElement condition = statement.getCondition();
            if (condition instanceof OCDeclarationOrExpression) {
                condition = ((OCDeclarationOrExpression)condition).getExpression();
            }
            if (!(condition instanceof OCExpression)) {
                return null;
            }
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate((OCExpression)condition), condition);
            if (conditionValue != null) {
                return OCSimplifyInspection.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) > 0, statement);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyCondExpr(@Nullable OCExpression condition, @Nullable OCExpression thenBranch, @Nullable OCExpression elseBranch) {
            if (condition == null || thenBranch == null || elseBranch == null) {
                return null;
            }
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(condition), condition);
            if (conditionValue != null) {
                return OCExpressionEvaluator.singAsInC(conditionValue) != 0 ? OCSimplifyInspection.simplify(thenBranch) : OCSimplifyInspection.simplify(elseBranch);
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(thenBranch, elseBranch, false, new OCResolveContext(condition)) && !OCCodeInsightUtil.hasSideEffects(condition)) {
                return OCSimplifyInspection.simplify(thenBranch);
            }
            if (OCParenthesesUtils.areExpressionsOpposite(thenBranch, elseBranch, false, new OCResolveContext(condition))) {
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), thenBranch, OCTokenTypes.EQEQ);
            }
            Object thenValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(thenBranch), thenBranch);
            Object elseValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(elseBranch), elseBranch);
            if (thenValue instanceof Boolean) {
                boolean bl = this.ifWithConstBranchUsed = !(elseValue instanceof Boolean);
                if (((Boolean)thenValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), elseBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition)), elseBranch, OCTokenTypes.ANDAND);
            }
            if (elseValue instanceof Boolean) {
                this.ifWithConstBranchUsed = true;
                if (((Boolean)elseValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition)), thenBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition), thenBranch, OCTokenTypes.ANDAND);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyBinaryExpr(@Nullable OCExpression left, @Nullable OCExpression right, OCElementType operator) {
            OCExpression otherOperand;
            boolean condition;
            if (left == null || right == null) {
                return null;
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(left, right, false, new OCResolveContext(left)) && !OCCodeInsightUtil.hasSideEffects(left) && !(left.getResolvedType() instanceof OCRealType)) {
                if (operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.OROR) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(left));
                }
                if (operator == OCTokenTypes.AND || operator == OCTokenTypes.OR) {
                    return OCSimplifyInspection.simplify(left);
                }
                if (operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constFalse(left);
                }
                if (operator == OCTokenTypes.EQEQ) {
                    return Simplifier.constTrue(left);
                }
            }
            if (OCParenthesesUtils.areExpressionsOpposite(left, right, false, new OCResolveContext(left)) && !OCCodeInsightUtil.hasSideEffects(left)) {
                if (operator == OCTokenTypes.OROR || operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constTrue(left);
                }
                if (operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.EQEQ) {
                    return Simplifier.constFalse(left);
                }
            }
            Object leftValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(left), left);
            Object rightValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(right), right);
            if (leftValue instanceof Boolean) {
                condition = (Boolean)leftValue;
                otherOperand = right;
            } else if (rightValue instanceof Boolean) {
                condition = (Boolean)rightValue;
                otherOperand = left;
            } else if (leftValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator)) {
                condition = OCExpressionEvaluator.singAsInC(leftValue) != 0;
                otherOperand = right;
            } else if (rightValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator)) {
                condition = OCExpressionEvaluator.singAsInC(rightValue) != 0;
                otherOperand = left;
            } else {
                return null;
            }
            if (operator == OCTokenTypes.EQEQ || operator == OCTokenTypes.EXCLEQ) {
                this.equalToYesNoUsed = true;
            }
            return Simplifier.trySimplifyLogicExpression(condition, left, otherOperand, operator);
        }

        private static OCExpression trySimplifyLogicExpression(boolean condition, OCExpression left, OCExpression otherOperand, OCElementType operator) {
            if (condition) {
                if (operator == OCTokenTypes.ANDAND || operator == OCTokenTypes.AND || operator == OCTokenTypes.EQEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(otherOperand));
                }
                if (!(operator != OCTokenTypes.OROR && operator != OCTokenTypes.OR || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constTrue(left);
                }
                if (operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            } else {
                if (!(operator != OCTokenTypes.ANDAND && operator != OCTokenTypes.AND || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constFalse(left);
                }
                if (operator == OCTokenTypes.OROR || operator == OCTokenTypes.XOR || operator == OCTokenTypes.EXCLEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(otherOperand));
                }
                if (operator == OCTokenTypes.EQEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            }
            return null;
        }

        @Nullable
        private static OCExpression trySimplifyUnaryExpr(@Nullable OCExpression operand, OCElementType operator) {
            if (operand == null || operator != OCTokenTypes.EXCL) {
                return null;
            }
            Number value = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(operand), operand);
            if (value != null) {
                return OCExpressionEvaluator.singAsInC(value) != 0 ? Simplifier.constFalse(operand) : Simplifier.constTrue(operand);
            }
            if ((operand = OCParenthesesUtils.diveIntoParentheses(operand)) == null || OCElementUtil.isPartOfMacroSubstitution(operand)) {
                return null;
            }
            if (operand instanceof OCUnaryExpression && ((OCUnaryExpression)operand).getOperationSign() == OCTokenTypes.EXCL) {
                return OCSimplifyInspection.simplify(Simplifier.ensureIsBoolean(((OCUnaryExpression)operand).getOperand()));
            }
            if (operand instanceof OCBinaryExpression && oppositeOperators.containsKey((Object)((OCBinaryExpression)operand).getOperationSign()) && !OCSimplifyInspection.isOverloadedOperatorUsage(operand)) {
                OCBinaryExpression binaryExpr = (OCBinaryExpression)operand;
                return Simplifier.binaryExpr(binaryExpr.getLeft(), binaryExpr.getRight(), oppositeOperators.get((Object)binaryExpr.getOperationSign()));
            }
            return null;
        }

        @Nullable
        private static OCExpression simplifyAndParenthesize(OCExpression expression, int parentPrecedence) {
            if (expression == null || OCElementUtil.isPartOfMacroSubstitution(expression)) {
                return expression;
            }
            if ((expression = OCSimplifyInspection.simplify(expression)) != null && OCParenthesesUtils.getPrecedence(expression, false) > parentPrecedence) {
                return OCParenthesesUtils.appendParentheses(expression);
            }
            return expression;
        }

        @Nullable
        private static OCExpression binaryExpr(@Nullable OCExpression left, @Nullable OCExpression right, @Nullable OCElementType operator) {
            if (left == null || right == null) {
                return null;
            }
            int precedence = OCParenthesesUtils.getPrecedence(operator);
            left = Simplifier.simplifyAndParenthesize(left, precedence);
            right = Simplifier.simplifyAndParenthesize(right, precedence);
            return OCSimplifyInspection.simplify(OCElementFactory.binaryExpression(left, right, operator));
        }

        @Nullable
        private static OCExpression negateExpr(@Nullable OCExpression operand) {
            if (operand == null) {
                return null;
            }
            operand = Simplifier.simplifyAndParenthesize(operand, OCParenthesesUtils.getPrecedence(OCTokenTypes.EXCL));
            return OCSimplifyInspection.simplify(OCElementFactory.unaryExpression(operand, OCTokenTypes.EXCL));
        }

        private static OCExpression constTrue(OCElement context) {
            return OCElementFactory.booleanConstant(true, context);
        }

        private static OCExpression constFalse(OCElement context) {
            return OCElementFactory.booleanConstant(false, context);
        }

        @Nullable
        private static OCExpression ensureIsBoolean(OCExpression expression) {
            if (expression == null) {
                return null;
            }
            OCType type = expression.getResolvedType();
            if (OCIntType.isBool(type, expression)) {
                return expression;
            }
            if (type instanceof OCStructType || type instanceof OCCppReferenceType || type instanceof OCBlockPointerType) {
                return null;
            }
            return Simplifier.binaryExpr(expression, OCElementFactory.expressionFromText(type.getDefaultValue(expression), expression, false), OCTokenTypes.EXCLEQ);
        }
    }

    private static abstract class SimplifyVisitor
    extends OCVisitor {
        private SimplifyVisitor() {
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression) {
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = simplifier.trySimplifyCondExpr(expression.getCondition(), expression.getPositiveExpression(true), expression.getNegativeExpression());
            this.simplifyAndParenthesize(expression, simplified, simplifier);
        }

        @Override
        public void visitIfStatement(OCIfStatement stmt) {
            Simplifier simplifier = new Simplifier();
            PsiElement simplified = simplifier.trySimplifyIfStatement(stmt);
            this.simplifyAndParenthesize(stmt, simplified, simplifier);
        }

        @Override
        public void visitWhileStatement(OCWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitForStatement(OCForStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression) {
            if (!OCSimplifyInspection.isOverloadedOperatorUsage(expression)) {
                Simplifier simplifier = new Simplifier();
                OCExpression simplified = simplifier.trySimplifyBinaryExpr(expression.getLeft(), expression.getRight(), expression.getOperationSign());
                this.simplifyAndParenthesize(expression, simplified, simplifier);
            }
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression) {
            if (!OCSimplifyInspection.isOverloadedOperatorUsage(expression)) {
                Simplifier simplifier = new Simplifier();
                OCExpression simplified = Simplifier.trySimplifyUnaryExpr(expression.getOperand(), expression.getOperationSign());
                this.simplifyAndParenthesize(expression, simplified, simplifier);
            }
        }

        private void simplifyAndParenthesize(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/inspections/OCSimplifyInspection$SimplifyVisitor", "simplifyAndParenthesize"));
            }
            PsiElement parent = element.getParent();
            while (parent instanceof OCParenthesizedExpression && simplified instanceof OCExpression && !OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)parent, (OCExpression)simplified)) {
                element = parent;
                parent = parent.getParent();
            }
            if (element instanceof OCExpression && simplified instanceof OCExpression && OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)element, (OCExpression)simplified)) {
                this.simplify(element, OCParenthesesUtils.appendParentheses((OCExpression)simplified), simplifier);
            } else {
                this.simplify(element, simplified, simplifier);
            }
        }

        protected abstract void simplify(@NotNull PsiElement var1, @Nullable PsiElement var2, Simplifier var3);
    }
}

