/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedIvarInspection
extends OCInspections.GeneralObjC {
    private static Key<IvarsInfo> IVARS_INFO_KEY = Key.create((String)"IVARS_INFO_KEY");
    public boolean releaseInDealloc = true;

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        CheckBox checkBox = new CheckBox("Release should be in dealloc or any of its callees", (InspectionProfileEntry)this, "releaseInDealloc");
        panel.add((Component)checkBox);
        return panel;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "inspectionStarted"));
        }
        if (!OCCompilerHelper.isArcDisabled(session.getFile())) {
            return;
        }
        IvarsInfo ivarsInfo = new IvarsInfo();
        session.putUserData(IVARS_INFO_KEY, (Object)ivarsInfo);
        session.getFile().accept((PsiElementVisitor)new InitialVisitor(ivarsInfo));
    }

    public static IvarsInfo startInspection(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "startInspection"));
        }
        OCNotReleasedIvarInspection inspection = new OCNotReleasedIvarInspection();
        LocalInspectionToolSession session = new LocalInspectionToolSession(file2, 0, file2.getTextLength());
        inspection.inspectionStarted(session, true);
        return (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "buildVisitor"));
        }
        final IvarsInfo ivarsInfo = (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerHelper.isArcDisabled(holder.getFile()) || ivarsInfo == null) {
            OCVisitor oCVisitor = new OCVisitor();
            if (oCVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "buildVisitor"));
            }
            return oCVisitor;
        }
        final OCRecursiveVisitor visitor = new OCRecursiveVisitor(){
            private OCMethodSymbol curMethod;

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression());
                if ("retain".equals(expression.getMessageSelector()) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression, this.curMethod, holder.getFile(), ivarsInfo) && !(expression.getParent() instanceof OCAssignmentExpression)) {
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression());
                OCExpression sourceExpression = expression.getSourceExpression();
                if (OCElementUtil.isRetainCall(sourceExpression, true) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression, this.curMethod, holder.getFile(), ivarsInfo)) {
                    if (sourceExpression instanceof OCSendMessageExpression) {
                        OCSendMessageExpression call = (OCSendMessageExpression)sourceExpression;
                        OCInstanceVariableSymbol receiver = OCNotReleasedIvarInspection.getReceiverIvar(call.getReceiverExpression());
                        if ("retain".equals(call.getMessageSelector()) && receiver != null && OCNotReleasedIvarInspection.isIvarReleased(receiver, call, this.curMethod, holder.getFile(), ivarsInfo)) {
                            return;
                        }
                    }
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitSynthesizeProperty(OCSynthesizeProperty statement) {
                OCInstanceVariableSymbol ivar;
                OCReferenceElement propertyRef = statement.getPropertyRef();
                OCReferenceElement ivarRef = statement.getInstanceVariableRef();
                if (propertyRef == null) {
                    return;
                }
                OCPropertySymbol property = (OCPropertySymbol)propertyRef.resolveToSymbol();
                if (property != null && !property.isRetained()) {
                    property = property.getAssociatedPropertyInPrivateCategory();
                }
                OCInstanceVariableSymbol oCInstanceVariableSymbol = ivar = property != null ? property.getAssociatedIvar() : null;
                if (ivar == null) {
                    OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)statement.getSymbol();
                    OCInstanceVariableSymbol oCInstanceVariableSymbol2 = ivar = synthesizeSymbol != null ? synthesizeSymbol.getIvarSymbol() : null;
                }
                if (property != null && ivar != null && property.isRetained() && !OCNotReleasedIvarInspection.isIvarReleased(ivar, holder.getFile(), ivarsInfo)) {
                    OCNotReleasedIvarInspection.this.reportWarning(ivar, ivarRef != null ? ivarRef : propertyRef, holder);
                }
            }

            @Override
            public void visitMethod(OCMethod method) {
                this.curMethod = (OCMethodSymbol)method.getSymbol();
                super.visitMethod(method);
                this.curMethod = null;
            }
        };
        final Ref isProcessed = Ref.create((Object)false);
        OCVisitor oCVisitor = new OCVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)isProcessed.get()).booleanValue()) {
                    element.getContainingFile().accept((PsiElementVisitor)visitor);
                    isProcessed.set((Object)true);
                }
            }
        };
        if (oCVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "buildVisitor"));
        }
        return oCVisitor;
    }

    public void reportWarning(OCInstanceVariableSymbol ivar, PsiElement element, ProblemsHolder holder) {
        String message = ivar.getNameWithKindUppercase() + " is not released in 'dealloc' method";
        IntentionWrapper fix = new IntentionWrapper((IntentionAction)new OCReleaseVariablesIntentionAction(Collections.singletonList(ivar)), holder.getFile());
        this.registerProblem(holder, null, null, holder.isOnTheFly(), element, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[]{fix});
    }

    public static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @NotNull PsiFile file2, @NotNull IvarsInfo ivarsInfo) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "isIvarReleased"));
        }
        if (ivarsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "isIvarReleased"));
        }
        return OCNotReleasedIvarInspection.isIvarReleased(ivar, null, null, file2, ivarsInfo);
    }

    private static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @Nullable PsiElement element, @Nullable OCMethodSymbol outerMethod, @NotNull PsiFile file2, @NotNull IvarsInfo ivarsInfo) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "isIvarReleased"));
        }
        if (ivarsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "isIvarReleased"));
        }
        if (!ivar.getType().resolve(file2).isPointerToObjectCompatible() || ivarsInfo.myReleasedIvars.contains(ivar)) {
            return true;
        }
        Map map = (Map)ivarsInfo.myLocalReleases.get(ivar);
        if (outerMethod != null && element != null && map != null) {
            PsiElement localRelease = (PsiElement)map.get(outerMethod);
            return localRelease != null && element.getTextOffset() < localRelease.getTextOffset();
        }
        return false;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "inspectionFinished"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection", "inspectionFinished"));
        }
        IvarsInfo ivarsInfo = (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerHelper.isArcDisabled(session.getFile()) || ivarsInfo == null) {
            return;
        }
        for (Pair pair : ivarsInfo.myLocalRetainedIvars) {
            if (OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)pair.getFirst(), holder.getFile(), ivarsInfo)) continue;
            this.reportWarning((OCInstanceVariableSymbol)pair.getFirst(), (PsiElement)pair.getSecond(), holder);
        }
        for (OCMethodSymbol method : ivarsInfo.myDeallocs.keySet()) {
            PsiFile file2;
            PsiElement closingBrace = (PsiElement)ivarsInfo.myDeallocs.get(method);
            if (closingBrace == null || !(file2 = closingBrace.getContainingFile()).equals(holder.getFile())) continue;
            String message = method.getNameWithKindUppercase() + " misses the call to [super dealloc] at the last statement";
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(file2, closingBrace.getTextOffset(), 0, "[super dealloc];\n", "Add call to [super dealloc]");
            this.registerProblem(holder, null, null, holder.isOnTheFly(), closingBrace, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
        }
    }

    @Nullable
    public static OCSendMessageExpression getCallToSuper(OCStatement stmt) {
        if (!(stmt instanceof OCExpressionStatement)) {
            return null;
        }
        OCExpression expression = ((OCExpressionStatement)stmt).getExpression();
        if (!(expression instanceof OCSendMessageExpression)) {
            return null;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)expression;
        OCExpression receiver = call.getReceiverExpression();
        return call.getMessageSelector().equals("dealloc") && receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER ? call : null;
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver) {
        return OCNotReleasedIvarInspection.getReceiverIvar(receiver, true);
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver, boolean onlySelf) {
        OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver, onlySelf);
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isRetained()) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar();
        }
        return null;
    }

    @Nullable
    public static OCSymbol getReceiverSymbol(@Nullable OCExpression receiver, boolean onlySelf) {
        OCSymbol symbol = null;
        if (receiver instanceof OCReferenceExpression) {
            symbol = ((OCReferenceExpression)receiver).resolveToSymbol();
        } else if (receiver instanceof OCQualifiedExpression) {
            OCExpression qualifier = ((OCQualifiedExpression)receiver).getQualifier();
            if (!onlySelf || qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                symbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
            }
        }
        return symbol;
    }

    private class InitialVisitor
    extends OCRecursiveVisitor {
        private IvarsInfo myIvarsInfo;
        private OCMethodSymbol curMethod;

        public InitialVisitor(IvarsInfo ivarsInfo) {
            if (ivarsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$InitialVisitor", "<init>"));
            }
            this.myIvarsInfo = ivarsInfo;
        }

        public void visitFile(PsiFile file2) {
            for (PsiElement element : file2.getChildren()) {
                if (!(element instanceof OCImplementation)) continue;
                this.myIvarsInfo.myTraversedCallables.clear();
                this.visitImplementation((OCImplementation)element);
            }
        }

        @Override
        public void visitImplementation(OCImplementation implementation) {
            OCImplementationSymbol originalClass;
            super.visitImplementation(implementation);
            final VirtualFile virtualFile = implementation.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OCObjectType type = implementation.getType();
            OCImplementationSymbol oCImplementationSymbol = originalClass = type != null ? type.getImplementation() : null;
            while (type != null) {
                OCImplementationSymbol symbol = type.getImplementation();
                if (symbol == null) {
                    OCInterfaceSymbol anInterface = type.getInterface();
                    OCImplementationSymbol oCImplementationSymbol2 = symbol = anInterface != null ? anInterface.getImplementation() : null;
                    if (symbol == null) break;
                }
                Processor<OCMethodSymbol> processor2 = new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        Object method = symbol.locateDefinition();
                        if (method instanceof OCMethod) {
                            OCBlockStatement body;
                            boolean isDealloc = "dealloc".equals(symbol.getName());
                            if (!InitialVisitor.this.myIvarsInfo.myTraversedCallables.contains(symbol)) {
                                InitialVisitor.this.myIvarsInfo.myTraversedCallables.add(symbol);
                                method.accept((PsiElementVisitor)new CallableVisitor(virtualFile, (OCClassSymbol)symbol.getParent(), originalClass, isDealloc, InitialVisitor.this.myIvarsInfo));
                            }
                            if (isDealloc && (body = ((OCMethod)method).getBody()) != null) {
                                PsiElement element;
                                int statementsCnt = body.getStatements().size();
                                PsiElement psiElement = element = statementsCnt > 0 ? OCNotReleasedIvarInspection.getCallToSuper(body.getStatements().get(statementsCnt - 1)) : null;
                                if (element == null) {
                                    element = body.getClosingBrace();
                                    InitialVisitor.this.myIvarsInfo.myDeallocs.put(symbol, element);
                                } else {
                                    InitialVisitor.this.myIvarsInfo.myDeallocs.put(symbol, null);
                                }
                            }
                        }
                        return true;
                    }
                };
                if (OCNotReleasedIvarInspection.this.releaseInDealloc) {
                    symbol.processMembers("dealloc", OCMethodSymbol.class, processor2);
                    OCType appDelegate = OCReferenceType.resolvedFromText("NSObject", "UIApplicationDelegate", implementation.getContainingFile());
                    OCType senTest = OCReferenceType.resolvedFromText("SenTest", implementation.getContainingFile());
                    OCType managedObject = OCReferenceType.resolvedFromText("NSManagedObject", implementation.getContainingFile());
                    if (appDelegate instanceof OCObjectType && appDelegate.isCompatible(type, implementation)) {
                        symbol.processMembers("applicationWillTerminate:", OCMethodSymbol.class, processor2);
                    }
                    if (managedObject instanceof OCObjectType && managedObject.isCompatible(type, implementation)) {
                        symbol.processMembers("didTurnIntoFault", OCMethodSymbol.class, processor2);
                    }
                    if (senTest instanceof OCObjectType && senTest.isCompatible(type, implementation)) {
                        symbol.processMembers("tearDown", OCMethodSymbol.class, processor2);
                    }
                } else {
                    symbol.processMembers(null, OCMethodSymbol.class, processor2);
                }
                type = type.getSuperType();
            }
        }

        @Override
        public void visitMethod(OCMethod method) {
            this.curMethod = (OCMethodSymbol)method.getSymbol();
            super.visitMethod(method);
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(method, null, null);
            analyzer.buildControlFlowGraph();
            for (OCSymbol symbol : analyzer.getGraph().getLocalSymbols()) {
                if (symbol.isUnnamed()) continue;
                analyzer.analyzeNotReleased(symbol, new OCNotReleasedVariablesChecker(analyzer.getGraph(), symbol){

                    @Override
                    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair) {
                        if (pair == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$InitialVisitor$2", "handleAssignedIvar"));
                        }
                        InitialVisitor.this.myIvarsInfo.myLocalRetainedIvars.add(pair);
                    }
                }, false);
            }
            this.curMethod = null;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression) {
            OCInstanceVariableSymbol ivar;
            super.visitSendMessageExpression(expression);
            if (this.curMethod != null && OCElementUtil.isReleaseCall(expression) && (ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression(), false)) != null) {
                HashMap<OCMethodSymbol, OCArgumentSelector> map = (HashMap<OCMethodSymbol, OCArgumentSelector>)this.myIvarsInfo.myLocalReleases.get(ivar);
                if (map == null) {
                    map = new HashMap<OCMethodSymbol, OCArgumentSelector>();
                    this.myIvarsInfo.myLocalReleases.put(ivar, map);
                }
                map.put(this.curMethod, expression.getArgumentSelectors().get(0));
            }
        }
    }

    private static class CallableVisitor
    extends OCRecursiveVisitor {
        private VirtualFile myContainingFile;
        private boolean isDealloc;
        private OCClassSymbol myClass;
        private IvarsInfo myIvarsInfo;
        private OCClassSymbol myOriginalClass;

        private CallableVisitor(VirtualFile containingFile, OCClassSymbol clazz, OCClassSymbol originalClass, boolean isDealloc, @NotNull IvarsInfo ivarsInfo) {
            if (ivarsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$CallableVisitor", "<init>"));
            }
            this.myContainingFile = containingFile;
            this.myOriginalClass = originalClass;
            this.isDealloc = isDealloc;
            this.myClass = clazz;
            this.myIvarsInfo = ivarsInfo;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression) {
            super.visitSendMessageExpression(expression);
            if (OCElementUtil.isReleaseCall(expression)) {
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression(), false);
                if (ivar != null) {
                    this.myIvarsInfo.myReleasedIvars.add(ivar);
                }
                return;
            }
            for (OCMethodSymbol method : expression.getProbableResponders().getFilteredByStaticnessResponders()) {
                OCPropertySymbol property = method.getGeneratedFromProperty();
                if (property != null) {
                    if (!method.isSetter()) continue;
                    this.processSetter(property);
                    continue;
                }
                this.processCallable(method);
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            OCClassSymbol symbolParent;
            super.visitQualifiedExpression(expression);
            PsiElement parent = expression.getParent();
            OCSymbol symbol = expression.resolveToSymbol();
            if (symbol instanceof OCMemberSymbol && (symbolParent = (OCClassSymbol)((OCMemberSymbol)symbol).getParent()) != null && Comparing.equal((String)symbolParent.getName(), (String)this.myClass.getName())) {
                if (this.isDealloc && symbol instanceof OCInstanceVariableSymbol) {
                    this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)symbol);
                } else if (symbol instanceof OCPropertySymbol && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == expression) {
                    this.processSetter((OCPropertySymbol)symbol);
                } else if (symbol instanceof OCMethodSymbol) {
                    this.processCallable(symbol);
                }
            }
        }

        @Override
        public void visitReferenceElement(OCReferenceElement referenceElement) {
            OCSymbol ivar;
            super.visitReferenceElement(referenceElement);
            if (this.isDealloc && (ivar = referenceElement.resolveToSymbol()) instanceof OCInstanceVariableSymbol) {
                this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)ivar);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            super.visitCallExpression(expression);
            OCExpression function = expression.getFunctionReferenceExpression();
            OCLValueVisitor visitor = new OCLValueVisitor();
            function.accept(visitor);
            OCSymbol functionSymbol = visitor.getSymbol();
            if (functionSymbol instanceof OCFunctionSymbol) {
                this.processCallable(functionSymbol);
            }
        }

        private void processSetter(OCPropertySymbol property) {
            OCInstanceVariableSymbol ivar;
            if (property.processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol method) {
                    if (method.isSetter()) {
                        CallableVisitor.this.processCallable(method);
                        return false;
                    }
                    return true;
                }
            }, false) && property.isRetained() && (ivar = property.getAssociatedIvar()) != null) {
                this.myIvarsInfo.myReleasedIvars.add(ivar);
            }
        }

        private void processCallable(OCSymbol callable) {
            OCSymbol targetCallable = callable;
            if (!targetCallable.isDefinition()) {
                targetCallable = targetCallable.getAssociatedSymbol();
            }
            if (callable instanceof OCMethodSymbol) {
                OCClassSymbol callableParent = (OCClassSymbol)((OCMethodSymbol)callable).getParent();
                if (this.myOriginalClass != null && (targetCallable == null || !Comparing.equal((String)callableParent.getName(), (String)this.myOriginalClass.getName())) && this.myOriginalClass.isSubclass(callableParent)) {
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    this.myOriginalClass.processMembers(callable.getName(), OCMethodSymbol.class, finder);
                    targetCallable = (OCSymbol)finder.getFoundValue();
                }
            }
            if (targetCallable != null && !this.myIvarsInfo.myTraversedCallables.contains(targetCallable) && this.myContainingFile.equals(targetCallable.getContainingFile())) {
                this.myIvarsInfo.myTraversedCallables.add(targetCallable);
                Object definition = targetCallable.locateDefinition();
                if (definition instanceof OCDeclarator) {
                    definition = definition.getParent();
                }
                if (definition instanceof OCCallable) {
                    boolean curDealloc = this.isDealloc;
                    this.isDealloc = false;
                    definition.accept((PsiElementVisitor)this);
                    this.isDealloc = curDealloc;
                }
            }
        }
    }

    public static class IvarsInfo {
        private Set<OCInstanceVariableSymbol> myReleasedIvars = new HashSet<OCInstanceVariableSymbol>();
        private Map<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>> myLocalReleases = new HashMap<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>>();
        private Set<OCSymbol> myTraversedCallables = new HashSet<OCSymbol>();
        private Map<OCMethodSymbol, PsiElement> myDeallocs = new HashMap<OCMethodSymbol, PsiElement>();
        private List<Pair<OCInstanceVariableSymbol, PsiElement>> myLocalRetainedIvars = new ArrayList<Pair<OCInstanceVariableSymbol, PsiElement>>();
    }
}

