/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCConvertObjCLiteralIntentionAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCLegacyObjCLiteralInspection
extends OCInspections.GeneralObjC {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Modern syntax can be used" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCLegacyObjCLiteralInspection", "getDisplayName"));
        }
        return "Modern syntax can be used";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/inspections/OCLegacyObjCLiteralInspection", "buildVisitor"));
        }
        OCVisitor oCVisitor = new OCVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expr) {
                OCConvertObjCLiteralIntentionAction.Converter converter = OCConvertObjCLiteralIntentionAction.findConverter(expr);
                if (converter != null) {
                    OCLegacyObjCLiteralInspection.this.registerProblem(holder, null, null, isOnTheFly, expr, "Modern syntax can be used", "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new OCConvertObjCLiteralIntentionAction(expr, converter));
                }
            }
        };
        if (oCVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCLegacyObjCLiteralInspection", "buildVisitor"));
        }
        return oCVisitor;
    }
}

