/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCStructureViewElement
implements StructureViewTreeElement {
    private final PsiElement myElement;
    private boolean mySeparator;
    private PsiElement myContext;

    public OCStructureViewElement(PsiElement element, boolean separator, PsiElement context) {
        this.myElement = element;
        this.mySeparator = separator;
        this.myContext = context;
    }

    public PsiElement getValue() {
        return this.myElement;
    }

    public boolean isAllowInheritorsAndCategories() {
        return this.myContext == null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        OCItemPresentation oCItemPresentation = this.mySeparator ? new OCItemPresentationWithSeparator(this.myElement) : new OCItemPresentation(this.myElement);
        if (oCItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCStructureViewElement", "getPresentation"));
        }
        return oCItemPresentation;
    }

    @NotNull
    public TreeElement[] getChildren() {
        if (this.myElement instanceof OCDeclarator || this.myElement instanceof OCFunctionDefinition || this.myElement instanceof OCMethod) {
            if (StructureViewTreeElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCStructureViewElement", "getChildren"));
            }
            return StructureViewTreeElement.EMPTY_ARRAY;
        }
        final ArrayList children2 = new ArrayList();
        this.myElement.acceptChildren((PsiElementVisitor)new OCVisitor(){

            @Override
            public void visitOCElement(OCElement elem) {
                if (this.worthyElement(elem)) {
                    children2.add(elem);
                } else if (!this.notWorthyElement(elem)) {
                    elem.acceptChildren(this);
                }
            }

            @Override
            public void visitPragma(OCPragma pragma) {
                String info;
                Pair<String, Boolean> markContent = pragma.getMarkContent();
                if (markContent == null) {
                    return;
                }
                if (((Boolean)markContent.second).booleanValue()) {
                    Object last;
                    Object v0 = last = children2.size() > 0 ? children2.get(children2.size() - 1) : null;
                    if (last instanceof PsiElement) {
                        children2.add(new Object());
                    }
                }
                if (!(info = (String)markContent.first).isEmpty()) {
                    children2.add(pragma);
                }
            }

            private boolean worthyElement(OCElement element) {
                return element instanceof OCDefineDirective || element instanceof OCDeclarator || element instanceof OCFunctionDefinition || element instanceof OCCppNamespace || element instanceof OCStructLike || element instanceof OCMethod || element instanceof OCInterface || element instanceof OCImplementation || element instanceof OCProtocol;
            }

            private boolean notWorthyElement(OCElement elem) {
                return elem instanceof OCTemplateParameterList;
            }
        });
        ArrayList<OCStructureViewElement> result2 = new ArrayList<OCStructureViewElement>();
        boolean nextSeparator = false;
        for (Object o : children2) {
            Object symbol;
            if (!(o instanceof PsiElement)) {
                nextSeparator = true;
                continue;
            }
            if ((o instanceof OCDeclarator || o instanceof OCStructLike) && (((PsiNamedElement)o).getName() == null || this.myContext != null && (symbol = ((OCSymbolDeclarator)o).getSymbol()) != null && !OCVisibility.isVisible(symbol, this.myContext, null))) continue;
            result2.add(new OCStructureViewElement((PsiElement)o, nextSeparator, this.myContext));
            nextSeparator = false;
        }
        TreeElement[] treeElementArray = result2.toArray(new TreeElement[result2.size()]);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCStructureViewElement", "getChildren"));
        }
        return treeElementArray;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Navigatable)this.myElement).canNavigateToSource();
    }

    private static class OCItemPresentationWithSeparator
    extends OCItemPresentation
    implements ItemPresentationWithSeparator {
        private OCItemPresentationWithSeparator(PsiElement element) {
            super(element);
        }
    }

    private static class OCItemPresentation
    implements ColoredItemPresentation {
        private final PsiElement myElement;
        private final OCSymbol mySymbol;

        private OCItemPresentation(PsiElement element) {
            this.myElement = element;
            this.mySymbol = this.myElement instanceof OCSymbolDeclarator && this.myElement.isValid() ? ((OCSymbolDeclarator)this.myElement).getSymbol() : null;
        }

        public String getPresentableText() {
            if (this.mySymbol instanceof OCMacroSymbol) {
                return ((OCMacroSymbol)this.mySymbol).getPresentableSignature();
            }
            if (this.mySymbol instanceof OCFunctionSymbol) {
                return ((OCFunctionSymbol)this.mySymbol).getSignatureWithoutParamNames();
            }
            if (this.mySymbol instanceof OCDeclaratorSymbol) {
                return OCItemPresentation.getPresentableText((OCDeclaratorSymbol)this.mySymbol);
            }
            if (this.mySymbol instanceof OCStructSymbol) {
                return OCItemPresentation.getPresentableText((OCStructSymbol)this.mySymbol);
            }
            if (this.myElement instanceof PsiFile) {
                return ((PsiFile)this.myElement).getName();
            }
            if (this.myElement instanceof OCMethod) {
                return ((OCMethod)this.myElement).getSelector();
            }
            if (this.myElement instanceof OCClassDeclaration) {
                OCClassDeclaration cls = (OCClassDeclaration)this.myElement;
                String name = cls.getName();
                if (name == null) {
                    return "<unnamed>";
                }
                return OCCodeInsightUtil.getClassNameWithCategory(name, cls.getCategory());
            }
            if (this.myElement instanceof OCPragma) {
                Pair<String, Boolean> mark = ((OCPragma)this.myElement).getMarkContent();
                return mark == null ? null : (String)mark.first;
            }
            if (this.myElement instanceof PsiNameIdentifierOwner) {
                String name = ((PsiNameIdentifierOwner)this.myElement).getName();
                if (name == null && this.myElement instanceof OCEnum) {
                    StringBuilder builder = new StringBuilder("enum {");
                    boolean first = true;
                    for (OCDeclaration field : ((OCEnum)this.myElement).getFields()) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append(", ");
                        }
                        if (builder.length() > 30) {
                            builder.append("...");
                            break;
                        }
                        builder.append(field.getDeclarators().get(0).getName());
                    }
                    builder.append("}");
                    return builder.toString();
                }
                return name == null ? "<unnamed>" : name;
            }
            return "<unknown>";
        }

        private static String getPresentableText(OCStructSymbol symbol) {
            return symbol.getQualifiedName().toString();
        }

        private static String getPresentableText(OCDeclaratorSymbol symbol) {
            String typeName;
            StringBuilder buffer = new StringBuilder();
            String symbolName = symbol.getQualifiedName().getCanonicalName(true);
            buffer.append(symbolName);
            if (symbol.getKind() != OCSymbolKind.ENUM_CONST && !Comparing.equal((String)(typeName = symbol.getType().getName()), (String)symbolName)) {
                buffer.append(" : ");
                buffer.append(typeName);
            }
            return buffer.toString();
        }

        public String getLocationString() {
            return null;
        }

        public Icon getIcon(boolean open2) {
            return this.myElement.isValid() ? this.myElement.getIcon(0) : null;
        }

        public TextAttributesKey getTextAttributesKey() {
            return this.myElement instanceof OCPragma ? TextAttributesKey.createTextAttributesKey((String)"OC_PRAGMA_MARK", (TextAttributes)new TextAttributes(JBColor.foreground(), null, null, null, 1)) : null;
        }
    }
}

