/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.OCSubTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OCTypeHierarchyTreeStructure
extends OCSubTypesHierarchyTreeStructure {
    public OCTypeHierarchyTreeStructure(Project project, OCClassDeclaration aClass) {
        super(project, OCTypeHierarchyTreeStructure.buildHierarchyElement(project, aClass));
        this.setBaseElement(this.myBaseDescriptor);
    }

    private static HierarchyNodeDescriptor buildHierarchyElement(Project project, OCClassDeclaration aClass) {
        OCClassHierarchyNodeDescriptor<OCClassDeclaration> descriptor = null;
        List<OCClassDeclaration> superClasses = OCTypeHierarchyTreeStructure.createSuperClasses(aClass);
        for (OCClassDeclaration superClass : superClasses) {
            OCClassHierarchyNodeDescriptor<OCClassDeclaration> newDescriptor = new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(project, (NodeDescriptor)descriptor, superClass, false);
            if (descriptor != null) {
                descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        OCClassHierarchyNodeDescriptor<OCClassDeclaration> newDescriptor = new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(project, (NodeDescriptor)descriptor, aClass, true);
        if (descriptor != null) {
            descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static List<OCClassDeclaration> createSuperClasses(OCClassDeclaration aClass) {
        OCInterface superType;
        if (!aClass.isValid()) {
            return Collections.emptyList();
        }
        if (aClass instanceof OCProtocol) {
            return Collections.emptyList();
        }
        ArrayList<OCClassDeclaration> answer = new ArrayList<OCClassDeclaration>();
        while (!"NSObject".equals(aClass.getName()) && (superType = aClass.getSuperClass()) != null && !answer.contains(superType)) {
            answer.add(0, superType);
            aClass = superType;
        }
        return answer;
    }
}

