/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateInitWithHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    protected static final OCBooleanOption RETAIN_OBJECTS = new OCBooleanOption("Retain object parameters");
    protected static final OCBooleanOption USE_SETTERS = new OCBooleanOption("Use property setters");
    protected static final OCBooleanOption GENERATE_CLASS_CONSTRUCTOR = new OCBooleanOption("Generate \"+objectWith...\"");

    @Override
    protected String getActionTitle() {
        return "Generate -initWith";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members to be Initialized";
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCGenerateMethodActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler", "loadOptions"));
        }
        ArrayList<Pair<OCOption, Object>> result2 = new ArrayList<Pair<OCOption, Object>>();
        if (OCCompilerHelper.isArcDisabled(file2)) {
            result2.add(new Pair((Object)RETAIN_OBJECTS, (Object)(settings == null || settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR ? 1 : 0)));
        }
        result2.add(new Pair((Object)USE_SETTERS, (Object)(settings != null && settings.USE_SETTERS_IN_CONSTRUCTOR ? 1 : 0)));
        result2.add(new Pair((Object)GENERATE_CLASS_CONSTRUCTOR, (Object)(settings != null && settings.GENERATE_CLASS_CONSTRUCTOR ? 1 : 0)));
        return result2;
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler", "saveOptions"));
        }
        if (OCCompilerHelper.isArcDisabled(file2)) {
            settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, RETAIN_OBJECTS);
        }
        settings.USE_SETTERS_IN_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, USE_SETTERS);
        settings.GENERATE_CLASS_CONSTRUCTOR = OCGenerateInitWithHandler.getOption(optionValues, GENERATE_CLASS_CONSTRUCTOR);
    }

    private static boolean useInstanceType(PsiFile file2) {
        return OCCompilerHelper.supportsInstancetype(file2);
    }

    @Override
    @NotNull
    protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCObjectType type = parent.getResolvedType(true);
        if (type != null) {
            type.processMembers("init", OCMethodSymbol.class, finder);
        }
        OCGenerateMethodActionContext oCGenerateMethodActionContext = new OCGenerateMethodActionContext(parent, Collections.singletonList(finder.getFoundValue()), type, element);
        if (oCGenerateMethodActionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler", "evaluateActionContext"));
        }
        return oCGenerateMethodActionContext;
    }

    @Override
    protected void performAction(Project project, Editor editor, PsiFile file2, OCGenerateMethodActionContext context, List<OCInstanceVariableSymbol> ivars) {
        if (!ivars.isEmpty()) {
            OCClassSymbol classSymbol = (OCClassSymbol)ivars.get(0).getParent();
            final StringBuilder signature = new StringBuilder();
            OCMethod method = OCElementFactory.methodFromSignature(OCGenerateInitWithHandler.getMethodSignature(context.getBaseMethod(), ivars, this.getOption(context, USE_SETTERS), file2), (PsiElement)file2, false, false);
            final OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)method, classSymbol.getContainingOCFile());
            handler2.setChangeUsages(false);
            handler2.getGeneratedInfo().setMethodParent(classSymbol);
            handler2.getGeneratedInfo().runOnSuccess(new Runnable(){

                @Override
                public void run() {
                    signature.append(handler2.getNewSignature());
                }
            });
            handler2.setTitle(this.getActionTitle());
            handler2.setRefactorButtonText("Generate");
            handler2.invoke();
            context.setMethodSignature(signature.length() > 0 ? signature.toString() : null);
            context.setParameters(handler2.getParameters());
        }
        super.performAction(project, editor, file2, context, ivars);
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    private static String getMethodSignature(OCMethodSymbol baseMethod, List<OCInstanceVariableSymbol> ivars, boolean useSetters, PsiFile file2) {
        StringBuilder signature = new StringBuilder();
        signature.append(baseMethod.isStatic() ? (char)'+' : '-');
        if (OCGenerateInitWithHandler.useInstanceType(file2)) {
            signature.append("(instancetype)");
        } else {
            signature.append('(').append(baseMethod.getReturnType().getBestNameInContext((PsiElement)file2)).append(')');
        }
        boolean first = true;
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            if (property != null && property.isReadonly()) {
                property = property.getAssociatedPropertyInPrivateCategory();
            }
            if (first) {
                signature.append("initWith").append(StringUtil.capitalize((String)OCNameSuggester.getNonCollidingName(ivar, true)));
            } else {
                signature.append(' ').append(OCNameSuggester.getNonCollidingName(ivar, true));
            }
            first = false;
            boolean useProperty = useSetters && property != null && !property.isReadonly();
            signature.append(":(").append(ivar.getType().getBestNameInContext((PsiElement)file2)).append(')').append(OCNameSuggester.getNonCollidingName(ivar, useProperty));
        }
        return signature.toString();
    }

    @Override
    protected String getInsertText(PsiElement element, PsiElement at, List<OCInstanceVariableSymbol> ivars, OCGenerateMethodActionContext context) {
        String methodSignature = context.getMethodSignature();
        if (ivars.isEmpty()) {
            if (element instanceof OCImplementation) {
                return OCCallableUtil.methodText(context.getBaseMethod(), null, element);
            }
            return null;
        }
        if (methodSignature != null) {
            boolean useSetters = this.getOption(context, USE_SETTERS);
            boolean retainObjects = OCCompilerHelper.isArcDisabled(element.getContainingFile()) && this.getOption(context, RETAIN_OBJECTS) != false;
            boolean generateClassConstructor = this.getOption(context, GENERATE_CLASS_CONSTRUCTOR);
            String objectSignature = OCGenerateInitWithHandler.getObjectMethodSignature(methodSignature, true, context.getType(), element.getContainingFile());
            if (element instanceof OCImplementation) {
                PsiFile file2 = element.getContainingFile();
                String initializerText = OCGenerateInitWithHandler.getInitializerText(ivars, context.getParameters(), 0, file2, useSetters, retainObjects, context.getNonReleasedIvars());
                StringBuilder result2 = new StringBuilder();
                result2.append(OCCallableUtil.methodWithSignature(context.getBaseMethod(), methodSignature, initializerText, element));
                if (generateClassConstructor && objectSignature != null) {
                    String callText = OCGenerateInitWithHandler.getClassConstructorText((OCImplementation)element, context);
                    result2.append(OCCallableUtil.methodText(objectSignature, callText, element));
                }
                return result2.toString();
            }
            StringBuilder result3 = new StringBuilder();
            result3.append(methodSignature).append(";\n");
            if (generateClassConstructor && objectSignature != null) {
                result3.append(objectSignature).append(";\n");
            }
            return result3.toString();
        }
        return null;
    }

    @Nullable
    public static String getObjectMethodSignature(String methodSignature, boolean appendReturnType, OCObjectType type, PsiFile file2) {
        String prefixName;
        int pos = methodSignature.indexOf("initWith");
        pos = pos != -1 ? pos + "initWith".length() : methodSignature.indexOf(58);
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)type, null, "");
        String string = prefixName = suggestions.isEmpty() ? "object" : suggestions.iterator().next();
        String returnType = appendReturnType ? (OCGenerateInitWithHandler.useInstanceType(file2) ? "+(instancetype)" : "+(id)") : "";
        String objectSignature = pos != -1 ? returnType + prefixName + "With" + methodSignature.substring(pos) : null;
        return objectSignature;
    }

    private static String getClassConstructorText(OCImplementation element, OCGenerateMethodActionContext context) {
        StringBuilder text = new StringBuilder("return ");
        if (OCCompilerHelper.isArcDisabled(element.getContainingFile())) {
            text.append("[");
        }
        text.append("[[self alloc] ");
        for (OCParameterInfo param : context.getParameters()) {
            text.append(param.getSelector()).append(":").append(param.getName()).append(' ');
        }
        if (OCCompilerHelper.isArcDisabled(element.getContainingFile())) {
            text.append("] autorelease");
        }
        text.append("];");
        return text.toString();
    }

    public static String getInitializerText(List<OCInstanceVariableSymbol> ivars, List<OCParameterInfo> parameters, int atIndex, @NotNull PsiFile implementationFile, boolean useSetters, boolean retainObjects, List<OCInstanceVariableSymbol> nonReleasedIvars) {
        if (implementationFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementationFile", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateInitWithHandler", "getInitializerText"));
        }
        StringBuilder initialization = new StringBuilder();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(implementationFile);
        for (OCParameterInfo parameter : parameters) {
            int index = parameter.getOldIndex() - atIndex;
            if (index < 0 || index >= ivars.size()) continue;
            OCInstanceVariableSymbol ivar = ivars.get(index);
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type = ivar.getResolvedType();
            if (property != null && property.isReadonly()) {
                OCPropertySymbol associatedProperty = property.getAssociatedPropertyInPrivateCategory();
                OCPropertySymbol oCPropertySymbol = property = associatedProperty != null ? associatedProperty : property;
            }
            if (initialization.length() > 0) {
                initialization.append("\n");
            }
            if (useSetters && property != null && !property.isReadonly()) {
                initialization.append("self.").append(property.getName()).append('=');
                initialization.append(parameter.getName()).append(";");
                continue;
            }
            if (retainObjects && type.isPointerToObjectCompatible() && OCCompilerHelper.isArcDisabled(implementationFile)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName());
                if (type.isPointerToString()) {
                    initialization.append(" copy];");
                } else {
                    initialization.append(" retain];");
                }
                if (!OCCompilerHelper.isArcDisabled(implementationFile) || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, implementationFile, ivarsInfo)) continue;
                nonReleasedIvars.add(ivar);
                continue;
            }
            if (property != null && property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                initialization.append(ivar.getName()).append('=');
                initialization.append("[").append(parameter.getName()).append(" copy];");
                continue;
            }
            initialization.append(ivar.getName()).append('=');
            initialization.append(parameter.getName()).append(";");
        }
        return initialization.toString();
    }

    @Override
    protected void performAction(Project project, PsiElement element, int caretPos, PsiElement at, List<OCInstanceVariableSymbol> members, OCGenerateMethodActionContext context) {
        super.performAction(project, element, caretPos, at, members, context);
        if (element instanceof OCImplementation && !context.getNonReleasedIvars().isEmpty()) {
            new OCReleaseVariablesIntentionAction(context.getNonReleasedIvars()).invoke(project, null, element.getContainingFile());
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (((OCClassSymbol)member.getParent()).isSameCategory(context.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, (OCSymbol)member.getParent(), false).fixFirstItem(project, element.getContainingFile());
            }
        }
    }

    @Override
    protected boolean shouldSelectResult(OCBlockStatement body) {
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> ivars, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InitMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }
}

