/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCCppClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDestructorHandler
extends OCCppClassTextActionHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol>> {
    @Override
    protected String getActionTitle() {
        return "Generate Destructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Pair<List<PsiElement>, Integer> getElementsToModify(OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> context) {
        Object element = ((OCStructSymbol)context.getParent()).locateDefinition();
        return new Pair(Collections.singletonList(element != null ? element : context.getContext().getContainingFile()), (Object)0);
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> context) {
        return true;
    }

    @Override
    protected void consumeParent(List<OCStructSymbol> parents, OCMembersContainer parent) {
        if (parent instanceof OCStructSymbol) {
            parents.add((OCStructSymbol)parent);
        }
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> evaluateActionContext(OCStructSymbol parent, PsiElement element) {
        return new OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol>(parent, element){

            @Override
            @NotNull
            public Collection<OCDeclaratorSymbol> getMemberCandidates() {
                List<OCDeclaratorSymbol> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateDestructorHandler$1", "getMemberCandidates"));
                }
                return list;
            }
        };
    }

    @Override
    protected void performAction(Project project, Editor editor, PsiFile file2, OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> context, List<OCDeclaratorSymbol> members) {
        if (!((OCStructSymbol)context.getParent()).processMembers("~" + ((OCStructSymbol)context.getParent()).getName(), (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
            int code;
            String message = "Destructor is already defined.\nDo you wish to continue?";
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 1 : Messages.showYesNoDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code != 0) {
                return;
            }
        }
        super.performAction(project, editor, file2, context, members);
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCDeclaratorSymbol> members, OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> actionContext) {
        if (element instanceof OCStruct && (at == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)at, (boolean)false))) {
            List<OCFunctionDeclaration> constructors = ((OCStruct)element).getConstructors();
            if (!constructors.isEmpty()) {
                return constructors.get(constructors.size() - 1).getNextSibling().getTextOffset();
            }
            return ((OCStruct)element).getFunctionsStartOffset();
        }
        return super.getInsertPosition(element, caretOffset, at, members, actionContext);
    }

    @Override
    @Nullable
    protected String getInsertText(PsiElement element, PsiElement at, List<OCDeclaratorSymbol> members, OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> context) {
        StringBuilder builder = new StringBuilder();
        int position = this.getInsertPosition(element, 0, at, members, context);
        OCVisibility contextVisibility = OCGenerateDestructorHandler.getVisibilityAtOffset(element, position);
        if (contextVisibility != OCVisibility.PUBLIC) {
            builder.append("public:");
        }
        if (((OCStructSymbol)context.getParent()).getKind() != OCSymbolKind.UNION) {
            builder.append("virtual ");
        }
        builder.append("~").append(((OCStructSymbol)context.getParent()).getName()).append("(){}\n");
        if (contextVisibility != OCVisibility.PUBLIC && OCGenerateDestructorHandler.needRestoreVisibility(element, position)) {
            builder.append((Object)contextVisibility).append(":\n");
        }
        return builder.toString();
    }
}

