/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.generate.actions.OCCppClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateGetterSetterContext;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateCppGetterSetterHandlerBase
extends OCCppClassTextActionHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateGetterSetterContext> {
    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to " + this.getActionTitle();
    }

    @Override
    protected void consumeParent(List<OCStructSymbol> parents, OCMembersContainer parent) {
        if (parent instanceof OCStructSymbol) {
            parents.add((OCStructSymbol)parent);
        }
    }

    @Override
    protected Pair<List<PsiElement>, Integer> getElementsToModify(OCGenerateGetterSetterContext context) {
        Object element = ((OCStructSymbol)context.getParent()).locateDefinition();
        return new Pair(Collections.singletonList(element != null ? element : context.getContext().getContainingFile()), (Object)0);
    }

    @Override
    @Nullable
    protected String getInsertText(PsiElement element, PsiElement at, List<OCDeclaratorSymbol> fields, OCGenerateGetterSetterContext context) {
        StringBuilder builder = new StringBuilder();
        int position = this.getInsertPosition(element, 0, at, fields, context);
        OCVisibility contextVisibility = OCGenerateCppGetterSetterHandlerBase.getVisibilityAtOffset(element, position);
        if (contextVisibility != OCVisibility.PUBLIC) {
            builder.append("public:");
        }
        for (OCDeclaratorSymbol field : fields) {
            OCType type = field.getType();
            boolean disallowConst = type instanceof OCPointerType && (!(type instanceof OCArrayType) || field.isStatic()) || type instanceof OCCppReferenceType;
            type = OCTypeUtils.getExtractExpressionType(type, context.getContext(), disallowConst);
            if (context.needGetter(field)) {
                OCFunctionType getterType = new OCFunctionType(type, Collections.emptyList());
                if (field.isStatic()) {
                    builder.append("static ");
                }
                builder.append(type.getBestNameInContext(context.getContext())).append(' ');
                builder.append(OCTypeNameVisitor.getFunctionSignature(context.getContext(), getterType, OCNameSuggester.getCppGetterName(field), true, null));
                if (!field.isStatic()) {
                    builder.append("const ");
                }
                builder.append("{\nreturn ").append(field.getName()).append(";\n}\n");
            }
            if (!context.needSetter(field)) continue;
            String paramName = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field);
            OCFunctionType setterType = new OCFunctionType(OCVoidType.instance(), Collections.singletonList(type), Collections.singletonList(paramName));
            if (field.isStatic()) {
                builder.append("static ");
            }
            builder.append("void ").append(OCTypeNameVisitor.getFunctionSignature(context.getContext(), setterType, OCNameSuggester.getCppSetterName(field), true, null));
            builder.append("{\n");
            if (paramName.equals(field.getName())) {
                builder.append(((OCStructSymbol)context.getParent()).getName()).append("::");
            }
            builder.append(field.getName()).append(" = ").append(paramName).append(";\n}\n");
        }
        if (contextVisibility != OCVisibility.PUBLIC && OCGenerateCppGetterSetterHandlerBase.needRestoreVisibility(element, position)) {
            builder.append((Object)contextVisibility).append(":\n");
        }
        return builder.toString();
    }
}

