/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCppClassTextActionHandlerBase<P extends OCMembersContainer, M extends OCSymbolWithQualifiedName<?>, C extends OCCppActionContext<P, M>>
extends OCClassTextActionHandlerBase<P, M, C> {
    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return OCCodeInsightUtil.isValid((PsiElement)file2);
    }

    @Override
    protected Pair<List<PsiElement>, Integer> getElementsToModify(C context) {
        Object element;
        ArrayList<OCFile> list = new ArrayList<OCFile>();
        OCFile file2 = (OCFile)((OCActionContext)context).getContext().getContainingFile();
        int originalFileIndex = -1;
        if (file2.isHeader()) {
            OCFile associatedFile = file2.getAssociatedFile();
            if (associatedFile != null) {
                file2 = associatedFile;
            }
        } else {
            originalFileIndex = 0;
        }
        list.add(file2);
        if (((OCActionContext)context).getParent() instanceof OCSymbol && (element = ((OCSymbol)((OCActionContext)context).getParent()).locateDefinition()) != null) {
            list.add((OCFile)element);
            if (PsiTreeUtil.isAncestor(element, (PsiElement)((OCActionContext)context).getContext(), (boolean)false)) {
                originalFileIndex = 1;
            }
        }
        return new Pair(list, (Object)originalFileIndex);
    }

    protected boolean continueWithAllParents() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/actions/OCCppClassTextActionHandlerBase", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/generate/actions/OCCppClassTextActionHandlerBase", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCCppActionContext context = null;
        int numOfParents = 0;
        if (editor != null) {
            PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
            Object element = at != null ? at : file2;
            List<P> parents = this.getParents((PsiElement)element);
            numOfParents = parents.size();
            if (numOfParents > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                final JBList list = new JBList(parents);
                list.setCellRenderer((ListCellRenderer)new NavigationItemListCellRenderer());
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Destination").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((PsiElement)element, project, editor, file2){
                    final /* synthetic */ PsiElement val$element;
                    final /* synthetic */ Project val$project;
                    final /* synthetic */ Editor val$editor;
                    final /* synthetic */ PsiFile val$file;
                    {
                        this.val$element = psiElement;
                        this.val$project = project;
                        this.val$editor = editor;
                        this.val$file = psiFile;
                    }

                    @Override
                    public void run() {
                        OCCppActionContext context = (OCCppActionContext)OCCppClassTextActionHandlerBase.this.evaluateActionContext((OCMembersContainer)list.getSelectedValue(), this.val$element);
                        if (OCCppClassTextActionHandlerBase.this.checkContext(this.val$project, this.val$editor, context)) {
                            OCCppClassTextActionHandlerBase.this.invoke(this.val$project, this.val$editor, this.val$file, context);
                        }
                    }
                }).setFilteringEnabled((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return ((OCMembersContainer)o).getPresentableName();
                    }
                }).createPopup().showInBestPositionFor(editor);
                return;
            }
            if (numOfParents != 0) {
                context = (OCCppActionContext)this.evaluateActionContext((OCMembersContainer)parents.get(parents.size() - 1), (PsiElement)element);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)this.getNoParentsMessage(), (String)this.getActionTitle(), null);
                return;
            }
        }
        if (this.checkContext(project, editor, context)) {
            this.invoke(project, editor, file2, context);
            if (numOfParents > 1 && this.continueWithAllParents()) {
                this.invoke(project, editor, file2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<P> getParents(final PsiElement context) {
        OCFile header;
        OCFile file2 = (OCFile)context.getContainingFile();
        OCStructLike struct = (OCStructLike)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCUnion.class});
        ArrayList parents = new ArrayList();
        if (struct != null) {
            OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
            if (symbol == null || symbol.isPredeclaration()) return parents;
            this.consumeParent(parents, symbol);
            return parents;
        }
        CommonProcessors.CollectProcessor<OCStructSymbol> collector = new CommonProcessors.CollectProcessor<OCStructSymbol>(){

            protected boolean accept(OCStructSymbol symbol) {
                return (symbol.getKind() == OCSymbolKind.STRUCT || symbol.getKind() == OCSymbolKind.UNION) && !symbol.isPredeclaration();
            }
        };
        OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCStructSymbol>)collector, OCStructSymbol.class);
        file2.processSymbolsRecursively(processor2);
        OCFile oCFile = header = file2.isHeader() ? file2 : file2.getAssociatedFile();
        if (!file2.isHeader() && header != null) {
            header.processSymbolsRecursively(processor2);
        }
        OCCppNamespace namespace = (OCCppNamespace)PsiTreeUtil.getParentOfType((PsiElement)context, OCCppNamespace.class);
        for (OCStructSymbol parent : collector.getResults()) {
            this.consumeParent(parents, parent);
        }
        if (header == null) return ContainerUtil.filter(parents, (Condition)new Condition<P>(){

            public boolean value(P container) {
                OCCppActionContext actionContext = (OCCppActionContext)OCCppClassTextActionHandlerBase.this.evaluateActionContext(container, context);
                return actionContext != null && (!actionContext.getMemberCandidates().isEmpty() || OCCppClassTextActionHandlerBase.this.allowEmptySelection(actionContext));
            }
        });
        if (namespace != null) {
            OCNamespaceSymbol namespaceSymbol;
            OCNamespaceSymbol oCNamespaceSymbol = namespaceSymbol = file2.isHeader() ? (OCNamespaceSymbol)namespace.getSymbol() : header.findSymbol(namespace.getName(), OCNamespaceSymbol.class);
            if (namespaceSymbol == null) return Collections.emptyList();
            parents.clear();
            for (OCStructSymbol parent : collector.getResults()) {
                if (parent.getParent() != namespaceSymbol) continue;
                this.consumeParent(parents, parent);
            }
            this.consumeParent(parents, namespaceSymbol);
            return ContainerUtil.filter(parents, (Condition)new /* invalid duplicate definition of identical inner class */);
        } else {
            this.consumeParent(parents, header.getMembersContainer(false));
        }
        return ContainerUtil.filter(parents, (Condition)new /* invalid duplicate definition of identical inner class */);
    }

    protected String getNoParentsMessage() {
        return "No classes to " + this.getActionTitle().toLowerCase();
    }

    protected abstract void consumeParent(List<P> var1, OCMembersContainer var2);

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<M> members, C actionContext) {
        if ((at = this.getInsertContext(element, at, actionContext)) == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(at)) && at == element.getLastChild()) {
            return element.getTextRange().getEndOffset();
        }
        int offset = at.getTextRange().getStartOffset();
        if (element instanceof OCStruct && ((OCStruct)element).getHeaderRange().containsOffset(offset)) {
            return ((OCStruct)element).getFunctionsStartOffset();
        }
        return offset;
    }

    @Override
    protected boolean shouldSelectResult(OCBlockStatement body) {
        return true;
    }

    @Nullable
    protected PsiElement getInsertContext(PsiElement element, PsiElement at, C actionContext) {
        PsiElement anchor;
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class});
        boolean afterClass = element instanceof PsiFile && parent instanceof OCStruct;
        PsiElement psiElement = parent = parent instanceof OCCppNamespace ? parent : element;
        if (element instanceof OCFile && at == null && ((OCActionContext)actionContext).getParent() instanceof OCNamespaceSymbol) {
            parent = OCChangeUtil.findInsertionParentInFile((OCFile)element, (OCNamespaceSymbol)((OCActionContext)actionContext).getParent());
        }
        at = (anchor = OCChangeUtil.getRealAnchorForInsertion(parent, at)) != null ? anchor : at;
        return afterClass ? at.getNextSibling() : at;
    }

    @Nullable
    protected static OCVisibility getVisibilityAtOffset(PsiElement element, int offset) {
        PsiElement kid;
        if (!(element instanceof OCStructLike)) {
            return null;
        }
        OCStructLike elementStruct = (OCStructLike)element;
        for (kid = element.getContainingFile().findElementAt(offset); kid != null && kid.getParent() != element; kid = kid.getParent()) {
        }
        if (kid != null) {
            kid = kid.getPrevSibling();
        }
        while (kid != null) {
            OCVisibility visibility = OCVisibility.getVisibilityFromElement(kid);
            if (visibility != null) {
                return visibility;
            }
            kid = kid.getPrevSibling();
        }
        return elementStruct.getDefaultVisibility();
    }

    protected static boolean needRestoreVisibility(PsiElement element, int offset) {
        if (!(element instanceof OCStruct)) {
            return false;
        }
        PsiElement at = element.getContainingFile().findElementAt(offset);
        PsiElement nextLeaf = at != null ? PsiTreeUtil.firstChild((PsiElement)at) : null;
        IElementType leafType = OCElementUtil.getElementType(nextLeaf);
        while (nextLeaf != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leafType)) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            leafType = OCElementUtil.getElementType(nextLeaf);
        }
        return nextLeaf == null || !OCElementUtil.isCPPVisibilityKeyword(nextLeaf.getNode()) && (leafType != OCTokenTypes.RBRACE || !(nextLeaf.getParent() instanceof OCStruct));
    }
}

