/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OCActionContext<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>> {
    protected P myParent;
    protected PsiElement myContext;
    private Map<OCOption, Object> myOptionValues;

    public OCActionContext(P parent, PsiElement context) {
        this.myParent = parent;
        this.myContext = context;
    }

    public P getParent() {
        return this.myParent;
    }

    public boolean isValid() {
        return this.myParent != null && (!(this.myParent instanceof OCSymbol) || !((OCSymbol)this.myParent).isPredeclaration());
    }

    public List<? extends OCSymbol> getSymbolsToModify() {
        return this.myParent instanceof OCSymbol ? Collections.singletonList((OCSymbol)this.myParent) : Collections.emptyList();
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public Map<OCOption, Object> getOptionValues() {
        return this.myOptionValues;
    }

    public void setOptionValues(Map<OCOption, Object> optionValues) {
        this.myOptionValues = optionValues;
    }

    @NotNull
    public abstract Collection<M> getMemberCandidates();

    public abstract Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> var1);

    public String getParentNameUppercase() {
        return "'" + this.myParent.getPresentableName() + "'";
    }
}

