/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleBlock
implements Block,
OCIndentChanger {
    @NotNull
    protected OCCodeBlock myOwnerBlock;
    @NotNull
    private List<Block> myBlocks;
    @NotNull
    private Indent myIndent;
    private TextRange myTextRange;
    @Nullable
    private Wrap myWrap;
    @Nullable
    private Alignment myAlignment;
    @NotNull
    private ASTNode myFirst;
    @NotNull
    private ASTNode myLast;

    public OCSimpleBlock(@Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> blocks) {
        if (ownerBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlock", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "<init>"));
        }
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "<init>"));
        }
        assert (!blocks.isEmpty());
        this.myOwnerBlock = ownerBlock;
        this.myBlocks = blocks;
        this.myIndent = indent != null ? indent : Indent.getNoneIndent();
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myFirst = OCSimpleBlock.extractFirstNode(this.myBlocks.get(0));
        this.myLast = OCSimpleBlock.extractLastNode(this.myBlocks.get(this.myBlocks.size() - 1));
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange == null) {
            this.myTextRange = OCSimpleBlock.getRangeFromSubBlocks(this);
        }
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getSubBlocks"));
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        Indent indent = this.myIndent;
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getIndent"));
        }
        return indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getSpacing"));
        }
        return this.myOwnerBlock.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block child = this.getSubBlocks().get(newChildIndex - 1);
        if (child instanceof ASTBlock && OCElementUtil.getElementType(((ASTBlock)child).getNode()) == OCTokenTypes.LBRACE) {
            ChildAttributes childAttributes = this.myOwnerBlock.getChildAttributes(1);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(child.getIndent(), child.getAlignment());
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myOwnerBlock.isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return OCSimpleBlock.getTextFromRange(this.myOwnerBlock.getNode(), this.getTextRange());
    }

    public ASTNode getFirstNode() {
        return this.myFirst;
    }

    public ASTNode getLastNode() {
        return this.myLast;
    }

    @Contract(value="null->null")
    public static ASTNode extractFirstNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getFirstNode();
        }
        return null;
    }

    @Contract(value="null->null")
    public static ASTNode extractLastNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getLastNode();
        }
        return null;
    }

    @NotNull
    public static TextRange getRangeFromSubBlocks(@NotNull Block block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getRangeFromSubBlocks"));
        }
        List blocks = block.getSubBlocks();
        TextRange textRange = blocks.size() == 0 ? TextRange.EMPTY_RANGE : new TextRange(((Block)blocks.get(0)).getTextRange().getStartOffset(), ((Block)blocks.get(blocks.size() - 1)).getTextRange().getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getRangeFromSubBlocks"));
        }
        return textRange;
    }

    public static String getTextFromRange(@NotNull ASTNode ownerNode, @NotNull TextRange range) {
        if (ownerNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerNode", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getTextFromRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/formatting/OCSimpleBlock", "getTextFromRange"));
        }
        for (ASTNode up = ownerNode; up != null; up = up.getTreeParent()) {
            if (up.getStartOffset() > range.getStartOffset()) continue;
            ownerNode = up;
        }
        return range.shiftRight(-ownerNode.getStartOffset()).substring(ownerNode.getText()) + range;
    }

    @Override
    public void putIndent(Indent indent) {
        this.myIndent = indent;
    }
}

