/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModelWithShiftIndentInsideDocumentRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPsiBasedFormattingModel
extends PsiBasedFormattingModel
implements FormattingModelWithShiftIndentInsideDocumentRange {
    @NotNull
    private final OCMultilineNodeFormatter myMultilineNodeFormatter;

    public OCPsiBasedFormattingModel(@NotNull PsiFile file2, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/formatting/OCPsiBasedFormattingModel", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCPsiBasedFormattingModel", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/cidr/lang/formatting/OCPsiBasedFormattingModel", "<init>"));
        }
        super(file2, (Block)new OCCodeBlock(file2, settings, mode), FormattingDocumentModelImpl.createOn(file2));
        this.myMultilineNodeFormatter = new OCMultilineNodeFormatter(settings);
    }

    public TextRange shiftIndentInsideDocumentRange(Document document, ASTNode node, TextRange textRange, int shift) {
        return this.myMultilineNodeFormatter.shiftIndentInsideRangeInDocument(document, node, textRange, shift);
    }

    public String adjustWhiteSpaceInsideDocument(@Nullable ASTNode node, String whiteSpace) {
        if (OCElementUtil.getElementType(node) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && OCMultilineNodeFormatter.PREPROCESSOR_INFO.get((UserDataHolder)node) != null) {
            assert (node != null);
            Pair<String, String> splitIndent = OCMultilineNodeFormatter.splitIndent(whiteSpace);
            int codeIndent = this.myMultilineNodeFormatter.indent((String)splitIndent.second);
            if (codeIndent >= 120) {
                OCMultilineNodeFormatter.CODE_INDENT.set((UserDataHolder)node, (Object)(codeIndent -= 120));
                CharSequence chars = node.getChars();
                whiteSpace = chars.length() != 0 && chars.charAt(0) == '#' ? (String)splitIndent.first : (String)splitIndent.first + this.myMultilineNodeFormatter.getStringIndent(codeIndent);
            }
        }
        return whiteSpace;
    }

    @Override
    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        return super.replaceWhiteSpace(textRange, nodeAfter, this.adjustWhiteSpaceInsideDocument(nodeAfter, whiteSpace));
    }

    @Override
    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        TextRange newRange = this.myMultilineNodeFormatter.shiftIndentInsideRangeInPsiTree(node, textRange, shift);
        return newRange != null ? newRange : super.shiftIndentInsideRange(node, textRange, shift);
    }
}

