/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCGlobalFormatterData;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCNormalIndentBlock
extends OCCodeBlock {
    public OCNormalIndentBlock(@Nullable OCCodeBlock parent, @NotNull CommonCodeStyleSettings settings, @NotNull OCCodeStyleSettings ocSettings, @NotNull Project project, @NotNull ASTNode node, @NotNull OCGlobalFormatterData globalFormatterData, @Nullable Indent indent, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable Alignment alignment) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "<init>"));
        }
        if (ocSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ocSettings", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "<init>"));
        }
        if (globalFormatterData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalFormatterData", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "<init>"));
        }
        super(parent, settings, ocSettings, project, node, globalFormatterData, indent, childIndent, wrap, alignment);
    }

    private static boolean isSwitchLabelOrCase(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType nodeType = node.getElementType();
        if (nodeType != OCElementTypes.LABELED_STATEMENT && nodeType != OCElementTypes.CASE_STATEMENT) {
            return false;
        }
        return OCNormalIndentBlock.isDirectlyInsideSwitch(node) || OCNormalIndentBlock.isSwitchLabelOrCase(node.getTreeParent());
    }

    public static boolean isDirectlyInsideSwitch(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        IElementType parentType = OCElementUtil.getElementType(parent);
        return parentType == OCElementTypes.SWITCH_STATEMENT && !OCElementTypes.BLOCK_STATEMENTS.contains(node.getElementType()) || OCElementTypes.BLOCK_STATEMENTS.contains(parentType) && OCElementUtil.getElementType(parent.getTreeParent()) == OCElementTypes.SWITCH_STATEMENT;
    }

    @Override
    @Nullable
    protected Indent calcChildIndent(@NotNull IElementType thisType, @NotNull ASTNode child, @NotNull IElementType childType) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "calcChildIndent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "calcChildIndent"));
        }
        if (childType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childType", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "calcChildIndent"));
        }
        Indent childIndent = this.calcChildIndentAhead(thisType, child, childType);
        if (childIndent != null) {
            return childIndent;
        }
        if (child.getTreePrev() == null) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.isStructureOrNamespace(thisType) && childType == OCTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.isControlSection(childType)) {
            return Indent.getNoneIndent();
        }
        if (OCNormalIndentBlock.isSwitchLabelOrCase(child)) {
            return OCNormalIndentBlock.isSwitchLabelOrCase(this.myNode) ? Indent.getNoneIndent() : this.getIndentInsideSwitch(true);
        }
        if (OCNormalIndentBlock.isDirectlyInsideSwitch(child) && (FormatterUtil.hasPrecedingSiblingOfType(child, OCElementTypes.CASE_STATEMENT, new IElementType[0]) || FormatterUtil.hasPrecedingSiblingOfType(child, OCElementTypes.LABELED_STATEMENT, new IElementType[0]))) {
            return this.getIndentInsideSwitch(false);
        }
        if (OCNormalIndentBlock.isSwitchLabelOrCase(this.myNode)) {
            return OCFormatterUtil.isBlock(childType) ? Indent.getNoneIndent() : this.myChildIndent;
        }
        if (thisType == OCElementTypes.LABELED_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (thisType == OCElementTypes.IF_STATEMENT && childType == OCElementTypes.IF_STATEMENT && this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
            return Indent.getNoneIndent();
        }
        if (!OCFormatterUtil.isBlock(thisType) && OCFormatterUtil.isKeyword(child) && !OCFormatterUtil.isInsideAnyBraces(child)) {
            return Indent.getNoneIndent();
        }
        if (OCFormatterUtil.isControlStatement(thisType) && OCElementTypes.STATEMENTS.contains(childType) && !OCFormatterUtil.isBlock(childType) && (OCElementTypes.FOR_STATEMENT != thisType || OCFormatterUtil.isPrecededBy(child, OCTokenTypes.RPAR))) {
            return this.myChildIndent;
        }
        if (OCFormatterUtil.isBlock(childType)) {
            return OCFormatterUtil.isBlock(thisType) ? this.myChildIndent : Indent.getNoneIndent();
        }
        return OCNormalIndentBlock.isInsideBraces(thisType, child) || OCTokenTypes.COMMENTS.contains(childType) ? this.myChildIndent : Indent.getContinuationIndent();
    }

    private Indent getIndentInsideSwitch(boolean caseIndent) {
        if (this.mySettings.INDENT_CASE_FROM_SWITCH) {
            return caseIndent ? this.myChildIndent : OCNormalIndentBlock.getDoubleIndent(this.mySettings);
        }
        return caseIndent ? Indent.getNoneIndent() : this.myChildIndent;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent indent = this.myChildIndent;
        ASTNode prevNode = OCSimpleBlock.extractLastNode(this.getSubBlocks().get(newChildIndex - 1));
        IElementType prevType = OCElementUtil.getElementType(prevNode);
        if (OCElementUtil.getElementType(this.myNode.getTreeParent()) == OCElementTypes.SWITCH_STATEMENT) {
            boolean isCase;
            boolean bl = isCase = prevType == OCTokenTypes.LBRACE;
            if (prevType == OCElementTypes.CASE_STATEMENT || prevType == OCElementTypes.LABELED_STATEMENT) {
                assert (prevNode != null);
                ASTNode lastChildNode = prevNode.getLastChildNode();
                if (lastChildNode != null) {
                    IElementType lastChildType = lastChildNode.getElementType();
                    isCase = OCFormatterUtil.isBlock(lastChildType) || lastChildType == OCElementTypes.RETURN_STATEMENT || lastChildType == OCElementTypes.BREAK_STATEMENT;
                }
            }
            indent = this.getIndentInsideSwitch(isCase);
        } else if (this.myNode.getElementType() == OCElementTypes.DO_WHILE_STATEMENT && OCElementTypes.STATEMENTS.contains(prevType)) {
            indent = Indent.getNoneIndent();
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    private static boolean isInsideBraces(@NotNull IElementType thisType, @NotNull ASTNode child) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "isInsideBraces"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/lang/formatting/OCNormalIndentBlock", "isInsideBraces"));
        }
        return OCElementTypes.BLOCK_STATEMENTS.contains(thisType) || thisType == OCElementTypes.INSTANCE_VARIABLES_LIST || OCFormatterUtil.isStructureOrNamespace(thisType) && TreeUtil.findSiblingBackward(child, OCTokenTypes.LBRACE) != null;
    }
}

