/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCPsiBasedFormattingModel;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormattingModelBuilder
implements FormattingModelBuilderEx {
    public static final Key<Boolean> ALWAYS_CREATE_FULL_MODEL = new Key("Never use DumbModel in dumb app state");

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @Override
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
        }
        if (!Boolean.TRUE.equals(element.getUserData(ALWAYS_CREATE_FULL_MODEL)) && DumbService.getInstance((Project)element.getProject()).isDumb()) {
            FormattingModel formattingModel = OCFormattingModelBuilder.createDumbModel(element);
            if (formattingModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
            }
            return formattingModel;
        }
        PsiFile file2 = element.getContainingFile();
        OCPsiBasedFormattingModel oCPsiBasedFormattingModel = new OCPsiBasedFormattingModel(file2, settings, mode);
        if (oCPsiBasedFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "createModel"));
        }
        return oCPsiBasedFormattingModel;
    }

    @Override
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        return null;
    }

    public TextRange getRangeAffectingIndent(PsiFile file2, int offset, ASTNode elementAtOffset) {
        OCElement parent = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file2.findElementAt(offset), (Class[])new Class[]{OCMethod.class, OCExpression.class});
        return parent != null ? parent.getTextRange() : null;
    }

    private static FormattingModel createDumbModel(PsiElement element) {
        final AbstractBlock block = new AbstractBlock(element.getNode(), null, null){

            @Override
            protected List<Block> buildChildren() {
                return EMPTY;
            }

            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                if (child2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$1", "getSpacing"));
                }
                return null;
            }

            public boolean isLeaf() {
                return false;
            }
        };
        final Document document = FormattingDocumentModelImpl.createOn(element.getContainingFile()).getDocument();
        final FormattingDocumentModel model = new FormattingDocumentModel(){

            public int getLineNumber(int offset) {
                return document.getLineNumber(offset);
            }

            public int getLineStartOffset(int line) {
                return document.getLineStartOffset(line);
            }

            public CharSequence getText(TextRange textRange) {
                return document.getText(textRange);
            }

            public int getTextLength() {
                return document.getTextLength();
            }

            @NotNull
            public Document getDocument() {
                Document document2 = document;
                if (document2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$2", "getDocument"));
                }
                return document2;
            }

            public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
                return false;
            }

            @NotNull
            public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
                if (whiteSpaceText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$2", "adjustWhiteSpaceIfNecessary"));
                }
                CharSequence charSequence = whiteSpaceText;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$2", "adjustWhiteSpaceIfNecessary"));
                }
                return charSequence;
            }
        };
        return new FormattingModel(){

            @NotNull
            public Block getRootBlock() {
                AbstractBlock abstractBlock = block;
                if (abstractBlock == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$3", "getRootBlock"));
                }
                return abstractBlock;
            }

            @NotNull
            public FormattingDocumentModel getDocumentModel() {
                FormattingDocumentModel formattingDocumentModel = model;
                if (formattingDocumentModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCFormattingModelBuilder$3", "getDocumentModel"));
                }
                return formattingDocumentModel;
            }

            public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
                return textRange;
            }

            public TextRange shiftIndentInsideRange(ASTNode node, TextRange range, int indent) {
                return range;
            }

            public void commitChanges() {
            }
        };
    }
}

