/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.NotNull;

public class OCStructureUnawareBraceSurrounder
extends OCSurrounder {
    public String getTemplateDescription() {
        return "{ }";
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/editor/surround/OCStructureUnawareBraceSurrounder", "isApplicable"));
        }
        if (!super.isApplicable(elements)) {
            return false;
        }
        if (elements.length != 2) {
            return false;
        }
        OCStatement firstStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)elements[0], OCStatement.class);
        OCStatement lastStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)elements[1], OCStatement.class);
        return firstStmt == null || lastStmt == null || firstStmt.getParent() != lastStmt.getParent();
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/editor/surround/OCStructureUnawareBraceSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/surround/OCStructureUnawareBraceSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/editor/surround/OCStructureUnawareBraceSurrounder", "surroundElements"));
        }
        int startOffset = elements[0].getTextRange().getStartOffset();
        int endOffset = elements[elements.length - 1].getTextRange().getEndOffset();
        Document doc = editor.getDocument();
        CharSequence chars = doc.getCharsSequence();
        startOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t") + 1;
        doc.insertString(endOffset, (CharSequence)"\n}");
        doc.insertString(startOffset, (CharSequence)"{\n");
        CodeStyleManager styler = CodeStyleManager.getInstance((Project)project);
        PsiFile file2 = elements[0].getContainingFile();
        styler.reformatText(file2, startOffset, startOffset + 1);
        styler.reformatText(file2, endOffset - 1, endOffset);
        styler.adjustLineIndent(file2, TextRange.from((int)startOffset, (int)endOffset));
        int caretOffset = startOffset + "{".length();
        return TextRange.create((int)caretOffset, (int)caretOffset);
    }
}

