/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.editor.surround.OCAutoreleasePoolSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCBlockExpressionStatementSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCBlockSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCDoWhileSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCForSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCIfElseSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCIfRespondsToSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCIfSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCSynchronizedSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCTryCatchFinallySurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCTryCatchSurrounder;
import com.jetbrains.cidr.lang.editor.surround.OCWhileSurrounder;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class OCStatementSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new OCIfSurrounder(), new OCIfElseSurrounder(), new OCIfRespondsToSurrounder(), new OCWhileSurrounder(), new OCDoWhileSurrounder(), new OCForSurrounder(), new OCTryCatchSurrounder(), new OCTryCatchFinallySurrounder(), new OCSynchronizedSurrounder(), new OCAutoreleasePoolSurrounder(), new OCBlockSurrounder(), new OCBlockExpressionStatementSurrounder()};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.expression");
        PsiElement[] statements = OCCodeInsightUtil.findStatementsAtRange(file2, startOffset, endOffset, true);
        PsiElement[] psiElementArray = statements != null ? statements : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/surround/OCStatementSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/surround/OCStatementSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }
}

