/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCExpressionTrimRenderer;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIfRespondsToSurrounder
extends OCStatementSurrounder<OCIfStatement> {
    private static final NotNullFunction<PsiElement, TextRange> RANGER = new NotNullFunction<PsiElement, TextRange>(){

        @NotNull
        public TextRange fun(PsiElement dom) {
            TextRange textRange = OCElementUtil.getRangeWithMacros(dom);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder$1", "fun"));
            }
            return textRange;
        }
    };

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "if ([x respondsToSelector:@selector(selector)]) {\n}";
    }

    @Override
    public TextRange surroundElements(final @NotNull Project project, @NotNull Editor editor, final @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder", "surroundElements"));
        }
        final List<OCSendMessageExpression> sendMessageExprs = OCIfRespondsToSurrounder.findSendMessageExprs(elements);
        if (sendMessageExprs.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() && !sendMessageExprs.isEmpty()) {
            return this.doSurroundElements(project, elements, 0);
        }
        if (!sendMessageExprs.isEmpty()) {
            editor.getCaretModel().moveToOffset(elements[elements.length - 1].getTextOffset());
            IntroduceTargetChooser.showChooser(editor, sendMessageExprs, new Pass<OCSendMessageExpression>(){

                public void pass(final OCSendMessageExpression expr) {
                    new WriteCommandAction(project, new PsiFile[0]){

                        protected void run(@NotNull Result result2) throws Exception {
                            if (result2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder$2$1", "run"));
                            }
                            OCIfRespondsToSurrounder.this.doSurroundElements(project, elements, sendMessageExprs.indexOf(expr));
                        }
                    }.execute();
                }
            }, new OCExpressionTrimRenderer.RenderFunction(), "Expressions", RANGER);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"No send message expressions in the selected code", (String)this.getTemplateDescription(), null);
        }
        return elements[0].getTextRange();
    }

    @Override
    protected void insertOldElements(PsiElement[] elements, PsiElement container, OCIfStatement newStatement, @NotNull Object chosenElement) {
        if (chosenElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenElement", "com/jetbrains/cidr/lang/editor/surround/OCIfRespondsToSurrounder", "insertOldElements"));
        }
        OCSendMessageExpression sendMessageExpr = chosenElement instanceof OCSendMessageExpression ? (OCSendMessageExpression)chosenElement : OCIfRespondsToSurrounder.findSendMessageExprs(elements).get((Integer)chosenElement);
        OCSendMessageExpression ifMessageExpr = (OCSendMessageExpression)newStatement.getCondition().getExpression();
        OCReferenceExpression ifReceiver = (OCReferenceExpression)ifMessageExpr.getReceiverExpression();
        OCExpression receiver = sendMessageExpr.getReceiverExpression();
        ((OCSelectorExpression)ifMessageExpr.getArgumentExpressions().get(0)).getReference().handleElementRename(sendMessageExpr.getMessageSelector());
        if (receiver instanceof OCReferenceExpression) {
            ifReceiver.getReferenceElement().setName(((OCReferenceExpression)receiver).getReferenceElement().getName());
        } else if (receiver != null) {
            Collection<String> names = OCNameSuggester.suggestForExpression(OCSymbolKind.LOCAL_VARIABLE, receiver);
            String name = names.isEmpty() ? "x" : names.iterator().next();
            ifReceiver.getReferenceElement().setName(name);
            OCDeclarationStatement declStmt = OCElementFactory.declarationStatement(name, receiver.getType(), receiver, newStatement);
            OCChangeUtil.addBefore(container, declStmt, newStatement);
            OCChangeUtil.replaceHandlingMacros(receiver, OCElementFactory.expressionFromText(name, newStatement));
        }
        super.insertOldElements(elements, container, newStatement, chosenElement);
    }

    private static List<OCSendMessageExpression> findSendMessageExprs(PsiElement[] elements) {
        final ArrayList<OCSendMessageExpression> result2 = new ArrayList<OCSendMessageExpression>();
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expression) {
                    OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
                    OCMethodSymbol responder = responders.getKnownResponder();
                    if (responder == null || responder.isOptional() || !((OCClassSymbol)responder.getParent()).getName().equals("NSObject") || ((OCClassSymbol)responder.getParent()).getCategoryName() != null) {
                        result2.add(expression);
                    }
                    super.visitSendMessageExpression(expression);
                }
            });
        }
        return result2;
    }

    @Override
    protected PsiElement getInsertionPlace(OCIfStatement statement) {
        return statement.getThenBranch();
    }

    @Override
    protected TextRange getSelectionRange(OCIfStatement statement) {
        int offset = statement.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "if respondsToSelector";
    }

    @Override
    protected OCLanguageKind getLanguageKind() {
        return OCLanguageKind.OBJ_C;
    }
}

