/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;

public class OCBlockExpressionStatementSurrounder
extends OCStatementSurrounder<OCDeclarationStatement> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "void (^a)() = ^{\n};";
    }

    @Override
    protected PsiElement getInsertionPlace(OCDeclarationStatement statement) {
        return ((OCBlockExpression)statement.getDeclaration().getDeclarators().get(0).getInitializer()).getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCDeclarationStatement statement) {
        PsiElement declarator = statement.getDeclaration().getDeclarators().get(0).getNameIdentifier();
        int offset = OCElementUtil.getRangeWithMacros(declarator).getStartOffset();
        declarator.delete();
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "void (^) = ^{ }";
    }

    @Override
    protected OCLanguageKind getLanguageKind() {
        return OCLanguageKind.OBJ_C;
    }
}

