/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;

public class WhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCWhileStatement) {
            Document doc = editor.getDocument();
            OCWhileStatement whileStatement = (OCWhileStatement)psiElement;
            ASTNode rParenth = whileStatement.getRParenth();
            ASTNode lParenth = whileStatement.getLParenth();
            OCDeclarationOrExpression condition = whileStatement.getCondition();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(whileStatement.getTextRange().getStartOffset()));
                    OCStatement block = whileStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, whileStatement.getTextRange().getEndOffset());
                    doc.replaceString(whileStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"while ()");
                    processor2.registerUnresolvedError(whileStatement.getTextRange().getStartOffset() + "while (".length());
                } else {
                    processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getRangeWithMacros().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

