/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;

public class SemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        OCReturnStatement stmt;
        OCMethod method;
        if (psiElement instanceof OCReturnStatement && (method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, OCMethod.class)) != null && method.getReturnType().isVoid() && (stmt = (OCReturnStatement)psiElement).getExpression() != null) {
            Document doc = editor.getDocument();
            doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
            return;
        }
        if (psiElement instanceof PsiErrorElement && ((PsiErrorElement)psiElement).getErrorDescription().contains(";") || psiElement instanceof OCExpressionStatement || psiElement instanceof OCDeclarationStatement || psiElement instanceof OCDoWhileStatement || psiElement instanceof OCReturnStatement || psiElement instanceof OCBreakStatement || psiElement instanceof OCContinueStatement || psiElement instanceof OCMethod && ((OCMethod)psiElement).getContainingClass() instanceof OCInterface) {
            ASTNode leaf;
            String text = OCElementUtil.getTextWithMacros(psiElement);
            int tailLength = 0;
            ASTNode aSTNode = leaf = psiElement instanceof PsiErrorElement ? psiElement.getNode() : TreeUtil.findLastLeaf(psiElement.getNode());
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leaf.getElementType())) {
                tailLength += leaf.getTextLength();
                leaf = TreeUtil.prevLeaf(leaf);
            }
            if (tailLength > 0) {
                text = text.substring(0, text.length() - tailLength);
            }
            int insertionOffset = OCElementUtil.getRangeWithMacros(leaf.getPsi()).getEndOffset();
            Document doc = editor.getDocument();
            if (leaf.getElementType() != OCTokenTypes.SEMICOLON && !StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                PsiElement parent = psiElement.getParent();
                if (parent instanceof OCForStatement && ((OCForStatement)parent).getIncrement() == psiElement) {
                    return;
                }
                doc.insertString(insertionOffset, (CharSequence)";");
            }
        }
    }
}

