/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;

public class MissingWhileBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof OCWhileStatement)) {
            return;
        }
        OCWhileStatement whileStatement = (OCWhileStatement)psiElement;
        Document doc = editor.getDocument();
        OCStatement body = whileStatement.getBody();
        if (body instanceof OCBlockStatement) {
            return;
        }
        if (body != null && MissingWhileBodyFixer.startLine(doc, body) == MissingWhileBodyFixer.startLine(doc, whileStatement) && whileStatement.getCondition() != null) {
            return;
        }
        ASTNode rParenth = whileStatement.getRParenth();
        assert (rParenth != null);
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{\n}");
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

