/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCStatement;
import java.util.List;

public class MissingFunctionBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof OCFunctionDefinition)) {
            return;
        }
        OCFunctionDefinition fun = (OCFunctionDefinition)psiElement;
        OCBlockStatement body = fun.getBody();
        Document doc = editor.getDocument();
        if (body != null) {
            List<OCStatement> statements;
            String bodyText = body.getText();
            if (bodyText.startsWith("{") && (statements = body.getStatements()).size() > 0 && statements.get(0) instanceof OCDeclarationStatement && PsiTreeUtil.getDeepestLast((PsiElement)statements.get(0)) instanceof PsiErrorElement) {
                doc.insertString(body.getTextRange().getStartOffset() + 1, (CharSequence)"\n}");
            }
            return;
        }
        int endOffset = fun.getTextRange().getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)fun.getText(), (char)';')) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }
}

