/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.Fixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.Nullable;

public class MissingForBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, OCSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        OCForStatement forStatement = MissingForBodyFixer.getForStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        OCStatement body = forStatement.getBody();
        if (body instanceof OCBlockStatement) {
            return;
        }
        if (body != null && MissingForBodyFixer.startLine(doc, body) == MissingForBodyFixer.startLine(doc, forStatement)) {
            return;
        }
        ASTNode eltToInsertAfter = forStatement.getRParenth();
        String text = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement.getNode();
            text = "){\n}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    @Nullable
    private static OCForStatement getForStatementParent(PsiElement psiElement) {
        OCForStatement statement = (OCForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, OCForStatement.class);
        if (statement == null) {
            return null;
        }
        OCStatement init = statement.getInitializer();
        OCStatement update = statement.getIncrement();
        OCDeclarationOrExpression check = statement.getCondition();
        return MissingForBodyFixer.isValidChild(init, psiElement) || MissingForBodyFixer.isValidChild(update, psiElement) || MissingForBodyFixer.isValidChild(check, psiElement) ? statement : null;
    }

    private static boolean isValidChild(PsiElement ancestor, PsiElement psiElement) {
        if (ancestor != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)psiElement, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

