/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.jetbrains.cidr.lang.editor.smartEnter.EnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;

public class AfterSemicolonEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        if (psiElement instanceof OCExpressionStatement || psiElement instanceof OCDeclarationStatement || psiElement instanceof OCDoWhileStatement || psiElement instanceof OCReturnStatement || psiElement instanceof OCBreakStatement || psiElement instanceof OCContinueStatement || psiElement instanceof OCMethod && ((OCMethod)psiElement).getContainingClass() instanceof OCInterface) {
            CharSequence text;
            int errorOffset = AfterSemicolonEnterProcessor.getErrorElementOffset(psiElement);
            int elementEndOffset = psiElement.getTextRange().getEndOffset();
            if (errorOffset >= 0 && errorOffset < elementEndOffset && (text = editor.getDocument().getCharsSequence()).charAt(errorOffset) == ' ' && text.charAt(errorOffset + 1) == ';') {
                ++errorOffset;
            }
            editor.getCaretModel().moveToOffset(errorOffset >= 0 ? errorOffset : elementEndOffset);
            return isModified;
        }
        return false;
    }

    private static int getErrorElementOffset(PsiElement elt) {
        final int[] offset = new int[]{-1};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                if (offset[0] == -1) {
                    offset[0] = element.getTextRange().getStartOffset();
                }
            }
        });
        return offset[0];
    }
}

