/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCArgumentListCallPlace
extends OCFunctionCallPlace<OCArgumentList> {
    public OCArgumentListCallPlace(OCArgumentList argumentList) {
        super(argumentList);
    }

    @Override
    public void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result2) {
        OCType type;
        OCSymbol symbol;
        OCReferenceElement ref;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/parameterInfo/OCArgumentListCallPlace", "collectCallOptions"));
        }
        OCArgumentList argumentList = (OCArgumentList)this.getElement();
        PsiElement callContext = argumentList.getContext();
        PsiFile file2 = argumentList.getContainingFile();
        if (callContext instanceof OCCallExpression) {
            OCCallExpression call = (OCCallExpression)callContext;
            OCExpression function = call.getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                if (referenceElement != null) {
                    Collection<OCSymbol> symbols = referenceElement.resolveToOverloadsSymbols();
                    for (OCSymbol symbol2 : symbols) {
                        if (symbol2 instanceof OCStructSymbol) {
                            OCArgumentListCallPlace.collectConstructorCallOptions(symbol2.getType(), argumentList, result2);
                            continue;
                        }
                        OCArgumentListCallPlace.collectCallOptions(result2, argumentList, Collections.singleton(symbol2), null);
                    }
                }
            } else if (function instanceof OCQualifiedExpression) {
                OCQualifiedExpression qe = (OCQualifiedExpression)function;
                OCType qualifierType = qe.getQualifier().getResolvedType().getTerminalType();
                OCArgumentListCallPlace.collectCallOptions(result2, argumentList, qe.resolveToOverloadsSymbols(), qualifierType);
            } else {
                OCSymbol symbol3 = OCLValueVisitor.getSymbol(function);
                OCArgumentListCallPlace.collectCallOptions(result2, argumentList, Collections.singletonList(symbol3), null);
            }
        } else if (callContext instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)callContext;
            OCType type2 = declarator.getType().resolve(file2);
            OCArgumentListCallPlace.collectInitializationOptions(type2, argumentList, result2);
        } else if (callContext instanceof OCCppNewExpression) {
            OCCppNewExpression call = (OCCppNewExpression)callContext;
            OCType type3 = call.getConstructingType().resolve(file2);
            OCArgumentListCallPlace.collectInitializationOptions(type3, argumentList, result2);
        } else if (callContext instanceof OCConstructorFieldInitializer && (ref = ((OCConstructorFieldInitializer)callContext).getReferenceElement()) != null && (symbol = ref.resolveToSymbol()) != null && (type = symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() ? symbol.getEffectiveType() : (symbol instanceof OCDeclaratorSymbol ? symbol.getType() : null)) != null) {
            OCType rt = type.resolve(new OCResolveContext(callContext));
            OCArgumentListCallPlace.collectInitializationOptions(rt, argumentList, result2);
        }
    }

    @Override
    @NotNull
    public List<OCExpression> getArgumentExpressions() {
        List<OCExpression> list = ((OCArgumentList)this.getElement()).getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/parameterInfo/OCArgumentListCallPlace", "getArgumentExpressions"));
        }
        return list;
    }
}

