/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTemplatesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil");

    private OCTemplatesUtil() {
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesVisibleAt(PsiElement place, boolean withFields) {
        final HashSet names = new HashSet();
        final ArrayList<OCDeclaratorSymbol> answer = new ArrayList<OCDeclaratorSymbol>();
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                OCSymbolKind kind;
                if (symbol instanceof OCDeclaratorSymbol && names.add(symbol.getName()) && ((kind = symbol.getKind()).isLocal() || kind == OCSymbolKind.STRUCT_FIELD)) {
                    answer.add((OCDeclaratorSymbol)symbol);
                }
                return true;
            }
        };
        if (withFields) {
            OCResolveUtil.processSymbols(null, place, processor2);
        } else {
            OCResolveUtil.processLocalSymbols(null, place, processor2);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesVisibleAt"));
        }
        return arrayList;
    }

    @Nullable
    public static Collection<String> getNames(ExpressionContext context) {
        final Project project = context.getProject();
        final int offset = context.getStartOffset();
        Collection<String> names = null;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file2.findElementAt(offset);
        if (element.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
            names = OCTemplatesUtil.getNamesForIdentifier(project, element);
        } else {
            final PsiFile fileCopy = (PsiFile)file2.copy();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    BlockSupport blockSupport = BlockSupport.getInstance(project);
                    try {
                        blockSupport.reparseRange(fileCopy, offset, offset, "xxx");
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
                names = OCTemplatesUtil.getNamesForIdentifier(project, identifierCopy);
            }
        }
        return names;
    }

    @Nullable
    private static Collection<String> getNamesForIdentifier(Project project, PsiElement identifier) {
        OCDeclarator var;
        if (identifier.getParent() instanceof OCDeclarator && identifier.equals((var = (OCDeclarator)identifier.getParent()).getNameIdentifier())) {
            return OCNameSuggester.suggestForDeclaration(var, false, Collections.<String>emptyList());
        }
        return null;
    }

    @NotNull
    public static PsiElement getInsertionPlace(@NotNull ExpressionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getInsertionPlace"));
        }
        Editor editor = context.getEditor();
        OCLog.LOG.assertTrue(editor != null && editor.getProject() != null, (Object)"Template call in undefined editor");
        PsiFile file2 = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        OCLog.LOG.assertTrue(file2 != null, (Object)"Template call in undefined file");
        PsiElement place = file2.findElementAt(context.getStartOffset());
        OCLog.LOG.assertTrue(place != null, (Object)"Template call in undefined context");
        PsiElement psiElement = place;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getInsertionPlace"));
        }
        return psiElement;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithBeginEnd(@NotNull ExpressionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesWithBeginEnd"));
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType();
            if (type.isUnresolved(place) || type.isUnknown()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file2 = expr.getContainingOCFile();
            if (!(type instanceof OCStructType) || OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file2) == null) continue;
            results.add(var);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesWithBeginEnd"));
        }
        return arrayList;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithMethods(@NotNull ExpressionContext context, @NotNull List<String> requiredMethods) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesWithMethods"));
        }
        if (requiredMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredMethods", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesWithMethods"));
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type = var.getResolvedType();
            if (type.isUnresolved(place) || type.isUnknown()) continue;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            if (!(type instanceof OCStructType)) continue;
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file2 = expr.getContainingOCFile();
            OCStructType structType = (OCStructType)type;
            boolean shouldAdd = true;
            for (String method : requiredMethods) {
                if (OCTemplatesUtil.hasMemberFunction(structType, file2, method)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            results.add(var);
        }
        ArrayList<OCDeclaratorSymbol> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getVariablesWithMethods"));
        }
        return arrayList;
    }

    private static boolean hasMemberFunction(@NotNull OCStructType type, @NotNull OCFile file2, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "hasMemberFunction"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "hasMemberFunction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "hasMemberFunction"));
        }
        OCResolveContext context = new OCResolveContext(file2);
        return !type.collectMethods(name, context).isEmpty();
    }

    @NotNull
    public static List<String> getStringsList(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getStringsList"));
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (Expression param : params) {
            Result result2 = param.calculateResult(context);
            if (result2 == null) continue;
            namesList.add(result2.toString());
        }
        ArrayList<String> arrayList = namesList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/liveTemplates/OCTemplatesUtil", "getStringsList"));
        }
        return arrayList;
    }
}

