/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCNameSuggestionContributor
extends OCCompletionContributorBase {
    public static final OCCompletionPriority PRIORITY = OCCompletionPriority.HIGH_KEYWORDS_PRIORITY;

    public OCNameSuggestionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_DECLARATION, new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$1", "addCompletions"));
                }
                OCDeclarator declarator = (OCDeclarator)parameters.getPosition().getParent();
                OCTypeElement typeElement = null;
                if (declarator.getParent() instanceof OCDeclaration && ((typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement()) == null || typeElement.isEmpty())) {
                    return;
                }
                OCType type = declarator.getResolvedType();
                if (type instanceof OCReferenceType) {
                    List<OCSymbol> symbols = ((OCReferenceType)type).getReference().resolveToSymbols(parameters.getOriginalFile());
                    String name = type.getName();
                    if (!symbols.isEmpty() || "self".equals(name) || "super".equals(name)) {
                        OCExpression expression = OCElementFactory.expressionFromText(name, declarator, false);
                        MethodSelectorCompletionContributor.addCompletionsForReceiver(expression, "", parameters, result2, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        return;
                    }
                }
                if (type instanceof OCObjectType) {
                    if (typeElement != null) {
                        OCObjectTypeContext typeContext = new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type, type);
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context("", typeElement, typeContext, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        MethodSelectorCompletionContributor.addCompletionForReceiverContext(parameters, result2, ctx);
                    }
                } else {
                    String originalName = declarator.getName();
                    originalName = originalName == null ? "" : originalName;
                    int fakePartIndex = originalName.lastIndexOf("CIDR_RULE_ZZZ");
                    if (fakePartIndex >= 0) {
                        originalName = originalName.substring(0, fakePartIndex);
                    }
                    List<String> predefinedNames = originalName.isEmpty() ? Collections.emptyList() : Collections.singletonList(originalName);
                    for (String name : OCNameSuggester.suggestForDeclaration(declarator, true, predefinedNames)) {
                        result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class), new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$2", "addCompletions"));
                }
                PsiElement ident = parameters.getPosition();
                OCMethodSelectorPart declarator = (OCMethodSelectorPart)ident.getParent();
                if (declarator.getParameter() == ident) {
                    OCType type = declarator.getType().resolve(ident.getContainingFile());
                    for (String name : OCNameSuggester.suggestForType(type, ident, Collections.<String>emptyList())) {
                        result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_CLASS_DECLARATION, new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, final CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCNameSuggestionContributor$3", "addCompletions"));
                }
                final PsiElement element = parameters.getPosition().getParent();
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(element.getProject(), new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (symbol instanceof OCClassSymbol && element instanceof OCProtocol == symbol instanceof OCProtocolSymbol) {
                            result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)symbol.getName()), PRIORITY));
                        }
                        return true;
                    }
                }, null);
            }
        });
    }
}

