/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCFilteredCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCObjCErrorKeywordImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCKeywordCompletionContributor
extends OCCompletionContributorBase {
    public static final LookupDecorator TYPE_ATTRIBUTE_DECORATOR = new LookupDecorator(){
        private final AddSpaceInsertHandler myHandler = new AddSpaceInsertHandler(false);

        @Override
        @NotNull
        public LookupElementBuilder decorate(@NotNull OCCompletionParameters parameters, @NotNull LookupElementBuilder builder) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$1", "decorate"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$1", "decorate"));
            }
            LookupElementBuilder lookupElementBuilder = builder.withInsertHandler((InsertHandler)this.myHandler);
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$1", "decorate"));
            }
            return lookupElementBuilder;
        }
    };
    public static final String[] ALTERNATIVE_TOKENS_UNARY = new String[]{"?compl", "?not"};
    public static final String[] ALTERNATIVE_TOKENS = ArrayUtil.mergeArrays((String[])ALTERNATIVE_TOKENS_UNARY, (String[])new String[]{"?and", "?and_eq", "?bitand", "?bitor", "?not_eq", "?or", "?or_eq", "?xor", "?xor_eq"});
    public static final String KEYWORD_ALIGNAS = "alignas(<caret>)";
    public static final String KEYWORD_ASM = "asm(<caret>)";
    public static final String KEYWORD_NAMESPACE = "namespace ";
    public static final String KEYWORD_EXTERN = "extern ";
    private static Condition<OCFilteredCompletionProvider.Filter> NULLABILITY_FEATURE_ENABLED_FILTER = new Condition<OCFilteredCompletionProvider.Filter>(){

        public boolean value(OCFilteredCompletionProvider.Filter filter) {
            return OCCompilerHelper.supportsNullability(filter.myParameters.getOriginalFile());
        }
    };
    public static final PsiElementPattern.Capture<PsiElement> AT_EXPRESSION_LEVEL = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.andOr(new ElementPattern[]{PlatformPatterns.psiElement().withSuperParent(2, OCReferenceExpression.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, OCTypeElement.class)).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(OCDeclaration.class).inside(true, (ElementPattern)PlatformPatterns.psiElement(OCBlockStatement.class), (ElementPattern)PlatformPatterns.psiElement(OCDeclarator.class)))})).andNot(OCCompletionPatterns.WITH_QUALIFIER)).andNot(OCCompletionPatterns.AFTER_DOT)).andNot(OCCompletionPatterns.AT_CLASS_FUNCTION_BODY_PLACEHOLDER);
    public static final PsiElementPattern.Capture<PsiElement> AT_EXPRESSION_LEVEL_CPP = (PsiElementPattern.Capture)AT_EXPRESSION_LEVEL.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN);

    public OCKeywordCompletionContributor() {
        this.preprocessorDirectives();
        this.topLevel();
        this.atUnqualifiedTypePosition();
        this.inImplementation();
        this.inProtocol();
        this.inInterface();
        this.inIvarsList();
        this.inPropertyAttribute();
        this.inLoop();
        this.inFor();
        this.inSwitch();
        this.inTry();
        this.inElsePosition();
        this.atStatementLevel();
        this.atExpressionLevel();
        this.inCppClassDefinition();
        this.atFunctionDeclaration();
    }

    private void atFunctionDeclaration() {
        PsiElementPattern.Capture afterParamList = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCFunctionDeclaration.class).withLastChild((ElementPattern)PlatformPatterns.psiElement(PsiErrorElement.class));
        this.registerAtFunctionDeclarationCpp((PsiElementPattern.Capture<? extends OCFunctionDeclaration>)afterParamList, "!noexcept ", "!throw(<caret>)", "!try ");
        this.registerAtFunctionDeclarationCpp((PsiElementPattern.Capture<? extends OCFunctionDeclaration>)((PsiElementPattern.Capture)afterParamList.withParent((ElementPattern)PlatformPatterns.psiElement(OCStruct.class))), "!final ", "!override ");
        this.registerAtFunctionDeclarationCpp((PsiElementPattern.Capture<? extends OCFunctionDeclaration>)((PsiElementPattern.Capture)PlatformPatterns.psiElement(OCFunctionDefinition.class).withChild((ElementPattern)PlatformPatterns.psiElement(OCDeclarator.class).with((PatternCondition)new PatternCondition<OCDeclarator>("function-try-block"){

            public boolean accepts(@NotNull OCDeclarator declarator, ProcessingContext context) {
                if (declarator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarator", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$3", "accepts"));
                }
                return TreeUtil.findChildBackward(declarator.getNode(), OCTokenTypes.TRY_KEYWORD) != null;
            }
        }))), "!catch");
    }

    private void registerAtFunctionDeclarationCpp(PsiElementPattern.Capture<? extends OCFunctionDeclaration> functionCapture, String ... keywords) {
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.TYPE_IN_DECLARATION.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCDeclaration.class).afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement().withElementType(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET), functionCapture))), keywords);
    }

    private void inCppClassDefinition() {
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.withSuperParent(2, OCCppBaseClause.class)), "!public ", "!protected ", "!private ", "!virtual ");
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.and(OCCompletionPatterns.AT_CLASS_FUNCTION_BODY_PLACEHOLDER)), "!0", "!default", "!delete");
    }

    private void inElsePosition() {
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(OCCompletionPatterns.ELSE_POSITION)), "!else");
    }

    private void atStatementLevel() {
        this.registerBasic(OCCompletionPatterns.AT_STATEMENT_LEVEL, "switch", "goto ", "while", "for", "if", "do", KEYWORD_ASM);
        this.registerBasic(OCCompletionPatterns.AT_STATEMENT_LEVEL, OCKeywordCompletionContributor.returnProvider());
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.AT_STATEMENT_LEVEL.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), ArrayUtil.mergeArrays((String[])ALTERNATIVE_TOKENS_UNARY, (String[])new String[]{"static_assert(<caret>)", "try {\n<caret>\n}\n", "throw ", "using "}));
        this.registerProviderForObjcKeyword(OCCompletionPatterns.AT_STATEMENT_LEVEL, (ElementPattern<PsiElement>)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(OCBlockStatement.class)).and(OCCompletionPatterns.like(OCObjCErrorKeywordImpl.class)), 1, "try {\n<caret>\n}\n", "autoreleasepool {\n<caret>\n}\n", "throw ", "synchronized(<#lock#>) {\n}", "selector(<caret>)", "protocol(<caret>)");
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.OBJC_ERROR_KEYWORD.andOr(new ElementPattern[]{PlatformPatterns.psiElement().withSuperParent(2, OCDeclarator.class), PlatformPatterns.psiElement().inside(OCBlockStatement.class)})), OCKeywordCompletionContributor.provider(null, Character.valueOf('@'), OCKeywordCompletionContributor.keywords("selector(<caret>)")));
    }

    private void atExpressionLevel() {
        this.registerBasic(AT_EXPRESSION_LEVEL, "sizeof(<caret>)", "typeof(<caret>)");
        this.registerBasic(AT_EXPRESSION_LEVEL_CPP, ALTERNATIVE_TOKENS);
        this.registerBasic(AT_EXPRESSION_LEVEL_CPP, "alignof(<caret>)", "noexcept(<caret>)", "new ", "nullptr", "true", "delete ", "false", "const_cast<<caret>>", "dynamic_cast<<caret>>", "reinterpret_cast<<caret>>", "static_cast<<caret>>", "typeid(<caret>)");
    }

    private void inLoop() {
        this.registerBasic(OCCompletionPatterns.IN_LOOP, "!break", "!continue");
    }

    private void inFor() {
        this.registerBasic(OCCompletionPatterns.IN_FOR, "!in ");
    }

    private void inSwitch() {
        this.registerBasic(OCCompletionPatterns.IN_SWITCH, "!break", "!case <caret>:", "!default:");
    }

    private void inTry() {
        this.registerProviderForObjcKeyword((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.AT_STATEMENT_LEVEL.and(OCCompletionPatterns.afterTry(false))), (ElementPattern<PsiElement>)PlatformPatterns.and((ElementPattern[])new ElementPattern[]{OCCompletionPatterns.like(OCObjCErrorKeywordImpl.class), OCCompletionPatterns.afterTry(false)}), 1, "!finally", "!catch");
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.AT_STATEMENT_LEVEL.and(OCCompletionPatterns.afterTry(true))), "!catch");
    }

    private void registerDeclarationProviderWithAt(@NotNull Class<? extends PsiElement> parentClass, String ... items) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "registerDeclarationProviderWithAt"));
        }
        this.registerProviderForObjcKeyword((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION.withSuperParent(3, OCCompletionPatterns.like(parentClass))), OCCompletionPatterns.like(parentClass), 2, items);
    }

    private void inInterface() {
        this.registerDeclarationProviderWithAt(OCInterface.class, "!property ", "!end");
    }

    private void inIvarsList() {
        this.registerDeclarationProviderWithAt(OCInstanceVariablesList.class, "public ", "protected ", "private ", "package ");
    }

    private void inProtocol() {
        this.registerDeclarationProviderWithAt(OCProtocol.class, "!optional ", "!required ", "!end");
    }

    private void inImplementation() {
        this.registerDeclarationProviderWithAt(OCImplementation.class, "synthesize ", "dynamic ", "!end");
    }

    private void atUnqualifiedTypePosition() {
        String[] common = new String[]{"volatile ", "void ", "char ", "!int ", "signed ", "unsigned ", "float ", "double ", "short ", "long ", "enum ", "struct ", "union ", "static ", "const "};
        String[] objcCommon = new String[]{"!__block ", "!__strong ", "!__weak ", "!__unsafe_unretained "};
        this.registerBasic(OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION, ArrayUtil.mergeArrays((String[])common, (String[])new String[]{"auto ", "typedef ", "register "}));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)), ArrayUtil.mergeArrays((String[])objcCommon, (String[])new String[]{"!__autoreleasing "}));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)), OCKeywordCompletionContributor.filtered(OCKeywordCompletionContributor.provider(null, null, ContainerUtil.list((Object[])new Keyword[]{OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NULLABLE_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NONNULL_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NULL_UNSPECIFIED_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword("__nullable", false), OCKeywordCompletionContributor.typeAttributeKeyword("__nonnull", false), OCKeywordCompletionContributor.typeAttributeKeyword("__null_unspecified", false)})), NULLABILITY_FEATURE_ENABLED_FILTER));
        PsiElementPattern.Capture typeElementInMethodDefinition = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.ELEMENT.withSuperParent(2, OCTypeElement.class)).with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)).andOr(new ElementPattern[]{OCCompletionPatterns.ELEMENT.withSuperParent(3, OCMethod.class), OCCompletionPatterns.ELEMENT.withSuperParent(3, OCMethodSelectorPart.class)});
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)typeElementInMethodDefinition, OCKeywordCompletionContributor.provider(null, null, ContainerUtil.map(OCElementTypes.PARAMETER_TYPE_QUALIFIERS, (Function)new Function<String, Keyword>(){

            public Keyword fun(String s) {
                return OCKeywordCompletionContributor.typeAttributeKeyword(s, true);
            }
        })));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)typeElementInMethodDefinition, OCKeywordCompletionContributor.filtered(OCKeywordCompletionContributor.provider(null, null, ContainerUtil.map(OCElementTypes.PARAMETER_TYPE_NULLABILITY_QUALIFIERS, (Function)new Function<String, Keyword>(){

            public Keyword fun(String s) {
                return OCKeywordCompletionContributor.typeAttributeKeyword(s, true);
            }
        })), NULLABILITY_FEATURE_ENABLED_FILTER));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)).withSuperParent(3, OCMethod.class)).with((PatternCondition)new PatternCondition<PsiElement>("instancetype compatibility check"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$6", "accepts"));
                }
                return OCCompilerHelper.supportsInstancetype(element.getContainingFile());
            }
        })), "instancetype");
        String[] cppNewTypes = new String[]{"bool ", "char16_t ", "char32_t ", "class ", "decltype(<caret>)", "wchar_t "};
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_DECLARATION.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), ArrayUtil.mergeArrays((String[])cppNewTypes, (String[])new String[]{KEYWORD_ALIGNAS, "constexpr ", "template ", "thread_local", "typename ", "using "}));
        this.registerBasic(OCCompletionPatterns.SIMPLE_TYPE_IN_CAST, common);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_CAST.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)), ArrayUtil.mergeArrays((String[])objcCommon, (String[])new String[]{"!__bridge ", "!__bridge_retained ", "!__bridge_transfer "}));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_CAST.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), cppNewTypes);
        PsiElementPattern.Capture nameInDeclaration = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.NAME_IN_DECLARATION.andNot(OCCompletionPatterns.AFTER_TILDE)).andNot(OCCompletionPatterns.AFTER_DOT);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)nameInDeclaration, "const ");
        PsiElementPattern.Capture nameInDeclarationCpp = (PsiElementPattern.Capture)nameInDeclaration.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)nameInDeclarationCpp.withParent((ElementPattern)PlatformPatterns.psiElement().afterSiblingSkipping(OCCompletionPatterns.WHITESPACES_AND_COMMENTS, (ElementPattern)PlatformPatterns.psiElement(OCTypeElement.class).withChild((ElementPattern)PlatformPatterns.psiElement(OCStruct.class))))), "final");
        LookupDecorator opDecorator = new LookupDecorator(){

            @Override
            @NotNull
            public LookupElementBuilder decorate(@NotNull OCCompletionParameters parameters, @NotNull LookupElementBuilder builder) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$7", "decorate"));
                }
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$7", "decorate"));
                }
                Project project = parameters.getOriginalFile().getProject();
                OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
                if (settings.SPACE_BETWEEN_OPERATOR_AND_PUNCTUATOR) {
                    builder = builder.withInsertHandler((InsertHandler)new AddSpaceInsertHandler(false));
                }
                LookupElementBuilder lookupElementBuilder = builder;
                if (lookupElementBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$7", "decorate"));
                }
                return lookupElementBuilder;
            }
        };
        Keyword opKeyword = new Keyword("operator", OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY, opDecorator);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)nameInDeclarationCpp.inside(true, (ElementPattern)PlatformPatterns.instanceOf(OCStruct.class), (ElementPattern)PlatformPatterns.psiElement(OCBlockStatement.class))), OCKeywordCompletionContributor.provider(null, null, Collections.singletonList(opKeyword)));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.NAME_IN_DECLARATION.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)), ArrayUtil.mergeArrays((String[])objcCommon, (String[])new String[]{"!__autoreleasing "}));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.NAME_IN_DECLARATION.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN)), OCKeywordCompletionContributor.filtered(OCKeywordCompletionContributor.provider(null, null, ContainerUtil.list((Object[])new Keyword[]{OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NULLABLE_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NONNULL_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword(OCTokenTypes._NULL_UNSPECIFIED_KEYWORD.getName(), true), OCKeywordCompletionContributor.typeAttributeKeyword("__nullable", false), OCKeywordCompletionContributor.typeAttributeKeyword("__nonnull", false), OCKeywordCompletionContributor.typeAttributeKeyword("__null_unspecified", false)})), NULLABILITY_FEATURE_ENABLED_FILTER));
        PsiElementPattern.Capture inTypeOperator = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCReferenceExpression.class).withParent(PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(OCSizeofExpression.class), PlatformPatterns.psiElement(OCCppTypeidExpression.class)})))).andNot(OCCompletionPatterns.AFTER_DOT);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)inTypeOperator, OCKeywordCompletionContributor.provider(common));
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)inTypeOperator.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN), OCKeywordCompletionContributor.provider(cppNewTypes));
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCStructLike.class))).with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), KEYWORD_ALIGNAS);
    }

    private void inPropertyAttribute() {
        this.registerBasic(OCCompletionPatterns.AT_PROPERTY_ATTRIBUTE, OCPropertySymbol.PropertyAttribute.ASSIGN.getTokenName(), OCPropertySymbol.PropertyAttribute.COPY.getTokenName(), OCPropertySymbol.PropertyAttribute.UNSAFE_UNRETAINED.getTokenName(), OCPropertySymbol.PropertyAttribute.WEAK.getTokenName(), OCPropertySymbol.PropertyAttribute.STRONG.getTokenName(), OCPropertySymbol.PropertyAttribute.GETTER.getTokenName() + "=<#method#>", OCPropertySymbol.PropertyAttribute.SETTER.getTokenName() + "=<#method#>", OCPropertySymbol.PropertyAttribute.ATOMIC.getTokenName(), OCPropertySymbol.PropertyAttribute.NONATOMIC.getTokenName(), OCPropertySymbol.PropertyAttribute.READONLY.getTokenName(), OCPropertySymbol.PropertyAttribute.READWRITE.getTokenName(), OCPropertySymbol.PropertyAttribute.RETAIN.getTokenName());
        this.registerBasic(OCCompletionPatterns.AT_PROPERTY_ATTRIBUTE, NULLABILITY_FEATURE_ENABLED_FILTER, OCPropertySymbol.PropertyAttribute.NONNULL.getTokenName(), OCPropertySymbol.PropertyAttribute.NULLABLE.getTokenName(), OCPropertySymbol.PropertyAttribute.NULL_RESETTABLE.getTokenName());
    }

    private void preprocessorDirectives() {
        PsiElementPattern.Capture excludedByCC = PlatformPatterns.psiElement((IElementType)OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT);
        PsiElementPattern.Capture afterNewLine = (PsiElementPattern.Capture)OCCompletionPatterns.ELEMENT.andOr(new ElementPattern[]{OCCompletionPatterns.TOP_LEVEL_ELEMENT, OCCompletionPatterns.ELEMENT.with((PatternCondition)new PatternCondition<PsiElement>("afterNewLine"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$8", "accepts"));
                }
                PsiElement current = element;
                if (!element.getText().startsWith("#")) {
                    return false;
                }
                while ((current = OCElementUtil.getPrevLeaf(current)) instanceof PsiWhiteSpace || current != null && current.getTextLength() == 0) {
                    if (!current.getText().contains("\n")) continue;
                    return true;
                }
                return current == null;
            }
        })});
        String[] directives = new String[]{"#import \"<caret>\"", "#import <<caret>>", "#include \"<caret>\"", "#include <<caret>>", "#pragma ", "#define ", "#undef", "#if ", "#ifdef ", "#ifndef ", "#else ", "#elif ", "#endif", "#error ", "#warning "};
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)afterNewLine, directives);
        this.extend(CompletionType.BASIC, (ElementPattern)excludedByCC, OCKeywordCompletionContributor.rawProvider(OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY, directives));
    }

    private void registerProviderForObjcKeyword(PsiElementPattern.Capture<PsiElement> identifierCapture, ElementPattern<PsiElement> keywordCapture, int keywordDepth, String ... lookupString) {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)identifierCapture.with(OCCompletionPatterns.OBJC_ELEMENT_PATTERN), OCKeywordCompletionContributor.provider(Character.valueOf('@'), null, OCKeywordCompletionContributor.keywords(lookupString)));
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.OBJC_ERROR_KEYWORD.withSuperParent(keywordDepth, keywordCapture), OCKeywordCompletionContributor.provider(null, Character.valueOf('@'), OCKeywordCompletionContributor.keywords(lookupString)));
    }

    private void registerBasic(PsiElementPattern.Capture<PsiElement> capture, OCCompletionProvider provider) {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)capture, provider);
    }

    private void registerBasic(PsiElementPattern.Capture<PsiElement> capture, String ... keywords) {
        this.registerBasic(capture, OCKeywordCompletionContributor.provider(keywords));
    }

    private void registerBasic(PsiElementPattern.Capture<PsiElement> capture, Condition<OCFilteredCompletionProvider.Filter> filter, String ... keywords) {
        this.registerBasic(capture, OCKeywordCompletionContributor.filtered(OCKeywordCompletionContributor.provider(keywords), filter));
    }

    private void topLevel() {
        this.registerDeclarationProviderWithAt(OCFile.class, "protocol ", "interface ", "implementation ", "import ", "class ", "compatibility_alias ");
        this.registerBasic(OCCompletionPatterns.SIMPLE_TYPE_IN_TOP_LEVEL_DECLARATION, KEYWORD_EXTERN);
        this.registerBasic(OCCompletionPatterns.SIMPLE_TYPE_IN_NON_BLOCK_DECLARATION, "inline ", "typedef ", "register ", "volatile ", "enum ", "struct ", "union ", KEYWORD_ASM);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_TOP_LEVEL_DECLARATION.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), KEYWORD_NAMESPACE);
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_NON_BLOCK_DECLARATION.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), "explicit ", "class ");
        this.registerBasic((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)OCCompletionPatterns.SIMPLE_TYPE_IN_NAMESPACE_DECLARATION.with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)), KEYWORD_EXTERN, KEYWORD_NAMESPACE);
        this.registerBasic(OCCompletionPatterns.IN_CPP_STRUCT, "friend ", "mutable ", "!virtual ", "!public:", "!protected:", "!private:", "static_assert(<caret>)");
    }

    private static OCCompletionProvider returnProvider() {
        return new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$9", "addCompletions"));
                }
                if (parameters.getPosition() instanceof PsiComment) {
                    return;
                }
                OCExpression receiver = OCKeywordCompletionContributor.methodReceiver(parameters);
                if (receiver != null) {
                    MethodSelectorCompletionContributor.addCompletionsForReceiver(receiver, "", parameters, result2, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                    return;
                }
                CompletionResultSet set = OCKeywordCompletionContributor.withOCPrefixMather(result2, parameters.getRealPosition(), parameters.getOffset());
                OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{OCCallable.class});
                if (callable != null) {
                    OCType type = callable.getReturnType();
                    LookupElementBuilder lookup = TemplateInsertHandler.lookup("return").bold();
                    final boolean isVoid = type.equalsAfterResolving(OCVoidType.instance(), callable.getContainingOCFile());
                    TailTypeDecorator<LookupElement> withTail = new TailTypeDecorator<LookupElement>((LookupElement)lookup){

                        @Override
                        @Nullable
                        protected TailType computeTailType(InsertionContext context) {
                            char completionChar = context.getCompletionChar();
                            if (isVoid) {
                                return completionChar == ' ' ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.SEMICOLON;
                            }
                            return completionChar == ';' ? TailType.SEMICOLON : TailType.HUMBLE_SPACE_BEFORE_WORD;
                        }
                    };
                    set.addElement(OCCompletionPriority.keywordWithPriority((LookupElement)withTail, OCCompletionPriority.HIGH_KEYWORDS_PRIORITY));
                }
            }
        };
    }

    @NotNull
    private static OCCompletionProvider provider(String ... keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "provider"));
        }
        OCCompletionProvider oCCompletionProvider = OCKeywordCompletionContributor.provider(null, null, OCKeywordCompletionContributor.keywords(keywords));
        if (oCCompletionProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "provider"));
        }
        return oCCompletionProvider;
    }

    @NotNull
    static OCCompletionProvider filtered(@NotNull OCCompletionProvider provider, @NotNull Condition<OCFilteredCompletionProvider.Filter> filter) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "filtered"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "filtered"));
        }
        OCFilteredCompletionProvider oCFilteredCompletionProvider = new OCFilteredCompletionProvider(provider, filter);
        if (oCFilteredCompletionProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "filtered"));
        }
        return oCFilteredCompletionProvider;
    }

    @NotNull
    private static List<Keyword> keywords(String ... keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "keywords"));
        }
        List list = ContainerUtil.map((Object[])keywords, (Function)new Function<String, Keyword>(){

            public Keyword fun(String lookUpString) {
                OCCompletionPriority priority;
                if (lookUpString.startsWith("!")) {
                    lookUpString = lookUpString.substring(1, lookUpString.length());
                    priority = OCCompletionPriority.HIGH_KEYWORDS_PRIORITY;
                } else if (lookUpString.startsWith("?")) {
                    lookUpString = lookUpString.substring(1, lookUpString.length());
                    priority = OCCompletionPriority.LOW_KEYWORDS_PRIORITY;
                } else {
                    priority = OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY;
                }
                return new Keyword(lookUpString, priority, null);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "keywords"));
        }
        return list;
    }

    @NotNull
    private static Keyword typeAttributeKeyword(String keyword, boolean highPriority) {
        Keyword keyword2 = new Keyword(keyword, highPriority ? OCCompletionPriority.HIGH_KEYWORDS_PRIORITY : OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY, TYPE_ATTRIBUTE_DECORATOR);
        if (keyword2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "typeAttributeKeyword"));
        }
        return keyword2;
    }

    @NotNull
    private static OCCompletionProvider provider(final @Nullable Character keywordPrefix, final @Nullable Character presentationPrefix, final @NotNull List<Keyword> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "provider"));
        }
        OCCompletionProvider oCCompletionProvider = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$11", "addCompletions"));
                }
                if (parameters.getPosition() instanceof PsiComment || OCKeywordCompletionContributor.methodReceiver(parameters) != null) {
                    return;
                }
                CompletionResultSet set = OCKeywordCompletionContributor.withOCPrefixMather(result2, parameters.getRealPosition(), parameters.getOffset());
                String atPrefix = "@" + prefix;
                boolean prefixStartsWithUnderscore = prefix.startsWith("_");
                for (Keyword kw : keywords) {
                    String lookUpString = kw.lookUpString;
                    if (keywordPrefix != null) {
                        lookUpString = keywordPrefix + lookUpString;
                    }
                    if (!StringUtil.startsWithIgnoreCase((String)lookUpString, (String)prefix) && !StringUtil.startsWithIgnoreCase((String)lookUpString, (String)atPrefix) || !prefixStartsWithUnderscore && lookUpString.startsWith("_")) continue;
                    LookupElementBuilder lookup = TemplateInsertHandler.lookup(lookUpString);
                    if (presentationPrefix != null) {
                        lookup = lookup.withPresentableText(presentationPrefix + lookup.getLookupString());
                    }
                    if (kw.decorator != null) {
                        lookup = kw.decorator.decorate(parameters, lookup);
                    }
                    set.addElement(OCCompletionPriority.keywordWithPriority((LookupElement)lookup, kw.priority));
                }
            }
        };
        if (oCCompletionProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "provider"));
        }
        return oCCompletionProvider;
    }

    @NotNull
    private static CompletionProvider<CompletionParameters> rawProvider(final OCCompletionPriority priority, final String ... keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "rawProvider"));
        }
        CompletionProvider<CompletionParameters> completionProvider = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$12", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$12", "addCompletions"));
                }
                CompletionResultSet set = OCKeywordCompletionContributor.withOCPrefixMather(result2, parameters.getPosition(), parameters.getOffset());
                for (String keyword : keywords) {
                    set.addElement(OCCompletionPriority.keywordWithPriority((LookupElement)TemplateInsertHandler.lookup(keyword), priority));
                }
            }
        };
        if (completionProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "rawProvider"));
        }
        return completionProvider;
    }

    public static CompletionResultSet withOCPrefixMather(CompletionResultSet result2, PsiElement position, int offset) {
        ObjectPattern.Capture pattern = PlatformPatterns.not((ElementPattern)PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.character().javaIdentifierPart(), PlatformPatterns.character().oneOf((Object[])new Character[]{Character.valueOf('@'), Character.valueOf('#')})}));
        String prefix = position instanceof PsiComment && ((PsiComment)position).getTokenType() == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT ? CompletionData.findPrefixDefault(position, offset, (ElementPattern)pattern) : CompletionData.findPrefixStatic(position, offset, (ElementPattern<Character>)pattern);
        return result2.withPrefixMatcher(prefix);
    }

    private static OCExpression methodReceiver(OCCompletionParameters parameters) {
        PsiFile file2 = parameters.getOriginalFile();
        if (file2 instanceof OCCodeFragment && ((OCCodeFragment)file2).getCompletionFilter() != null) {
            return null;
        }
        OCStatement stmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), OCStatement.class);
        if (stmt instanceof OCDeclarationStatement || stmt instanceof OCExpressionStatement) {
            PsiElement prevStmt = stmt.getPrevSibling();
            if (prevStmt instanceof PsiWhiteSpace && prevStmt.getText().indexOf(10) == -1) {
                prevStmt = prevStmt.getPrevSibling();
            }
            if (prevStmt instanceof OCExpressionStatement && !prevStmt.getText().endsWith(";")) {
                return OCKeywordCompletionContributor.getSelectorReceiver(((OCExpressionStatement)prevStmt).getExpression());
            }
        }
        return null;
    }

    @Nullable
    private static OCExpression getSelectorReceiver(@NotNull OCExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor", "getSelectorReceiver"));
        }
        OCExpression result2 = expression;
        OCExpression current = null;
        while (current != result2) {
            current = result2;
            if (current instanceof OCBinaryExpression) {
                result2 = ((OCBinaryExpression)current).getRight();
                continue;
            }
            if (current instanceof OCConditionalExpression) {
                result2 = ((OCConditionalExpression)current).getNegativeExpression();
                continue;
            }
            if (current instanceof OCAssignmentExpression) {
                result2 = ((OCAssignmentExpression)current).getSourceExpression();
                continue;
            }
            if (!(current instanceof OCCommaExpression)) continue;
            result2 = ((OCCommaExpression)current).getTailExpression();
        }
        return result2;
    }

    private static class Keyword {
        @NotNull
        final String lookUpString;
        @NotNull
        final OCCompletionPriority priority;
        @Nullable
        final LookupDecorator decorator;

        public Keyword(@NotNull String lookUpString, @NotNull OCCompletionPriority priority, @Nullable LookupDecorator decorator) {
            if (lookUpString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookUpString", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$Keyword", "<init>"));
            }
            if (priority == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/jetbrains/cidr/lang/editor/completion/OCKeywordCompletionContributor$Keyword", "<init>"));
            }
            this.lookUpString = lookUpString;
            this.priority = priority;
            this.decorator = decorator;
        }
    }

    private static interface LookupDecorator {
        @NotNull
        public LookupElementBuilder decorate(@NotNull OCCompletionParameters var1, @NotNull LookupElementBuilder var2);
    }
}

