/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (file2.getLanguage() != OCLanguage.getInstance()) {
            return null;
        }
        boolean isLiteral = true;
        for (int i = 0; i < startOffsets.length && isLiteral; ++i) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file2, startOffsets[i], endOffsets[i]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        if (file2.getLanguage() != OCLanguage.getInstance()) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file2, selectionStart, selectionEnd);
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
                }
                return string;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = "\\n\"\n \"";
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i == lines.length - 1) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
                }
                return string;
            }
            String string = OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    @Nullable
    private static IElementType findLiteralTokenType(PsiFile file2, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelection = file2.findElementAt(selectionStart);
        if (elementAtSelection == null) {
            return null;
        }
        if (elementAtSelection.getNode() == null) {
            OCLog.LOG.error("node is null for " + elementAtSelection + "\n\tin " + file2);
            return null;
        }
        IElementType tokenType = elementAtSelection.getNode().getElementType();
        if (tokenType != OCTokenTypes.STRING_LITERAL && tokenType != OCTokenTypes.CHARACTER_LITERAL) {
            return null;
        }
        TextRange textRange = elementAtSelection.getTextRange();
        if (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return tokenType;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "escapeCharCharacters"));
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor", "escapeCharCharacters"));
        }
        return string;
    }
}

