/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet CONCATENATABLE_STRING = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.STRING_LITERAL});

    public OCQuoteHandler() {
        super(OCTokenTypes.STRING_LITERAL, OCTokenTypes.CHARACTER_LITERAL);
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    @Override
    public TokenSet getConcatenatableStringTokenTypes() {
        return TokenSet.EMPTY;
    }

    @Override
    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    @Override
    public TokenSet getStringTokenTypes() {
        return CONCATENATABLE_STRING;
    }

    @Override
    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/jetbrains/cidr/lang/editor/OCQuoteHandler", "isAppropriateElementTypeForLiteral"));
        }
        return OCQuoteHandler.isAppropriateElementTypeForLiteralStatic(tokenType);
    }

    public static boolean isAppropriateElementTypeForLiteralStatic(IElementType tokenType) {
        return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL;
    }

    @Override
    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }
}

