/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.formatting.Indent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCEnterInTemplateHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int offsetLT;
        int offsetTemplateKeyword;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "preprocessEnter"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        Project project = editor.getProject();
        if (project == null || project.isDisposed() || !(PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        boolean atEOF = caretOffset == document.getTextLength() && caretOffset > 0;
        PsiElement psiAtCaret = file2.findElementAt(atEOF ? caretOffset - 1 : caretOffset);
        if (psiAtCaret == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        IElementType typeAtCaret = OCElementUtil.getElementType(psiAtCaret);
        TextRange psiAtCaretTextRange = psiAtCaret.getTextRange();
        int psiAtCaretEndOffset = psiAtCaretTextRange.getEndOffset();
        int psiAtCaretStartOffset = psiAtCaretTextRange.getStartOffset();
        boolean atEnd = psiAtCaretEndOffset == caretOffset;
        boolean atStart = psiAtCaretStartOffset == caretOffset;
        boolean spaceAtCaret = typeAtCaret == TokenType.WHITE_SPACE;
        PsiElement templateKeyword = null;
        if ((spaceAtCaret || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(typeAtCaret) && (atStart || atEnd) || (typeAtCaret == OCTokenTypes.GT || typeAtCaret == OCTokenTypes.GTGT) && atEnd) && (offsetTemplateKeyword = OCTypedHandlerDelegate.needEnterTreatAfterTemplateList(((EditorEx)editor).getHighlighter().createIterator(caretOffset))) >= 0) {
            templateKeyword = file2.findElementAt(offsetTemplateKeyword);
        }
        if (templateKeyword != null) {
            boolean needIndent;
            PsiElement parent = templateKeyword.getParent();
            IElementType parentType = OCElementUtil.getElementType(parent);
            boolean nextTemplate = OCEnterInTemplateHandler.nextIsStopType(((EditorEx)editor).getHighlighter().createIterator(psiAtCaretEndOffset), OCTokenTypes.TEMPLATE_CPP_KEYWORD);
            if (!(nextTemplate || parentType != OCElementTypes.FUNCTION_DECLARATION && parentType != OCElementTypes.FUNCTION_DEFINITION && parentType != OCElementTypes.DECLARATION)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
            boolean bl = needIndent = settings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && settings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT;
            if (nextTemplate) {
                needIndent &= psiAtCaret instanceof PsiWhiteSpace && psiAtCaret.getText().indexOf(10, caretOffset - psiAtCaretStartOffset) >= 0;
            }
            OCEnterInTemplateHandler.insertIndent(file2, editor, caretAdvanceRef, dataContext, originalHandler, project, document, psiAtCaret, needIndent ? Indent.Type.NORMAL : Indent.Type.NONE, caretOffset, psiAtCaretStartOffset, spaceAtCaret);
            return EnterHandlerDelegate.Result.Stop;
        }
        PsiElement psiLTorComma = null;
        if ((spaceAtCaret || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(typeAtCaret) && (atStart || atEnd) || typeAtCaret == OCTokenTypes.LT && atEnd || (typeAtCaret == OCTokenTypes.GT || typeAtCaret == OCTokenTypes.GTGT) && atStart) && (offsetLT = OCEnterInTemplateHandler.offsetOfStopType(((EditorEx)editor).getHighlighter().createIterator(typeAtCaret == OCTokenTypes.GT || typeAtCaret == OCTokenTypes.GTGT ? caretOffset - 1 : caretOffset), OCTokenTypes.LT, OCTokenTypes.COMMA)) >= 0) {
            psiLTorComma = file2.findElementAt(offsetLT);
        }
        if (psiLTorComma != null) {
            boolean nextGT;
            PsiElement parent = psiLTorComma.getParent();
            IElementType parentType = OCElementUtil.getElementType(parent);
            boolean bl = nextGT = typeAtCaret == OCTokenTypes.GT || typeAtCaret == OCTokenTypes.GTGT || OCEnterInTemplateHandler.nextIsStopType(((EditorEx)editor).getHighlighter().createIterator(psiAtCaretEndOffset), OCTokenTypes.GT, OCTokenTypes.GTGT);
            if (!nextGT || parentType != OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST && parentType != OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                return EnterHandlerDelegate.Result.Continue;
            }
            OCEnterInTemplateHandler.insertIndent(file2, editor, caretAdvanceRef, dataContext, originalHandler, project, document, psiAtCaret, Indent.Type.CONTINUATION, caretOffset, psiAtCaretStartOffset, spaceAtCaret);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static void insertIndent(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, @NotNull EditorActionHandler originalHandler, @NotNull Project project, @NotNull Document document, @NotNull PsiElement psiAtCaret, @NotNull Indent.Type indent, int caretOffset, int psiAtCaretStartOffset, boolean spaceAtCaret) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (originalHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalHandler", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (psiAtCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAtCaret", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "insertIndent"));
        }
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER && spaceAtCaret) {
            int deleteTo;
            String ws = psiAtCaret.getText();
            int wsLength = ws.length();
            for (deleteTo = caretOffset - psiAtCaretStartOffset; deleteTo < wsLength && "\t ".indexOf(ws.charAt(deleteTo)) >= 0; ++deleteTo) {
            }
            document.deleteString(caretOffset, psiAtCaretStartOffset + deleteTo);
        }
        CaretModel caretModel = editor.getCaretModel();
        originalHandler.execute(editor, caretModel.getCurrentCaret(), dataContext);
        if (indent != Indent.Type.NONE) {
            CommonCodeStyleSettings.IndentOptions indentOptionsByFile = CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile(file2);
            int indentSize = indent == Indent.Type.CONTINUATION ? indentOptionsByFile.CONTINUATION_INDENT_SIZE : indentOptionsByFile.INDENT_SIZE;
            document.insertString(caretModel.getOffset(), (CharSequence)StringUtil.repeatSymbol((char)' ', (int)indentSize));
            caretAdvanceRef.set((Object)((Integer)caretAdvanceRef.get() + indentSize));
        }
    }

    private static boolean nextIsStopType(@NotNull HighlighterIterator it, IElementType ... stopTypes) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "nextIsStopType"));
        }
        if (stopTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopTypes", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "nextIsStopType"));
        }
        List<IElementType> types = Arrays.asList(stopTypes);
        while (!it.atEnd()) {
            IElementType currType = it.getTokenType();
            if (types.contains(currType)) {
                return true;
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(currType)) break;
            it.advance();
        }
        return false;
    }

    private static int offsetOfStopType(@NotNull HighlighterIterator it, IElementType ... stopTypes) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "offsetOfStopType"));
        }
        if (stopTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopTypes", "com/jetbrains/cidr/lang/editor/OCEnterInTemplateHandler", "offsetOfStopType"));
        }
        List<IElementType> types = Arrays.asList(stopTypes);
        while (((LexerEditorHighlighter.HighlighterIteratorImpl)it).currentIndex() >= 0) {
            IElementType currType = it.getTokenType();
            if (types.contains(currType)) {
                return it.getStart();
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(currType)) break;
            it.retreat();
        }
        return -1;
    }
}

