/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEnterInDirectiveAndNoncompiledHandler
extends EnterHandlerDelegateAdapter {
    private static final TokenSet WHITE_SPACE_OR_COMMENT = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, OCTokenTypes.BLOCK_COMMENT, OCTokenTypes.EOL_COMMENT, OCTokenTypes.CODE_DIRECTIVE_CONTENT});

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        IElementType ownerType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "preprocessEnter"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!(PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        PsiElement psiAtOffset = file2.findElementAt(caretOffset == document.getTextLength() && caretOffset > 0 ? caretOffset - 1 : caretOffset);
        PsiElement lineStarter = psiAtOffset;
        if (WHITE_SPACE_OR_COMMENT.contains(OCElementUtil.getElementType(lineStarter)) && !lineStarter.getText().substring(0, caretOffset - psiAtOffset.getTextOffset()).contains("\n")) {
            lineStarter = psiAtOffset.getPrevSibling();
        }
        if ((ownerType = OCElementUtil.getElementType(lineStarter)) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
            assert (lineStarter != null);
            CharSequence documentChars = document.getCharsSequence();
            HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(caretOffset);
            if (!it.atEnd() && WHITE_SPACE_OR_COMMENT.contains(it.getTokenType()) && !OCEnterInDirectiveAndNoncompiledHandler.containsNewLine(documentChars, it.getStart(), Math.min(it.getEnd(), caretOffset))) {
                it.retreat();
            }
            while (!it.atEnd() && !OCEnterInDirectiveAndNoncompiledHandler.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                it.retreat();
            }
            if (!it.atEnd()) {
                IElementType maybeDirectiveType;
                it.advance();
                IElementType iElementType = maybeDirectiveType = it.atEnd() ? null : it.getTokenType();
                if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(maybeDirectiveType)) {
                    if (OCTokenTypes.END_IF_DIRECTIVES.contains(maybeDirectiveType)) {
                        it.retreat();
                        if (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE && OCEnterInDirectiveAndNoncompiledHandler.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                            OCEnterInDirectiveAndNoncompiledHandler.adjustLineIndent(caretOffsetRef, it.getEnd(), document, (String)OCMultilineNodeFormatter.splitIndent((String)documentChars.subSequence((int)it.getStart(), (int)it.getEnd()).toString()).second, OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(it, file2, false));
                        }
                    }
                    String text = lineStarter.getText();
                    if (lineStarter != psiAtOffset) {
                        text = text + psiAtOffset.getText();
                    }
                    int caretInNode = Math.min(text.length(), caretOffset - lineStarter.getTextOffset());
                    String newText = text.substring(0, caretInNode) + "\n\n" + text.substring(caretInNode);
                    String newLineCodeIndent = OCMultilineNodeFormatter.indentAtOffsetInNoncompiledCode(lineStarter, newText, lineStarter.getTextOffset() + ++caretInNode);
                    if (newLineCodeIndent != null) {
                        caretOffset = (Integer)caretOffsetRef.get();
                        newLineCodeIndent = "\n" + newLineCodeIndent;
                        document.insertString(caretOffset, (CharSequence)newLineCodeIndent);
                        editor.getCaretModel().moveToOffset(caretOffset + newLineCodeIndent.length());
                        return EnterHandlerDelegate.Result.Stop;
                    }
                }
            }
        } else {
            while (WHITE_SPACE_OR_COMMENT.contains(OCElementUtil.getElementType(lineStarter)) && !lineStarter.textContains('\n')) {
                lineStarter = lineStarter.getPrevSibling();
            }
            while (lineStarter != null && !OCFormatterUtil.FORMAT_DIRECTIVES.contains(OCElementUtil.getElementType(lineStarter))) {
                lineStarter = lineStarter.getParent();
            }
            if (lineStarter != null) {
                ownerType = lineStarter.getFirstChild() != null ? OCElementUtil.getElementType(lineStarter.getFirstChild()) : OCElementUtil.getElementType(lineStarter);
                if (OCTokenTypes.END_IF_DIRECTIVES.contains(ownerType) && OCElementUtil.getElementType(lineStarter = PsiTreeUtil.prevLeaf((PsiElement)lineStarter)) == TokenType.WHITE_SPACE && lineStarter.textContains('\n')) {
                    int endOffset = lineStarter.getTextRange().getEndOffset();
                    OCEnterInDirectiveAndNoncompiledHandler.adjustLineIndent(caretOffsetRef, endOffset, document, (String)OCMultilineNodeFormatter.splitIndent((String)lineStarter.getText()).second, OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(((EditorEx)editor).getHighlighter().createIterator(lineStarter.getTextOffset()), file2, false));
                }
                OCEnterInDirectiveAndNoncompiledHandler.doEasyEnter(file2, editor, document, caretOffsetRef);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static void doEasyEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Document document, @NotNull Ref<Integer> caretOffsetRef) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "doEasyEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "doEasyEnter"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "doEasyEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "doEasyEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int anchorLine = document.getLineNumber(caretOffset);
        document.insertString(caretOffset++, (CharSequence)"\n");
        editor.getCaretModel().moveToOffset(caretOffset);
        String newLineCodeIndent = CodeStyleManager.getInstance((Project)file2.getProject()).getLineIndent(file2, Math.max(document.getLineStartOffset(anchorLine) - 1, 0));
        if (newLineCodeIndent != null) {
            OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file2.getProject());
            int indent = multilineNodeFormatter.indent(newLineCodeIndent);
            newLineCodeIndent = multilineNodeFormatter.getStringIndent(indent);
            document.insertString(caretOffset, (CharSequence)newLineCodeIndent);
            editor.getCaretModel().moveToOffset(caretOffset + newLineCodeIndent.length());
        }
    }

    private static void adjustLineIndent(@NotNull Ref<Integer> caretOffsetRef, int endOffset, @NotNull Document document, @NotNull String originalIndent, @Nullable String newIndent) {
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "adjustLineIndent"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "adjustLineIndent"));
        }
        if (originalIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalIndent", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "adjustLineIndent"));
        }
        if (newIndent != null && !newIndent.equals(originalIndent)) {
            document.replaceString(endOffset - originalIndent.length(), endOffset, (CharSequence)newIndent);
            caretOffsetRef.set((Object)((Integer)caretOffsetRef.get() + newIndent.length() - originalIndent.length()));
        }
    }

    private static boolean containsNewLine(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler", "containsNewLine"));
        }
        return StringUtil.contains((CharSequence)text, (int)start, (int)end, (char)'\n');
    }
}

