/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCEnterAfterUnmatchedBraceHandler");

    @Override
    public boolean isApplicable(@NotNull PsiFile file2, int caretOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler", "isApplicable"));
        }
        return PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage && !DumbService.isDumb((Project)file2.getProject());
    }

    @Override
    protected boolean isStopChar(char c) {
        return "}\n".indexOf(c) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file2, @NotNull Document document, int caretOffset, int rBracesInsertOffset, int rBracesCount) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler", "formatCodeFragmentBetweenBraces"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler", "formatCodeFragmentBetweenBraces"));
        }
        Project project = file2.getProject();
        CommonCodeStyleSettings commonSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCommonSettings((Language)OCLanguage.getInstance());
        assert (commonSettings != null);
        int origKEEP_BLANK_LINES_BEFORE_RBRACE = commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 1;
        try {
            CodeStyleManager instance = CodeStyleManager.getInstance((Project)project);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            instance.reformatText(file2, rBracesInsertOffset + 1, rBracesInsertOffset + rBracesCount + 2);
            instance.adjustLineIndent(file2, new TextRange(caretOffset, rBracesInsertOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            document.deleteString(caretOffset, caretOffset + 1);
            commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = origKEEP_BLANK_LINES_BEFORE_RBRACE;
        }
    }

    @Override
    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file2, @NotNull CharSequence text, int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler", "calculateOffsetToInsertClosingBrace"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/editor/OCEnterAfterUnmatchedBraceHandler", "calculateOffsetToInsertClosingBrace"));
        }
        Pair<PsiElement, Integer> pair = super.calculateOffsetToInsertClosingBrace(file2, text, offset);
        PsiElement element = (PsiElement)pair.first;
        int endOffset = (Integer)pair.second;
        if (OCElementUtil.getElementType(element) == OCElementTypes.MACRO_CALL) {
            ASTNode nextNode;
            PsiElement next = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)endOffset);
            for (nextNode = next.getNode(); nextNode != null && OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(nextNode)) && !(nextNode instanceof OCMacroForeignLeafElement); nextNode = nextNode.getTreeNext()) {
            }
            if (OCElementUtil.getElementType(nextNode) == OCTokenTypes.SEMICOLON && !(nextNode instanceof OCMacroForeignLeafElement)) {
                endOffset = nextNode.getTextRange().getEndOffset();
            }
        }
        return Pair.create((Object)element, (Object)endOffset);
    }
}

