/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.relations.RelationSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCConditionsList {
    private List<Conditions> myList;

    OCConditionsList(@NotNull List<Conditions> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "<init>"));
        }
        this.myList = list;
    }

    @NotNull
    List<Conditions> getConditions() {
        List<Conditions> list = this.myList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "getConditions"));
        }
        return list;
    }

    public boolean isUnconditional() {
        for (Conditions conditions : this.myList) {
            if (!conditions.myUnconditionalBranch) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OCConditionsList merge(@NotNull OCConditionsList conds) {
        if (conds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conds", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "merge"));
        }
        if (this.isUnconditional() && conds.isUnconditional()) {
            OCConditionsList oCConditionsList = this;
            if (oCConditionsList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "merge"));
            }
            return oCConditionsList;
        }
        OCConditionsList oCConditionsList = new OCConditionsList(ContainerUtil.concat(this.myList, conds.myList));
        if (oCConditionsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "merge"));
        }
        return oCConditionsList;
    }

    @NotNull
    public OCConditionsList skipEvaluation(final @NotNull BranchInfo branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "skipEvaluation"));
        }
        OCConditionsList oCConditionsList = new OCConditionsList(ContainerUtil.map(this.myList, (Function)new Function<Conditions, Conditions>(){

            public Conditions fun(Conditions conditions) {
                return new Conditions(conditions, true, branch);
            }
        }));
        if (oCConditionsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "skipEvaluation"));
        }
        return oCConditionsList;
    }

    @NotNull
    public OCConditionsList combine(@NotNull OCConditionsList conds, @NotNull BranchInfo branch) {
        if (conds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conds", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "combine"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "combine"));
        }
        ArrayList<Conditions> result2 = new ArrayList<Conditions>();
        for (Conditions cond1 : this.myList) {
            for (Conditions cond2 : conds.myList) {
                if (cond1.myUnconditionalBranch) {
                    result2.add(cond2);
                    continue;
                }
                if (cond2.myUnconditionalBranch) {
                    result2.add(cond1);
                    continue;
                }
                result2.add(new Conditions(cond1, cond2));
                Condition lastCondition = (Condition)ContainerUtil.getLastItem(cond2.getConditions());
                if (lastCondition == null) continue;
                lastCondition.myBranches.add(branch);
            }
        }
        OCConditionsList oCConditionsList = new OCConditionsList(result2);
        if (oCConditionsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "combine"));
        }
        return oCConditionsList;
    }

    public void clearBranches() {
        for (Conditions conditions : this.myList) {
            for (Condition condition : conditions.getConditions()) {
                condition.myBranches.clear();
            }
        }
    }

    @NotNull
    public static OCConditionsList singleton(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, Attribute ... attributes) {
        if (relation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relation", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "singleton"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "singleton"));
        }
        OCConditionsList oCConditionsList = new OCConditionsList(Collections.singletonList(new Conditions(branch, fakeNode, relation, attributes)));
        if (oCConditionsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList", "singleton"));
        }
        return oCConditionsList;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static Set<Integer> shiftIndices(@Nullable Set<Integer> indices, final int shift) {
        if (indices == null) {
            return null;
        }
        return ContainerUtil.map2Set(indices, (Function)new Function<Integer, Integer>(){

            public Integer fun(Integer index) {
                return index + shift;
            }
        });
    }

    static class Conditions {
        private List<Condition> myConditions;
        private Set<Integer> mySkipEvaluationIndices;
        private boolean myUnconditionalBranch;

        Conditions(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, Attribute ... attributes) {
            if (relation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relation", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            this.myConditions = Collections.singletonList(new Condition(branch, fakeNode, relation, attributes));
            this.myUnconditionalBranch = attributes.length == 0;
        }

        Conditions(@NotNull Conditions conds1, @NotNull Conditions conds2) {
            if (conds1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conds1", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            if (conds2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conds2", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            this.myConditions = ContainerUtil.concat(conds1.myConditions, conds2.myConditions);
            if (conds1.mySkipEvaluationIndices == null) {
                this.mySkipEvaluationIndices = OCConditionsList.shiftIndices(conds2.mySkipEvaluationIndices, conds1.getConditions().size());
            } else if (conds2.mySkipEvaluationIndices == null) {
                this.mySkipEvaluationIndices = conds1.mySkipEvaluationIndices;
            } else {
                this.mySkipEvaluationIndices = new HashSet<Integer>();
                this.mySkipEvaluationIndices.addAll(conds1.mySkipEvaluationIndices);
                this.mySkipEvaluationIndices.addAll(OCConditionsList.shiftIndices(conds2.mySkipEvaluationIndices, conds1.getConditions().size()));
            }
        }

        Conditions(@NotNull Conditions conds, boolean skipEvaluation, @NotNull BranchInfo branch) {
            if (conds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conds", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "<init>"));
            }
            this.myConditions = conds.myConditions;
            this.myUnconditionalBranch = conds.myUnconditionalBranch;
            this.mySkipEvaluationIndices = skipEvaluation ? new HashSet<Integer>(Collections.singleton(this.myConditions.size())) : null;
            Condition lastCondition = (Condition)ContainerUtil.getLastItem(this.myConditions);
            if (lastCondition != null) {
                lastCondition.myBranches.add(branch);
            }
        }

        @NotNull
        List<Condition> getConditions() {
            List<Condition> list = this.myConditions;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Conditions", "getConditions"));
            }
            return list;
        }

        public Set<Integer> getSkipEvaluationIndices() {
            return this.mySkipEvaluationIndices;
        }
    }

    static class Condition {
        List<BranchInfo> myBranches;
        RelationSignature myRelation;
        Attribute[] myAttributes;
        OCNode myFakeNode;

        Condition(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, @NotNull Attribute[] attributes) {
            if (relation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relation", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Condition", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Condition", "<init>"));
            }
            this.myBranches = new ArrayList<BranchInfo>();
            if (branch != null) {
                this.myBranches.add(branch);
            }
            this.myRelation = relation;
            this.myAttributes = attributes;
            this.myFakeNode = fakeNode;
        }

        @NotNull
        List<BranchInfo> getBranches() {
            List<BranchInfo> list = this.myBranches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Condition", "getBranches"));
            }
            return list;
        }

        @NotNull
        RelationSignature getRelation() {
            RelationSignature relationSignature = this.myRelation;
            if (relationSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Condition", "getRelation"));
            }
            return relationSignature;
        }

        @NotNull
        Attribute[] getAttributes() {
            if (this.myAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCConditionsList$Condition", "getAttributes"));
            }
            return this.myAttributes;
        }

        @Nullable
        OCNode getFakeNode() {
            return this.myFakeNode;
        }
    }

    static class BranchInfo {
        PsiElement myCondition;
        boolean myBranch;
        boolean myCanBeShortCutted;

        BranchInfo(@Nullable PsiElement condition, boolean branch, boolean canBeShortCutted) {
            this.myCondition = condition;
            this.myBranch = branch;
            this.myCanBeShortCutted = canBeShortCutted;
        }

        @Nullable
        PsiElement getCondition() {
            return this.myCondition;
        }

        boolean isTrueBranch() {
            return this.myBranch;
        }

        boolean isCanBeShortCutted() {
            return this.myCanBeShortCutted;
        }
    }
}

