/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotUsedValueChecker
extends OCSingleSymbolAlgorithm {
    private boolean[] myReferenceReachables;
    private boolean mySymbolUsed;
    private boolean mySymbolAssigned;
    private boolean myIgnoreKills;
    private boolean myHandleReferenceReachables;

    public OCNotUsedValueChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "<init>"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "<init>"));
        }
        super(cfg, false, symbol);
        this.myReferenceReachables = new boolean[cfg.getNumOfNodes()];
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        this.myIgnoreKills = true;
        this.myHandleReferenceReachables = false;
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return;
        }
        if (!instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            this.mySymbolUsed = true;
            return;
        }
        for (OCInstruction instruction : instructions.get((Object)OCInstruction.InstructionKind.REFERENCE)) {
            this.traverse(instruction.getNode(), this.mySymbol, null, true);
        }
        this.myIgnoreKills = false;
        System.arraycopy(this.myProcessedNodes, 0, this.myReferenceReachables, 0, this.myCfg.getNumOfNodes());
        super.process();
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "acceptsInstruction"));
        }
        if (this.myIgnoreKills) {
            return true;
        }
        return instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "isStartInstruction"));
        }
        switch (instruction.getKind()) {
            case READ: 
            case READ_IN_BLOCK: 
            case REFERENCE: {
                this.mySymbolUsed = true;
                return true;
            }
            case WRITE: 
            case WRITE_IN_BLOCK: {
                this.mySymbolAssigned = true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "isEndInstruction"));
        }
        return instruction.getKind() == OCInstruction.InstructionKind.WRITE && (!(this.mySymbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)this.mySymbol).isStatic());
    }

    @Override
    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "isNodeProcessed"));
        }
        return this.myHandleReferenceReachables && this.myReferenceReachables[node.getIndex()] || super.isNodeProcessed(node, symbol);
    }

    @NotNull
    public List<PsiElement> getNotUsedWrites() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "getNotUsedWrites"));
            }
            return list;
        }
        this.myHandleReferenceReachables = true;
        List<PsiElement> list = this.getNonReachableElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "getNotUsedWrites"));
        }
        return list;
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotUsedValueChecker", "getElementFromInstruction"));
        }
        return instruction.getLValue();
    }

    public boolean isSymbolUsed() {
        return this.mySymbolUsed;
    }

    public boolean isSymbolAssigned() {
        return this.mySymbolAssigned;
    }
}

