/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedVariablesChecker
extends OCSingleSymbolAlgorithm {
    private Set<Pair<OCInstanceVariableSymbol, PsiElement>> myAssignedIvars;
    private boolean myWasRetained;
    private boolean myStartFromReturns;

    public OCNotReleasedVariablesChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "<init>"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "<init>"));
        }
        super(cfg, false, symbol);
        this.myAssignedIvars = new HashSet<Pair<OCInstanceVariableSymbol, PsiElement>>();
    }

    public void setStartFromReturns(boolean startFromReturns) {
        this.myStartFromReturns = startFromReturns;
    }

    private boolean isAssignmentToOuterScopeVariable(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "isAssignmentToOuterScopeVariable"));
        }
        PsiElement element = instruction.getRValue();
        if (element instanceof OCReferenceExpression && element.getParent() instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignment = (OCAssignmentExpression)element.getParent();
            OCExpression receiver = assignment.getReceiverExpression();
            if (assignment.getSourceExpression() == element) {
                OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver, true);
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(receiver);
                if (ivar != null) {
                    this.myAssignedIvars.add((Pair<OCInstanceVariableSymbol, PsiElement>)new Pair((Object)ivar, (Object)receiver));
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic()) {
                    return true;
                }
            }
        } else if (element instanceof OCReferenceExpression && element.getParent() instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element.getParent();
            OCSymbol symbol = declarator.getSymbol();
            if (declarator.getInitializer() == element && symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "isStartInstruction"));
        }
        if (instruction.getKind() != OCInstruction.InstructionKind.READ && instruction.getKind() != OCInstruction.InstructionKind.READ_IN_BLOCK) {
            return false;
        }
        PsiElement element = instruction.getRValue();
        if (element instanceof OCReferenceExpression && (OCElementUtil.isReleaseCall(element.getParent()) || this.myStartFromReturns && element.getParent() instanceof OCReturnStatement)) {
            return true;
        }
        return this.isAssignmentToOuterScopeVariable(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "isEndInstruction"));
        }
        PsiElement rValue = instruction.getRValue();
        if (instruction.getKind() == OCInstruction.InstructionKind.WRITE) {
            if (OCElementUtil.isRetainCall(rValue, true)) {
                this.myWasRetained = true;
                return true;
            }
            return false;
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement call;
            PsiElement psiElement = call = rValue != null ? rValue.getParent() : null;
            if (call instanceof OCSendMessageExpression && ((OCSendMessageExpression)call).getMessageSelector().equals("retain") && OCNotReleasedVariablesChecker.getLastUnreleasedCall((OCSendMessageExpression)call) != null) {
                this.myWasRetained = true;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getElementFromInstruction"));
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement rValue = instruction.getRValue();
            return rValue != null ? rValue.getParent() : null;
        }
        return super.getElementFromInstruction(instruction);
    }

    @NotNull
    public List<PsiElement> getNotReleasedElements() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getNotReleasedElements"));
            }
            return list;
        }
        this.myWasRetained = false;
        List<PsiElement> result2 = this.getNonReachableElements();
        if (this.myWasRetained) {
            for (Pair<OCInstanceVariableSymbol, PsiElement> pair : this.myAssignedIvars) {
                this.handleAssignedIvar(pair);
            }
        }
        List<PsiElement> list = result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getNotReleasedElements"));
        }
        return list;
    }

    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "handleAssignedIvar"));
        }
    }

    @NotNull
    public static List<Pair<OCSendMessageExpression, PsiElement>> getUnreleasedObjects(@NotNull PsiElement codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getUnreleasedObjects"));
        }
        final ArrayList<Pair<OCSendMessageExpression, PsiElement>> result2 = new ArrayList<Pair<OCSendMessageExpression, PsiElement>>();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                OCSymbol symbol;
                super.visitSendMessageExpression(expression);
                if (!OCElementUtil.isRetainCall(expression, false)) {
                    return;
                }
                List<OCMethodSymbol> responders = expression.getProbableResponders().getAllResponders();
                if (responders.isEmpty()) {
                    return;
                }
                for (OCMethodSymbol responder : responders) {
                    if (responder.getReturnType().resolve(expression.getContainingOCFile()).isPointerToObjectCompatible()) continue;
                    return;
                }
                OCExpression receiver = expression.getReceiverExpression();
                if ("retain".equals(expression.getMessageSelector()) && (receiver instanceof OCReferenceExpression ? (symbol = ((OCReferenceExpression)receiver).resolveToSymbol()) != null && symbol.getKind().isVariable() : OCNotReleasedIvarInspection.getReceiverIvar(receiver) != null)) {
                    return;
                }
                PsiElement call = OCNotReleasedVariablesChecker.getLastUnreleasedCall(expression);
                if (call != null) {
                    if (call.getParent() instanceof OCReturnStatement && OCElementUtil.isRetainMethod((OCCallable)PsiTreeUtil.getParentOfType((PsiElement)call, OCCallable.class))) {
                        return;
                    }
                    result2.add(Pair.create((Object)expression, (Object)call));
                }
            }
        });
        ArrayList<Pair<OCSendMessageExpression, PsiElement>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getUnreleasedObjects"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement getLastUnreleasedCall(@NotNull OCSendMessageExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/dfa/OCNotReleasedVariablesChecker", "getLastUnreleasedCall"));
        }
        PsiElement parent = expression.getParent();
        OCSendMessageExpression kid = expression;
        OCType type = expression.getResolvedType();
        while (parent != null) {
            if (parent instanceof OCParenthesizedExpression || parent instanceof OCCastExpression || parent instanceof OCConditionalExpression) {
                kid = parent;
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof OCAssignmentExpression) {
                OCSymbol symbol;
                OCExpression receiver = ((OCAssignmentExpression)parent).getReceiverExpression();
                if (receiver instanceof OCQualifiedExpression && (symbol = ((OCQualifiedExpression)receiver).resolveToSymbol()) instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).isRetained()) break;
                return null;
            }
            if (parent instanceof OCDeclarator) {
                return null;
            }
            if (parent instanceof OCMessageArgument || !(parent instanceof OCSendMessageExpression)) break;
            OCSendMessageExpression parentCall = (OCSendMessageExpression)parent;
            String selector = parentCall.getMessageSelector();
            if (OCElementUtil.isReleaseSelector(selector)) {
                return null;
            }
            if (OCElementUtil.isRetainCall(parentCall, false) || !parentCall.getResolvedType().isCompatible(type, expression)) break;
            kid = parent;
            parent = parent.getParent();
        }
        return kid;
    }
}

