/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCNotInitializedVarChecker
extends OCSingleSymbolAlgorithm {
    private boolean myWasInitialized;

    protected OCNotInitializedVarChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "<init>"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "<init>"));
        }
        super(cfg, true, symbol);
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        OCControlFlowGraph parentCfg = this.myCfg.getClosureVariableDeclaratorGraph(this.mySymbol);
        if (parentCfg != null) {
            if (this.myCfg.hasInstructionsInParentGraph(this.mySymbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) {
                this.myWasInitialized = true;
                return;
            }
            if (parentCfg.getInstructions(this.mySymbol) != null) {
                this.traverseFromStart(this.mySymbol);
            }
        } else {
            this.traverse(this.myCfg.getDeclaratorInstruction(this.mySymbol), this.mySymbol, true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "acceptsInstruction"));
        }
        switch (instruction.getKind()) {
            case KILL: 
            case WRITE: 
            case WRITE_IN_BLOCK: 
            case REFERENCE: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "isStartInstruction"));
        }
        return instruction.getKind() == OCInstruction.InstructionKind.DECLARATOR;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "isEndInstruction"));
        }
        return instruction.getKind() == OCInstruction.InstructionKind.READ && !instruction.isTransparentRead();
    }

    @Override
    @Nullable
    protected List<OCNode> getJumpTargets(@NotNull OCNode node, boolean isForward) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "getJumpTargets"));
        }
        List<OCNode> jumpTargets = super.getJumpTargets(node, isForward);
        List<OCNode> fakeJumpTargets = node.getFakeJumpTargets();
        if (jumpTargets != null && fakeJumpTargets != null) {
            ArrayList<OCNode> result2 = new ArrayList<OCNode>(jumpTargets);
            result2.removeAll(fakeJumpTargets);
            return result2;
        }
        return jumpTargets;
    }

    @NotNull
    public List<PsiElement> getNotInitializedReads() {
        if (this.myWasInitialized) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "getNotInitializedReads"));
            }
            return list;
        }
        List<PsiElement> list = this.getReachableElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCNotInitializedVarChecker", "getNotInitializedReads"));
        }
        return list;
    }
}

