/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMultiSymbolAlgorithm
extends OCDataFlowAlgorithm {
    private Map<OCSymbol, boolean[]> myVisitedNodes = new HashMap<OCSymbol, boolean[]>();
    private Stack<OCInstruction> myStack = new Stack();
    private Set<OCInstruction> myGoodReads = new HashSet<OCInstruction>();
    private Set<OCSymbol> myReferencedSymbols = new HashSet<OCSymbol>();

    protected OCMultiSymbolAlgorithm(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myStack.addAll(this.getStartInstructions());
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                if (!this.myCfg.hasInstructionsInParentGraph(symbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) continue;
                this.traverseFromStart(symbol);
            }
        }
        while (!this.myStack.isEmpty()) {
            OCInstruction instruction = this.myStack.pop();
            this.traverse(instruction, instruction.getSymbol(), true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "acceptsInstruction"));
        }
        if (this.myReferencedSymbols.contains(instruction.getSymbol())) {
            return true;
        }
        switch (instruction.getKind()) {
            case KILL: {
                return false;
            }
            case WRITE: {
                return this.isStartInstruction(instruction);
            }
        }
        return true;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "isStartInstruction"));
        }
        switch (instruction.getKind()) {
            case REFERENCE: 
            case WRITE_IN_BLOCK: {
                return this.treatReferencesAsStartInstructions();
            }
            case WRITE: {
                break;
            }
            default: {
                return false;
            }
        }
        OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
        if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.READ) {
            return this.isGoodRead(associatedInstruction);
        }
        return this.isGoodWrite(instruction.getRValue());
    }

    protected boolean isGoodRead(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "isGoodRead"));
        }
        return this.myGoodReads.contains(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "isEndInstruction"));
        }
        return instruction.getKind() == OCInstruction.InstructionKind.READ;
    }

    protected boolean treatReferencesAsStartInstructions() {
        return true;
    }

    @Override
    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "processInstruction"));
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.WRITE) {
                this.myGoodReads.add(instruction);
                this.myStack.push(associatedInstruction);
            }
        } else if (instruction.getKind() == OCInstruction.InstructionKind.WRITE_IN_BLOCK || instruction.getKind() == OCInstruction.InstructionKind.REFERENCE) {
            this.myReferencedSymbols.add(instruction.getSymbol());
        }
        return this.acceptsInstruction(instruction);
    }

    protected boolean processClosureSymbols() {
        return true;
    }

    @Override
    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "isNodeProcessed"));
        }
        boolean[] set = symbol != null ? this.myVisitedNodes.get(symbol) : null;
        return set != null && set[node.getIndex()];
    }

    @Override
    protected void markNodeAsProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "markNodeAsProcessed"));
        }
        if (symbol != null) {
            boolean[] set = this.myVisitedNodes.get(symbol);
            if (set == null) {
                set = new boolean[this.myCfg.getNumOfNodes()];
                this.myVisitedNodes.put(symbol, set);
            }
            set[node.getIndex()] = true;
        }
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements(boolean nonReachable) {
        ArrayList<Pair<OCSymbol, PsiElement>> result2 = new ArrayList<Pair<OCSymbol, PsiElement>>();
        for (OCSymbol symbol : this.myCfg.getLocalSymbols()) {
            for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                result2.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
            }
        }
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                    result2.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
                }
            }
        }
        ArrayList<Pair<OCSymbol, PsiElement>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "getReachableElements"));
        }
        return arrayList;
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements() {
        List<Pair<OCSymbol, PsiElement>> list = this.getReachableElements(false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm", "getReachableElements"));
        }
        return list;
    }

    protected abstract boolean isGoodWrite(@Nullable PsiElement var1);
}

