/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInstruction {
    private final InstructionKind myKind;
    private final OCNode myNode;
    @Nullable
    private OCInstruction myAssociatedInstruction;
    @NotNull
    private final OCSymbol mySymbol;
    private final PsiElement myLValue;
    private final PsiElement myRValue;
    private boolean myTransparentRead;

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @NotNull OCSymbol symbol) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        this(kind, node, lValue, null, symbol);
    }

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @NotNull OCSymbol symbol) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/dfa/OCInstruction", "<init>"));
        }
        this.myKind = kind;
        this.myNode = node;
        this.myLValue = lValue;
        this.mySymbol = symbol;
        this.myRValue = rValue;
    }

    @Nullable
    public PsiElement getLValue() {
        return this.myLValue;
    }

    @Nullable
    public PsiElement getRValue() {
        return this.myRValue;
    }

    @NotNull
    public InstructionKind getKind() {
        InstructionKind instructionKind = this.myKind;
        if (instructionKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCInstruction", "getKind"));
        }
        return instructionKind;
    }

    @NotNull
    public OCNode getNode() {
        OCNode oCNode = this.myNode;
        if (oCNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCInstruction", "getNode"));
        }
        return oCNode;
    }

    @NotNull
    public OCSymbol getSymbol() {
        OCSymbol oCSymbol = this.mySymbol;
        if (oCSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/dfa/OCInstruction", "getSymbol"));
        }
        return oCSymbol;
    }

    public long getSymbolOffset() {
        long offset = this.mySymbol.getComplexOffset();
        return offset != 0L ? offset : (long)this.mySymbol.hashCode();
    }

    public void setAssociatedInstruction(@Nullable OCInstruction associatedInstruction) {
        this.myAssociatedInstruction = associatedInstruction;
    }

    @Nullable
    public OCInstruction getAssociatedInstruction() {
        return this.myAssociatedInstruction;
    }

    public boolean isTransparentRead() {
        return this.myTransparentRead;
    }

    public void setTransparentRead(boolean transparentRead) {
        this.myTransparentRead = transparentRead;
    }

    public static enum InstructionKind {
        DECLARATOR,
        READ,
        WRITE,
        KILL,
        REFERENCE,
        READ_IN_BLOCK,
        WRITE_IN_BLOCK;

    }
}

