/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPragmaSuppressionUtils {
    public static final String CLANG = "clang";
    public static final String CIDR_IDE = "ide";
    private static NotNullLazyKey<CachedValue<ScopesStack>, OCFile> CACHE = NotNullLazyKey.create((String)"OCPragmaSuppressionUtils", (NotNullFunction)new NotNullFunction<OCFile, CachedValue<ScopesStack>>(){

        @NotNull
        public CachedValue<ScopesStack> fun(final OCFile file2) {
            CachedValue cachedValue = CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<ScopesStack>(){

                @Nullable
                public CachedValueProvider.Result<ScopesStack> compute() {
                    final ScopesStack stack = new ScopesStack();
                    final Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)file2);
                    file2.accept(new OCRecursiveVisitor(){

                        @Override
                        public void visitPragma(OCPragma pragma) {
                            stack.processPragma(pragma, document);
                        }
                    });
                    while (!stack.myStack.isEmpty()) {
                        stack.pop(new TextRange(file2.getTextLength(), file2.getTextLength()));
                    }
                    return CachedValueProvider.Result.create((Object)stack, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
            if (cachedValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils$1", "fun"));
            }
            return cachedValue;
        }
    });

    @Nullable
    public static Pair<Mode, String> parsePragma(@Nullable String pragmaText) {
        if (pragmaText == null) {
            return null;
        }
        OCLexer contentLexer = new OCLexer();
        contentLexer.start(pragmaText);
        ArrayList<String> tokens = new ArrayList<String>();
        while (true) {
            IElementType tokenType;
            if ((tokenType = contentLexer.getTokenType()) == OCTokenTypes.IDENTIFIER || tokenType == OCTokenTypes.STRING_LITERAL) {
                tokens.add(contentLexer.getTokenText());
            } else if (tokenType == null) break;
            contentLexer.advance();
        }
        if (tokens.size() >= 3 && (CLANG.equals(tokens.get(0)) || CIDR_IDE.equals(tokens.get(0))) && "diagnostic".equals(tokens.get(1))) {
            if ("push".equals(tokens.get(2))) {
                return new Pair((Object)Mode.PUSH, null);
            }
            if ("pop".equals(tokens.get(2))) {
                return new Pair((Object)Mode.POP, null);
            }
            if (tokens.size() >= 4 && StringUtil.isQuotedString((String)((String)tokens.get(3)))) {
                String warning = StringUtil.unquoteString((String)((String)tokens.get(3)));
                if ("ignored".equals(tokens.get(2))) {
                    return Pair.create((Object)((Object)Mode.IGNORE), (Object)warning);
                }
                if ("warning".equals(tokens.get(2))) {
                    return Pair.create((Object)((Object)Mode.WARNING), (Object)warning);
                }
                if ("error".equals(tokens.get(2))) {
                    return Pair.create((Object)((Object)Mode.ERROR), (Object)warning);
                }
                if ("fatal".equals(tokens.get(2))) {
                    return Pair.create((Object)((Object)Mode.FATAL), (Object)warning);
                }
            }
        }
        return null;
    }

    @Nullable
    public static Mode getDiagnosticMode(OCFile file2, int offset, @Nullable String suppressOption) {
        if (suppressOption == null) {
            return null;
        }
        Scope scope = OCPragmaSuppressionUtils.findScope(file2, offset);
        Mode curMode = null;
        for (Pair pair : scope.settings.get((Object)suppressOption)) {
            if (((TextRange)pair.first).getEndOffset() > offset) break;
            curMode = (Mode)((Object)pair.second);
        }
        return curMode;
    }

    @NotNull
    private static Scope findScope(@NotNull Scope scope, int offset) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils", "findScope"));
        }
        for (Scope child : scope.children) {
            if (child.push.getStartOffset() > offset || child.pop == null || offset >= child.pop.getEndOffset()) continue;
            Scope scope2 = OCPragmaSuppressionUtils.findScope(child, offset);
            if (scope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils", "findScope"));
            }
            return scope2;
        }
        Scope scope3 = scope;
        if (scope3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils", "findScope"));
        }
        return scope3;
    }

    @NotNull
    public static Scope findScope(OCFile file2, int offset) {
        Scope scope = OCPragmaSuppressionUtils.findScope(((ScopesStack)((CachedValue)CACHE.getValue((UserDataHolder)file2)).getValue()).myRootScope, offset);
        if (scope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils", "findScope"));
        }
        return scope;
    }

    @Nullable
    public static Scope findExactScope(OCFile file2, int startOffset, int endOffset) {
        Scope scope;
        Pair<Mode, String> pair;
        PsiElement leaf;
        int pushOffset = -1;
        int popOffset = -1;
        PsiElement psiElement = leaf = startOffset > 0 ? file2.findElementAt(startOffset - 1) : null;
        while (leaf != null && OCPragmaSuppressionUtils.isPartOfTheScope(leaf)) {
            pair = OCPragmaSuppressionUtils.parsePragmaFromHead(leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf));
            if (pair == null || pair.first != Mode.PUSH) continue;
            pushOffset = OCElementUtil.getRangeWithMacros(leaf).getStartOffset();
            break;
        }
        PsiElement psiElement2 = leaf = endOffset < file2.getTextLength() ? file2.findElementAt(endOffset) : null;
        while (leaf != null && OCPragmaSuppressionUtils.isPartOfTheScope(leaf)) {
            pair = OCPragmaSuppressionUtils.parsePragmaFromHead(leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf));
            if (pair == null || pair.first != Mode.POP) continue;
            popOffset = OCElementUtil.getRangeWithMacros(leaf).getStartOffset();
            break;
        }
        if (pushOffset != -1 && popOffset != -1 ? (scope = OCPragmaSuppressionUtils.findScope(file2, pushOffset)).push != null && scope.pop != null && scope.push.getStartOffset() == pushOffset && scope.pop.getStartOffset() == popOffset : (scope = OCPragmaSuppressionUtils.findScope(file2, file2.getTextLength() - 1)).push != null && scope.pop != null && scope.push.getStartOffset() == startOffset && scope.pop.getEndOffset() == endOffset) {
            return scope;
        }
        return null;
    }

    private static Pair<Mode, String> parsePragmaFromHead(@Nullable PsiElement leaf) {
        String text = null;
        OCPragma pragma = OCElementUtil.getPragmaAt(leaf);
        if (pragma != null && leaf == pragma.getHeaderToken()) {
            text = pragma.getContent();
        }
        return OCPragmaSuppressionUtils.parsePragma(text);
    }

    private static boolean isPartOfTheScope(@NotNull PsiElement leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaf", "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils", "isPartOfTheScope"));
        }
        return OCElementUtil.isWhitespace(leaf) || OCElementUtil.getPragmaAt(leaf) != null;
    }

    private static class ScopesStack {
        private Stack<Scope> myStack = new Stack();
        private Scope myCurScope = this.myRootScope = new Scope();
        private Scope myRootScope;

        private ScopesStack() {
        }

        private void processPragma(OCPragma pragma, Document document) {
            String pragmaText = pragma.getContent();
            Pair<Mode, String> pair = OCPragmaSuppressionUtils.parsePragma(pragmaText);
            if (pair != null) {
                int line;
                TextRange range = OCElementUtil.getRangeWithMacros(pragma);
                if (document != null && (line = document.getLineNumber(range.getEndOffset())) < document.getLineCount() - 1) {
                    range = new TextRange(range.getStartOffset(), document.getLineStartOffset(line + 1));
                }
                switch ((Mode)((Object)pair.first)) {
                    case PUSH: {
                        this.push(range);
                        break;
                    }
                    case POP: {
                        this.pop(range);
                        break;
                    }
                    case IGNORE: 
                    case WARNING: 
                    case ERROR: 
                    case FATAL: {
                        this.myCurScope.settings.putValue(pair.getSecond(), (Object)Pair.create((Object)range, (Object)pair.getFirst()));
                        this.myCurScope.ownSettingsCnt++;
                    }
                }
            }
        }

        private void push(TextRange range) {
            Scope newScope = new Scope();
            newScope.settings = new MultiMap();
            newScope.settings.putAllValues(this.myCurScope.settings);
            newScope.push = range;
            this.myStack.push(this.myCurScope);
            this.myCurScope.children.add(newScope);
            this.myCurScope = newScope;
        }

        private void pop(TextRange range) {
            if (!this.myStack.isEmpty()) {
                this.myCurScope.pop = range;
                this.myCurScope = this.myStack.pop();
            }
        }
    }

    public static class Scope {
        private MultiMap<String, Pair<TextRange, Mode>> settings = new MultiMap();
        private int ownSettingsCnt;
        private TextRange push;
        private TextRange pop;
        private List<Scope> children = new ArrayList<Scope>();

        public boolean isTopLevel() {
            return this.pop == null;
        }

        public TextRange getPush() {
            return this.push;
        }

        public TextRange getPop() {
            return this.pop;
        }

        public MultiMap<String, Pair<TextRange, Mode>> getSettings() {
            return this.settings;
        }

        public int getOwnSettingsCnt() {
            return this.ownSettingsCnt;
        }
    }

    public static enum Mode {
        IGNORE,
        WARNING,
        ERROR,
        FATAL,
        PUSH,
        POP;

    }
}

