/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclarePropertyInPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeFunctionSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateMissingSwitchCasesFix;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCExtractAssignmentIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCNonStaticOperatorType;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCFormatSpecifiersUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOperatorsChecker
extends OCAnnotator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBinaryOperatorApplicable(OCExpression lOperand, OCExpression rOperand, OCElementType operator, OCExpression element) {
        boolean intAndPtr;
        boolean rPointerCompatible;
        OCType rType;
        if (lOperand == null || rOperand == null || operator == null || element == null) {
            return;
        }
        if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains((IElementType)operator) && !this.checkAssignable(lOperand)) {
            return;
        }
        OCType lType = lOperand.getResolvedType().getGuessedType();
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType(element);
        }
        if ((rType = rOperand.getResolvedType().getGuessedType()) instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType(element);
        }
        OCFile containingFile = element.getContainingOCFile();
        if (lType.isUnknown() || rType.isUnknown() || lType.isSubclassOfMagic(element) || rType.isSubclassOfMagic(element)) {
            return;
        }
        if (operator == OCTokenTypes.EQ) {
            OCSymbol symbol2;
            OCMethod oCMethod;
            PsiElement parent = element.getParent();
            if (OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(element), element) && !(parent instanceof OCParenthesizedExpression) && !(parent instanceof OCAssignmentExpression) && !(parent instanceof OCDeclarator)) {
                void var9_12;
                Class<OCInspections.EqualityInConditionalOperator> clazz = OCInspections.EqualityInConditionalOperator.class;
                String message = "Using '=' in conditional expression";
                if ("self".equals(lOperand.getText())) {
                    Class<OCInspections.EqualityInConditionalOperatorWithSelf> clazz2 = OCInspections.EqualityInConditionalOperatorWithSelf.class;
                    message = message + " with \"self\"";
                }
                Annotation annotation = this.addWarningAnnotation(element, (Class<? extends OCInspection>)var9_12, "warn_condition_is_assignment", message);
                String text = element.getTextWithMacros();
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(containingFile, element.getTextOffset(), text.length(), '(' + text + ')', "Place parentheses around"));
                this.registerQuickFix(annotation, new OCExtractAssignmentIntentionAction(element, lOperand));
            }
            if (lOperand instanceof OCReferenceExpression && ((OCReferenceExpression)lOperand).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF && (oCMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)element, OCMethod.class)) != null && OCElementUtil.startsWithWord(oCMethod.getSelector(), "init") && rType.isCompatible(lType, lOperand)) {
                return;
            }
            OCLValueVisitor oCLValueVisitor = new OCLValueVisitor();
            lOperand.accept(oCLValueVisitor);
            OCType symbolRequiredType = OCPointerType.to(rType.transformType(OCArrayToPointerChanger.INSTANCE), oCLValueVisitor.getNumOfDereferences());
            this.checkAssignment(rOperand, (PsiElement)element, lType, rType, oCLValueVisitor.getSymbol(), symbolRequiredType);
            if (!(lOperand instanceof OCReferenceExpression) || !(rOperand instanceof OCReferenceExpression)) return;
            OCReferenceElement refElement1 = ((OCReferenceExpression)lOperand).getReferenceElement();
            OCReferenceElement refElement2 = ((OCReferenceExpression)rOperand).getReferenceElement();
            OCSymbol symbol1 = refElement1 != null ? refElement1.resolveToSymbol() : null;
            OCSymbol oCSymbol = symbol2 = refElement2 != null ? refElement2.resolveToSymbol() : null;
            if (symbol1 == null || symbol2 == null || !symbol1.equals(symbol2)) return;
            String message = symbol1.getNameWithKindUppercase() + " is assigned to itself";
            this.addWarningAnnotation(element, OCInspections.UnusedValue.class, "warn_self_assignment", message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            return;
        }
        boolean lIntegerCompatible = lType.isIntegerCompatible(element);
        boolean bl = rType.isIntegerCompatible(element);
        OCResolveContext context = new OCResolveContext(lOperand);
        boolean lPointerCompatible = lType.isPointerCompatible(element) || OCExpressionEvaluator.getPointerType(lOperand, context) != null;
        boolean bl2 = rPointerCompatible = rType.isPointerCompatible(element) || OCExpressionEvaluator.getPointerType(rOperand, context) != null;
        if ((OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)operator) || OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator)) && !OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator) && lType.isNumberCompatible(element) && rType.isNumberCompatible(element)) {
            return;
        }
        if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator) && lType.isScalarOrConvertibleToScalar(element) && rType.isScalarOrConvertibleToScalar(element)) {
            return;
        }
        if ((OCTokenTypes.BITLOGIC_OPERATIONS.contains((IElementType)operator) || OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator)) && lIntegerCompatible && bl) {
            return;
        }
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator) && lType instanceof OCStructType && ((OCStructType)lType).isEnumClass() && rType.equals((Object)lType, element)) {
            return;
        }
        String message = null;
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator) && lPointerCompatible && rPointerCompatible) {
            if (lIntegerCompatible || bl) {
                message = "Comparison between pointer and integer";
            } else {
                if (!(lType instanceof OCPointerType) || !(rType instanceof OCPointerType)) return;
                message = "Comparison between distinct pointer types";
            }
        } else if (operator == OCTokenTypes.EQEQ || operator == OCTokenTypes.EXCLEQ) {
            if (lType instanceof OCStructType && !lType.isScalarOrConvertibleToScalar(element) || rType instanceof OCStructType && !rType.isScalarOrConvertibleToScalar(element)) {
                this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Can't compare structures");
                return;
            }
            message = "Types '" + lType.getName(lOperand) + "' and '" + rType.getName(rOperand) + "' are not compatible";
        }
        if (message != null) {
            this.checkTypesEquivalence(lType, rType, lOperand, rOperand, element, message);
            return;
        }
        boolean ptrAndInt = lPointerCompatible && bl;
        boolean bl3 = intAndPtr = lIntegerCompatible && rPointerCompatible;
        if (operator == OCTokenTypes.PLUS && (ptrAndInt || intAndPtr) || operator == OCTokenTypes.MINUS && lType instanceof OCPointerType && rType instanceof OCPointerType && new OCTypeEqualityAfterResolvingVisitor(((OCPointerType)rType).getRefType(), false, false, true, true, true, element.getContainingFile()).equal(((OCPointerType)lType).getRefType()) || (operator == OCTokenTypes.MINUS || operator == OCTokenTypes.PLUSEQ || operator == OCTokenTypes.MINUSEQ) && ptrAndInt) {
            if (!OCCompilerHelper.isArcEnabled(containingFile) || !lType.isPointerToObjectCompatible() && !rType.isPointerToObjectCompatible()) return;
            this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            return;
        }
        if (operator == OCTokenTypes.DOT_MUL && lType instanceof OCStructType || operator == OCTokenTypes.DEREF_MUL && lType instanceof OCPointerType && rType.isPointer() && (((OCPointerType)lType).getRefType() instanceof OCStructType || ((OCPointerType)lType).getRefType() instanceof OCMagicType)) {
            return;
        }
        this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Binary operator '" + operator.getName() + "' can't be applied to the expressions of type '" + lType.getName(lOperand) + "' and '" + rType.getName(rOperand) + "'");
    }

    protected void checkTypesEquivalence(OCType lType, OCType rType, OCExpression lOperand, OCExpression rOperand, OCExpression element, String message) {
        if (lType instanceof OCArrayType) {
            lType = OCPointerType.to(((OCArrayType)lType).getRefType(), ((OCArrayType)lType).getARCAttribute());
        }
        if (rType instanceof OCArrayType) {
            rType = OCPointerType.to(((OCArrayType)rType).getRefType(), ((OCArrayType)rType).getARCAttribute());
        }
        if (!rType.isCompatible(lType, lOperand, element)) {
            this.checkAssignment(rOperand, element, lType, rType, message);
        }
    }

    public void checkUnaryOperatorApplicable(OCExpression operand, OCElementType operator, PsiElement element) {
        if (operand == null || operator == null || element == null) {
            return;
        }
        OCFile containingFile = operand.getContainingOCFile();
        OCType type = operand.getResolvedType();
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (operator == OCTokenTypes.MUL) {
            if (type.isSubclassOfMagic(operand)) {
                return;
            }
            if (type instanceof OCPointerType) {
                OCType refType = ((OCPointerType)type).getRefType();
                if (refType.isUnknown() && !(refType instanceof OCMagicType)) {
                    this.addErrorAnnotation(operand, OCInspections.CannotResolve.class, "err_incomplete_type", "Dereferencing pointer to unknown type");
                } else if (refType instanceof OCVoidType) {
                    this.addErrorAnnotation(element, "CIDR", "Dereferencing 'void *' pointer");
                }
            } else if (!type.isUnknown()) {
                this.addErrorAnnotation(element, OCInspections.PointerTypeRequired.class, "err_typecheck_indirection_requires_pointer", "Pointer type is required");
            }
            return;
        }
        if (type.isUnknown()) {
            return;
        }
        if (operator == OCTokenTypes.PLUSPLUS || operator == OCTokenTypes.MINUSMINUS) {
            if (!this.checkAssignable(operand)) {
                return;
            }
            if (OCCompilerHelper.isArcEnabled(containingFile) && type.isPointerToObjectCompatible()) {
                this.addErrorAnnotation(operand, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            } else if (!type.isNumberCompatible(element) && !(type instanceof OCPointerType)) {
                this.addErrorAnnotation(operand, OCInspections.IntegerTypeRequired.class, "err_typecheck_illegal_increment_decrement", "Expression of type '" + type.getName(operand) + "' is neither numeric nor a pointer");
            }
            return;
        }
        if (operator == OCTokenTypes.PLUS || operator == OCTokenTypes.MINUS) {
            if (!type.isNumberCompatible(element)) {
                this.addErrorAnnotation(operand, OCInspections.IntegerTypeRequired.class, "err_typecheck_unary_expr", "Expression of type '" + type.getName(operand) + "' is not numeric");
            }
            return;
        }
        if (operator == OCTokenTypes.AND) {
            if (!OCLValueVisitor.isLvalue(operand)) {
                this.addErrorAnnotation(operand, OCInspections.NotAssignable.class, "err_typecheck_invalid_lvalue_addrof", "Address expression must be lvalue");
            }
            return;
        }
        if (operator == OCTokenTypes.EXCL && type.isScalarOrConvertibleToScalar(operand)) {
            return;
        }
        if (operator == OCTokenTypes.TILDE && type.isIntegerCompatible(element)) {
            return;
        }
        if ((operator == OCTokenTypes.__IMAG__KEYWORD || operator == OCTokenTypes.__REAL__KEYWORD) && type instanceof OCRealType) {
            return;
        }
        String message = "Unary operator '" + operator.getName() + "' can't be applied to the expression of type '" + type.getName(operand) + "'";
        this.addErrorAnnotation(element, "err_typecheck_unary_expr", message);
    }

    public void checkCastExperssion(OCCastExpression expression) {
        OCType lType = expression.getCastType().resolve(expression.getContainingFile());
        OCExpression operand = expression.getOperand();
        if (operand == null) {
            OCArgumentList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            if (argumentList.getArguments().size() == 1) {
                operand = argumentList.getArguments().get(0);
            } else {
                this.myCppChecker.checkTypeInitialization(expression, expression.getTypeElement(), argumentList.getArguments(), argumentList.getArgumentTypes(new OCResolveContext(expression)), null, lType, true, expression);
                return;
            }
        }
        PsiElement bridgeCastModifier = expression.getBridgeCastModifier();
        OCType rType = operand.getResolvedType().getGuessedType();
        if (bridgeCastModifier != null) {
            boolean rIsCFPtr;
            OCElementType bridgeType = (OCElementType)OCElementUtil.getElementType(bridgeCastModifier);
            String bridgeTypeName = bridgeType.getName();
            String rTypeName = rType.getName(operand);
            boolean lIsObjectPtr = lType.isPointerToObjectCompatible();
            boolean lIsCFPtr = !lIsObjectPtr && lType instanceof OCPointerType;
            boolean rIsObjectPtr = rType.isPointerToObjectCompatible();
            boolean bl = rIsCFPtr = !rIsObjectPtr && rType instanceof OCPointerType;
            if (bridgeType == OCTokenTypes.BRIDGE_RETAINED_KEYWORD) {
                if (!lIsCFPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type");
                }
                if (!rIsObjectPtr) {
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_TRANSFER_KEYWORD) {
                if (!lIsObjectPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type");
                }
                if (!rIsCFPtr) {
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_KEYWORD) {
                if (!lIsObjectPtr && !lIsCFPtr) {
                    this.addErrorAnnotation(expression.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object or CF pointer type");
                }
                if (!(lIsCFPtr && rIsObjectPtr || lIsObjectPtr && rIsCFPtr)) {
                    String message = bridgeTypeName + " requires " + (lIsObjectPtr ? "CF" : "object") + " pointer type instead of '" + rTypeName + "'";
                    this.addErrorAnnotation(expression.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", message);
                }
            }
            return;
        }
        this.checkTypeCast(lType, rType, expression.getTypeElement(), operand, expression);
    }

    public void checkTypeCast(OCType lType, OCType rType, PsiElement typeElement, OCExpression operand, PsiElement expression) {
        OCObjectType rObjectType;
        OCObjectType lObjectType;
        String rTypeName = rType.getName(expression);
        String lTypeName = lType.getName(expression);
        if (!this.checkARCPointerTypes(lType, typeElement, null)) {
            return;
        }
        OCType.TypeCheckResult typeCheckResult = lType.checkCompatible(rType, operand, expression);
        if (!typeCheckResult.canBeCasted(lType, rType, expression) || typeCheckResult.getInspectionClass() == OCInspections.BridgeCastIssues.class) {
            String message = "Expression of type '" + rTypeName + "' can't be cast to type '" + lTypeName + "': " + typeCheckResult.getMessage();
            Annotation annotation = this.addErrorAnnotation(typeElement, typeCheckResult.getInspectionClass(), "err_typecheck_expect_scalar_operand", message);
            this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(operand, lType));
            IntentionAction[] quickFixes = typeCheckResult.getQuickFixes();
            if (quickFixes != null) {
                for (IntentionAction fix : quickFixes) {
                    this.registerQuickFix(annotation, fix);
                }
            }
            return;
        }
        if (lType.isPointerToObject() && rType.isPointerToObject() && !(lObjectType = (OCObjectType)lType.getTerminalType()).isAncestorOf(rObjectType = (OCObjectType)rType.getTerminalType()) && !rObjectType.isAncestorOf(lObjectType)) {
            String message = "Casting expression of type '" + rTypeName + "' to incompatible type '" + lTypeName + "'";
            this.addWarningAnnotation(typeElement, OCInspections.IncompatiblePointers.class, "CIDRobjc_incompatible_pointers", message);
            return;
        }
        if (lType.getAliasName() == null && rType.getAliasName() == null && !(operand instanceof OCLiteralExpression)) {
            String message;
            rType = operand.getResolvedType();
            if (!(!rType.isPointerToID() || lType.isPointerToID() && ((OCObjectType)lType.getTerminalType()).getAllProtocols().isEmpty())) {
                return;
            }
            Annotation annotation = null;
            if (!(!lType.isPointerToObject() || lType.isPointerToID() || typeCheckResult.getState() != OCType.TypeCheckState.OK || rType instanceof OCPointerType && ((OCPointerType)rType).getRefType() instanceof OCVoidType)) {
                message = "Casting expression of type '" + rTypeName + "' to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            } else if (lType.equals(rType, false, new OCResolveContext(operand))) {
                message = "Casting expression to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (annotation != null) {
                OCExpression oldElement = OCParenthesesUtils.topmostParenthesized((OCExpression)expression);
                OCExpression newElement = OCParenthesesUtils.diveIntoParentheses(operand);
                this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)oldElement, (PsiElement)newElement, "Remove redundant cast"));
            }
        }
    }

    public boolean checkARCPointerTypes(@Nullable OCType lType, @Nullable PsiElement element, @Nullable OCSymbol symbol) {
        if (element == null || !OCCompilerHelper.isArcEnabled(element.getContainingFile())) {
            return true;
        }
        if (lType instanceof OCPointerType && lType.getTerminalType() instanceof OCObjectType) {
            OCPointerType pointerType = (OCPointerType)lType;
            int numOfExtraRefs = 0;
            boolean wasNotArray = false;
            while (pointerType.getRefType() instanceof OCPointerType && ((OCPointerType)pointerType.getRefType()).getRefType() instanceof OCPointerType) {
                if (!(pointerType instanceof OCArrayType)) {
                    wasNotArray = true;
                }
                pointerType = (OCPointerType)pointerType.getRefType();
                ++numOfExtraRefs;
            }
            if (!(pointerType instanceof OCArrayType && !wasNotArray || !(pointerType.getRefType() instanceof OCPointerType) || pointerType.isPointerToConst() || ((OCPointerType)pointerType.getRefType()).getARCAttribute() != null || symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER)) {
                Annotation annotation = this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arc_indirect_no_ownership", "Pointer to non-const type '" + lType.getName(element) + "' with no explicit lifetime");
                if (symbol != null) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, OCPointerType.to((OCType)OCPointerType.to(pointerType.getRefType().cloneWithConstModifier(element.getProject()), null), numOfExtraRefs)));
                    for (ARCAttribute attribute : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute));
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean checkAssignable(@Nullable OCExpression expression) {
        OCType operandType;
        if (expression == null) {
            return true;
        }
        OCType resolvedType = expression.getResolvedType();
        if ((expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression)) == null) {
            return true;
        }
        if (resolvedType instanceof OCMagicType) {
            return false;
        }
        if (expression instanceof OCConditionalExpression && expression.getContainingOCFile().isCpp()) {
            return this.checkAssignable(((OCConditionalExpression)expression).getPositiveExpression(true)) && this.checkAssignable(((OCConditionalExpression)expression).getNegativeExpression());
        }
        OCLValueVisitor visitor = new OCLValueVisitor();
        expression.accept(visitor);
        final OCSymbol symbol = visitor.getSymbol();
        if (symbol != null && symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD && expression instanceof OCQualifiedExpression && !((OCDeclaratorSymbol)symbol).isMutable()) {
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)expression;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            if (qualifiedExpression.getQualifyingTokenKind() == OCTokenTypes.DOT) {
                if (!this.checkAssignable(qualifier)) {
                    return false;
                }
            } else {
                OCType qualifierType = qualifier.getResolvedType();
                if (qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).isPointerToConst() && (!(qualifier instanceof OCReferenceExpression) || !((OCReferenceExpression)qualifier).isCppThis())) {
                    this.addErrorAnnotation(qualifier, OCInspections.NotAssignable.class, "CIDR", "Expression is not assignable");
                    return false;
                }
            }
        }
        boolean isAssignable = false;
        List<Object> quickfixes = null;
        String message = "Expression is not assignable";
        if (visitor.getNumOfDereferences() > 0) {
            isAssignable = true;
        } else if (symbol instanceof OCPropertySymbol) {
            OCClassSymbol classSymbol;
            isAssignable = !((OCPropertySymbol)symbol).isReadonly();
            quickfixes = new ArrayList<Object>(2);
            quickfixes.add(new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)symbol, OCPropertySymbol.PropertyAttribute.READONLY, null, null));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && ((OCClassSymbol)((OCPropertySymbol)symbol).getParent()).equals(classSymbol.getInterface())) {
                quickfixes.add(new OCDeclarePropertyInPrivateCategoryIntentionAction(){

                    @Override
                    protected OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$1", "locateCandidate"));
                        }
                        return (OCPropertySymbol)symbol;
                    }
                });
            }
        } else if (symbol instanceof OCMethodSymbol) {
            isAssignable = OCNameSuggester.isObjCSetter(symbol.getName());
            if (!this.checkReadonlyAccess(Collections.singletonList(expression), (OCMethodSymbol)symbol, "Calling")) {
                return false;
            }
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            isAssignable = true;
        } else if (symbol instanceof OCFunctionSymbol) {
            OCType returnType = symbol.getEffectiveResolvedType();
            if (returnType.isUnknown() || returnType instanceof OCCppReferenceType) {
                isAssignable = true;
            } else if (returnType instanceof OCStructType) {
                OCFunctionSymbol assignment = OCNonStaticOperatorType.resolveAssignmentOperator(expression, (OCStructType)returnType, null);
                isAssignable = assignment != null;
            }
        } else if (symbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
            Ref functionSymbol = new Ref();
            isAssignable = true;
            if (resolvedType instanceof OCArrayType && ((OCArrayType)resolvedType).hasLength()) {
                isAssignable = false;
                message = "Array is not assignable";
            }
            if (isAssignable) {
                if (declaratorSymbol.getKind() == OCSymbolKind.TYPEDEF) {
                    isAssignable = false;
                } else if (resolvedType.isConst() || declaratorSymbol.isConstexpr() || declaratorSymbol.getKind() == OCSymbolKind.ENUM_CONST) {
                    isAssignable = false;
                    message = "Variable is declared constant and is not assignable";
                    OCElementType keyword = declaratorSymbol.isConstexpr() ? OCTokenTypes.CONSTEXPR_CPP_KEYWORD : OCTokenTypes.CONST_KEYWORD;
                    quickfixes = Collections.singletonList(new OCRemoveTypeModifierIntentionAction(declaratorSymbol, keyword));
                } else if (resolvedType instanceof OCCppReferenceType && ((OCCppReferenceType)resolvedType).isReferenceToConst()) {
                    isAssignable = false;
                    message = "'" + resolvedType.getName(expression) + "' is read-only reference";
                    OCCppReferenceType type = OCCppReferenceType.to(((OCCppReferenceType)resolvedType).getRefType().cloneWithoutConstModifier(expression.getProject()));
                    quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, type));
                } else if (declaratorSymbol.getKind().isLocal() && !declaratorSymbol.isBlockModifiable() && !declaratorSymbol.isStatic()) {
                    TextRange textRange;
                    OCBlockExpression block = (OCBlockExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCBlockExpression.class});
                    if (!(block == null || (textRange = declaratorSymbol.getScope()) != null && block.getTextRange().contains(textRange))) {
                        isAssignable = false;
                        message = "Variable is declared outside the block and is not assignable";
                        quickfixes = Collections.singletonList(new OCAddTypeModifierIntentionAction(declaratorSymbol, OCTokenTypes.BLOCK_KEYWORD));
                    }
                } else {
                    CVQualifiers cvQualifiers = OCCodeInsightUtil.getOuterFunctionCVQualifiers(declaratorSymbol, expression, (Ref<OCFunctionSymbol>)functionSymbol);
                    if (cvQualifiers != null && cvQualifiers.isConst()) {
                        isAssignable = false;
                        message = declaratorSymbol.getNameWithKindUppercase() + " is assigned inside a const function";
                        quickfixes = Collections.singletonList(this.changeFunctionConstQuickFix((OCFunctionSymbol)functionSymbol.get(), false));
                    }
                }
            }
        } else if (resolvedType instanceof OCStructType) {
            isAssignable = !resolvedType.isConst() && OCNonStaticOperatorType.resolveAssignmentOperator(expression, (OCStructType)resolvedType, null) != null;
        } else if (visitor.wasUnresolvedSymbol()) {
            isAssignable = true;
        }
        OCExpression operand = null;
        if (expression instanceof OCUnaryExpression && ((OCUnaryExpression)expression).getOperationSign() == OCTokenTypes.MUL) {
            operand = ((OCUnaryExpression)expression).getOperand();
        } else if (expression instanceof OCArraySelectionExpression) {
            operand = ((OCArraySelectionExpression)expression).getArrayExpression();
        }
        if (operand != null && (operandType = operand.getResolvedType()) instanceof OCPointerType && ((OCPointerType)operandType).isPointerToConst()) {
            isAssignable = false;
            message = "'" + operandType.getName(operand) + "' is read-only pointer";
            if (symbol != null && !(operandType instanceof OCArrayType)) {
                boolean isConst = operandType.isConst();
                OCType oCType = OCPointerType.to(((OCPointerType)operandType).getRefType().cloneWithoutConstModifier(expression.getProject()), visitor.getNumOfDereferences() - 1);
                OCPointerType newType = OCPointerType.to(oCType.cloneWithoutConstModifier(expression.getProject()), null, null, isConst, oCType.isVolatile());
                quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, newType));
            }
        }
        if (!isAssignable) {
            Annotation annotation = this.addErrorAnnotation(expression, OCInspections.NotAssignable.class, "CIDR", message);
            if (quickfixes != null) {
                for (IntentionAction intentionAction : quickfixes) {
                    this.registerQuickFix(annotation, intentionAction);
                }
            }
        }
        return isAssignable;
    }

    @NotNull
    public OCChangeTypeIntentionAction changeFunctionConstQuickFix(final @NotNull OCFunctionSymbol functionSymbol, final boolean isConst) {
        if (functionSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionSymbol", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker", "changeFunctionConstQuickFix"));
        }
        OCFunctionType oldType = functionSymbol.getType();
        OCFunctionType newType = new OCFunctionType(oldType.getReturnType().cloneWithoutConstModifier(functionSymbol.getProject()), oldType.getParameterTypes(true), oldType.getParameterNames(true), isConst, oldType.isVolatile());
        OCChangeTypeIntentionAction oCChangeTypeIntentionAction = new OCChangeTypeIntentionAction(functionSymbol, newType){

            @Override
            protected String getTextInternal() {
                return "Make " + functionSymbol.getNameWithKindLowercase() + (isConst ? " const" : " non-const");
            }

            @Override
            @NotNull
            public String getFamilyName() {
                if ("Change const qualifier" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$2", "getFamilyName"));
                }
                return "Change const qualifier";
            }
        };
        if (oCChangeTypeIntentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker", "changeFunctionConstQuickFix"));
        }
        return oCChangeTypeIntentionAction;
    }

    @NotNull
    public OCChangeTypeIntentionAction changeFunctionVolatileQuickFix(final @NotNull OCFunctionSymbol functionSymbol, final boolean isVolatile) {
        if (functionSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionSymbol", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker", "changeFunctionVolatileQuickFix"));
        }
        OCFunctionType oldType = functionSymbol.getType();
        OCFunctionType newType = new OCFunctionType(oldType.getReturnType().cloneWithCVQualifiers(new CVQualifiers(oldType.getReturnType().isConst(), false), functionSymbol.getProject()), oldType.getParameterTypes(true), oldType.getParameterNames(true), oldType.isConst(), isVolatile);
        OCChangeTypeIntentionAction oCChangeTypeIntentionAction = new OCChangeTypeIntentionAction(functionSymbol, newType){

            @Override
            protected String getTextInternal() {
                return "Make " + functionSymbol.getNameWithKindLowercase() + (isVolatile ? " volatile" : " non-volatile");
            }

            @Override
            @NotNull
            public String getFamilyName() {
                if ("Change volatile qualifier" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$3", "getFamilyName"));
                }
                return "Change volatile qualifier";
            }
        };
        if (oCChangeTypeIntentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker", "changeFunctionVolatileQuickFix"));
        }
        return oCChangeTypeIntentionAction;
    }

    public boolean checkReadonlyAccess(List<? extends PsiElement> elements, OCMethodSymbol symbol, String accessKind) {
        String getter;
        OCClassSymbol parent = ((OCClassSymbol)symbol.getParent()).getInterfaceOrProtocol();
        if (parent == null) {
            return true;
        }
        CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
        if (symbol.isSetter() && (getter = OCNameSuggester.getObjCGetterFromSetter(symbol.getName())) != null) {
            parent.processMembers(getter, OCPropertySymbol.class, propFinder);
        }
        if (propFinder.isFound() && ((OCPropertySymbol)propFinder.getFoundValue()).isReadonly()) {
            OCClassSymbol classSymbol;
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elements.get(0), (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && parent.equals(classSymbol.getInterface())) {
                return true;
            }
            String message = accessKind + " the setter method for readonly " + ((OCPropertySymbol)propFinder.getFoundValue()).getNameWithKindLowercase();
            List<Annotation> annotations = this.addWarningAnnotations(elements, OCInspections.SetterForReadonlyProperty.class, "CIDR", message);
            this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)propFinder.getFoundValue(), OCPropertySymbol.PropertyAttribute.READONLY, null, null));
            return false;
        }
        return true;
    }

    public void checkCallExpression(OCCallExpression expr) {
        OCExpression function = OCParenthesesUtils.diveIntoParentheses(expr.getFunctionReferenceExpression());
        if (function == null) {
            return;
        }
        OCType funcType = function.getResolvedType();
        if (funcType instanceof OCCppReferenceType) {
            funcType = ((OCCppReferenceType)funcType).getRefType();
        }
        if (expr.getContainingOCFile().isCpp()) {
            if (function instanceof OCReferenceExpression) {
                OCSymbol symbol = ((OCReferenceExpression)function).resolveToSymbol();
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() || symbol instanceof OCStructSymbol) {
                    this.myCppChecker.checkConstructorCall(expr, expr.getArguments(), symbol, true);
                    return;
                }
                if (symbol != null && symbol.getKind().isType()) {
                    OCType type = symbol.getType().resolve(expr.getContainingOCFile());
                    this.myCppChecker.checkTypeInitialization(expr, function, expr.getArguments(), expr.getArgumentTypes(new OCResolveContext(expr)), symbol, type, true, expr);
                    return;
                }
            }
            if (expr.getReference() instanceof OCOperatorReference) {
                for (OCSymbol symbol : ((OCOperatorReference)expr.getReference()).resolveToSymbols()) {
                    if (!(symbol instanceof OCFunctionSymbol)) continue;
                    this.myOperatorsChecker.checkFieldVisibility(symbol, expr, null);
                    funcType = symbol.getResolvedType();
                    break;
                }
                if (funcType.isSubclassOfMagic(expr)) {
                    return;
                }
            }
            if (function instanceof OCQualifiedExpression && ((OCQualifiedExpression)function).getName().startsWith("~") && expr.getArguments().isEmpty()) {
                return;
            }
        }
        if (funcType instanceof OCPointerType) {
            funcType = ((OCPointerType)funcType).getRefType();
        }
        if (funcType.isUnknown()) {
            return;
        }
        if (!(funcType instanceof OCFunctionType)) {
            this.addErrorAnnotation(function, "err_typecheck_call_not_function", "Called object is not a function");
            return;
        }
        OCLValueVisitor visitor = new OCLValueVisitor();
        function.accept(visitor);
        OCSymbol functionSymbol = visitor.getSymbol();
        if (functionSymbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
            functionSymbol = (OCSymbol)ContainerUtil.getFirstItem(((OCResolveOverloadsUtil.OCFunctionGroupSymbol)functionSymbol).getOverloads());
        }
        this.checkFunctionArguments(expr, (OCFunctionType)funcType, expr.getArguments(), functionSymbol);
        if (expr.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)functionSymbol).getResolvedOwner() instanceof OCStructSymbol && !((OCFunctionSymbol)functionSymbol).isCppNonMemberOperator(new OCResolveContext(expr))) {
            this.checkConstFunction(function, (OCFunctionSymbol)functionSymbol);
        }
    }

    boolean checkFunctionArguments(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol) {
        return new OCAnnotator.MyArgumentsChecker(){

            @Override
            protected void addFunctionCallQuickFixes(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol, List<OCType> argumentTypes, List<Annotation> annotations) {
                if (functionSymbol != null) {
                    OCOperatorsChecker.this.checkFormatSpecifiers(functionSymbol, arguments, argumentTypes);
                    argumentTypes = ContainerUtil.map(arguments, (Function)new Function<OCExpression, OCType>(){

                        public OCType fun(OCExpression expression) {
                            return OCExpectedTypeUtil.getExpressionType(expression, true);
                        }
                    });
                    OCFunctionType newFunctionType = new OCFunctionType(funcType.getReturnType(), argumentTypes);
                    OCOperatorsChecker.this.registerQuickFixes(annotations, new OCChangeFunctionSignatureIntentionAction(functionSymbol, newFunctionType));
                    if (element.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol) {
                        OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)functionSymbol).getResolvedOwner();
                        boolean isStatic = ((OCFunctionSymbol)functionSymbol).resolveIsStatic();
                        OCElement usage = element instanceof OCCallExpression ? ((OCCallExpression)element).getFunctionReferenceExpression() : element;
                        OCOperatorsChecker.this.registerQuickFixes(annotations, new OCCreateNewDefinitionIntentionAction(functionSymbol.getKind().toDeclarationKind(), usage, null, parent, functionSymbol.getName(), newFunctionType, isStatic));
                    }
                }
            }
        }.checkFunctionArguments(element, funcType, arguments, functionSymbol);
    }

    protected void checkConstFunction(OCExpression function, OCFunctionSymbol symbol) {
        CVQualifiers cvQualifiers = null;
        OCQuickFix extraConstFix = null;
        OCQuickFix extraVolatileFix = null;
        if (function instanceof OCQualifiedExpression) {
            OCSymbol qualifierSymbol;
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)function;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            OCPunctuatorElementType qualifyingTokenKind = qualifiedExpression.getQualifyingTokenKind();
            cvQualifiers = qualifiedExpression.getCVQualifiers();
            if (cvQualifiers.isConst() && qualifyingTokenKind == OCTokenTypes.DOT && (qualifierSymbol = OCLValueVisitor.getSymbol(qualifier)) instanceof OCSymbolWithQualifiedName) {
                extraConstFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.CONST_KEYWORD);
                extraVolatileFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.VOLATILE_KEYWORD);
            }
        } else if (function instanceof OCReferenceExpression) {
            OCFunctionSymbol containingFunSymbol;
            OCFunctionDefinition containingFunction = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)function, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol oCFunctionSymbol = containingFunSymbol = containingFunction != null ? containingFunction.getSymbol() : null;
            if (containingFunSymbol != null) {
                cvQualifiers = containingFunSymbol.getType().getCVQualifiers();
                extraConstFix = this.changeFunctionConstQuickFix(containingFunSymbol, false);
                extraVolatileFix = this.changeFunctionVolatileQuickFix(containingFunSymbol, false);
            }
        }
        if (!symbol.isCppConstructor() && !symbol.resolveIsStatic()) {
            this.checkCVMismatch(function, symbol, cvQualifiers, true, "const", extraConstFix);
            this.checkCVMismatch(function, symbol, cvQualifiers, false, "volatile", extraVolatileFix);
        }
    }

    private void checkCVMismatch(OCExpression function, OCFunctionSymbol symbol, CVQualifiers cvQualifiers, boolean isConstModifier, String modifierName, IntentionAction extraFix) {
        if (cvQualifiers != null && (isConstModifier && cvQualifiers.isConst() && !symbol.isConst() || !isConstModifier && cvQualifiers.isVolatile() && !symbol.getType().isVolatile())) {
            String message = "Non-" + modifierName + " " + symbol.getNameWithKindLowercase() + " is called " + (function instanceof OCReferenceExpression ? "from the " + modifierName + " function" : "on the " + modifierName + " object");
            Annotation annotation = this.addErrorAnnotation(function, OCInspections.ConstExpressionRequired.class, "err_member_function_call_bad_cvr", message);
            this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(symbol.getDeclarationInParent(), OCTokenTypes.STATIC_KEYWORD, false));
            if (isConstModifier) {
                this.registerQuickFix(annotation, this.changeFunctionConstQuickFix(symbol, true));
            } else {
                this.registerQuickFix(annotation, this.changeFunctionVolatileQuickFix(symbol, true));
            }
            if (extraFix != null) {
                this.registerQuickFix(annotation, extraFix);
            }
        }
    }

    public void checkMacroCall(OCMacroCall macroCall) {
        int expectedCount;
        if (macroCall.getTextLength() == 0) {
            return;
        }
        OCMacroSymbol symbol = macroCall.resolveToSymbol();
        if (symbol == null || !symbol.hasParameterList()) {
            return;
        }
        OCMacroCall.ParameterCheckResult result2 = macroCall.checkParameters(symbol);
        int actualCount = result2.getActualCount();
        if (actualCount < (expectedCount = result2.getAllowedCount())) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_few_args_in_macro_invoc", "Too few arguments for a macro call, expected " + (symbol.isVararg() ? "at least " : "") + expectedCount);
        } else if (actualCount > expectedCount) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_many_args_in_macro_invoc", "Too many arguments for a macro call, expected " + expectedCount);
        }
    }

    private void checkFormatSpecifiers(OCSymbol callable, List<OCExpression> arguments, List<OCType> argumentTypes) {
        Pair<OCFormatSpecifiersUtil.FormatSpecifiersInfo, List<OCFormatSpecifiersUtil.SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null) {
            return;
        }
        List formatStringSpecifiers = (List)formatInfo.second;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifierRange == null) continue;
            this.highlight(specifierRange, specifier.getType());
        }
        OCFormatSpecifiersUtil.FormatSpecifiersInfo formatSpecifiersInfo = (OCFormatSpecifiersUtil.FormatSpecifiersInfo)formatInfo.first;
        if (!formatSpecifiersInfo.formatType.needArgumentsCheck() || formatSpecifiersInfo.argumentsIndex < 0 || formatSpecifiersInfo.formatStringIndex < 0) {
            return;
        }
        OCExpression formatStringArgument = arguments.get(formatSpecifiersInfo.formatStringIndex);
        int argIndex = formatSpecifiersInfo.argumentsIndex;
        boolean skipNext = false;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (specifier.getType() == OCHighlightingKeys.OC_INVALID_STRING_ESCAPE) {
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_incomplete_specifier", "Unknown, incomplete or optional format specifier", null);
                ++argIndex;
                continue;
            }
            String existingSpecifierName = specifier.getName();
            if (formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.SCANF && existingSpecifierName.equals("*")) {
                skipNext = true;
                continue;
            }
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (argIndex >= arguments.size()) {
                PsiFile file2 = callable.getContainingPsiFile();
                OCType expectedType = formatSpecifiersInfo.formatType.resolveType(existingSpecifierName, (PsiElement)file2);
                String expectedArgType = expectedType == null ? "" : expectedType.getName((PsiElement)file2);
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_data_arg_not_used", "Argument missing: format specifier '" + existingSpecifierName + "' requires '" + expectedArgType + "' argument", null);
                continue;
            }
            OCExpression argument = arguments.get(argIndex);
            OCType argType = argumentTypes.get(argIndex);
            OCFormatSpecifiersUtil.FormatType formatType = formatSpecifiersInfo.formatType;
            String actualArgumentSpecifierName = formatType.getSpecifierForType(argType);
            OCType expectedType = formatType.resolveType(existingSpecifierName, argument);
            if (actualArgumentSpecifierName != null && expectedType != null && !formatType.isCompatible(expectedType, argType, existingSpecifierName, actualArgumentSpecifierName, argument)) {
                String message = "Format specifier '" + existingSpecifierName + "' requires '" + expectedType.getName(argument) + "' argument instead of '" + argType.getName(argument) + "'";
                if (!actualArgumentSpecifierName.equals("<pointer type required>") && specifierRange != null) {
                    Annotation formatAnnotation = this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message, null);
                    this.registerQuickFix(formatAnnotation, new OCChangeTextIntentionAction(argument.getContainingFile(), specifierRange.getStartOffset(), specifierRange.getLength(), actualArgumentSpecifierName, "Change format specifier to '" + actualArgumentSpecifierName + "'", "Change format specifier"));
                }
                Annotation argAnnotation = this.addWarningAnnotation(argument, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message);
                if (!existingSpecifierName.equals("%@")) {
                    if (formatType != OCFormatSpecifiersUtil.FormatType.SCANF) {
                        this.registerQuickFix(argAnnotation, new OCInsertCastIntentionAction(argument, expectedType));
                    }
                    if (!expectedType.isPointer()) {
                        this.registerQuickFix(argAnnotation, OCChangeTypeIntentionAction.getAction(argument, expectedType));
                    }
                }
                this.registerQuickFix(argAnnotation, new OCConvertTypeIntentionAction(argument, expectedType));
                this.registerQuickFix(argAnnotation, new OCConvertLiteralIntentionAction(argument, expectedType, argType));
            }
            ++argIndex;
        }
        if (argIndex < arguments.size()) {
            OCExpression argument = arguments.get(argIndex);
            OCExpression argumentLast = arguments.get(arguments.size() - 1);
            int requiredVarargs = argIndex - formatSpecifiersInfo.argumentsIndex;
            int hasVarargs = arguments.size() - formatSpecifiersInfo.argumentsIndex;
            Annotation annotation = this.addWarningAnnotation(argument.getParent(), new OCElementsRange(argument, argumentLast).getTextRange(), OCInspections.FormatSpecifiers.class, "warn_printf_insufficient_data_args", "Too many arguments: format string requires " + requiredVarargs + ", but has " + hasVarargs + StringUtil.pluralize((String)" argument", (int)hasVarargs), null);
            String intentionName = "Remove" + StringUtil.pluralize((String)" argument", (int)(hasVarargs - requiredVarargs));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(arguments.subList(argIndex, arguments.size()), intentionName, intentionName));
        }
    }

    public void checkSendMessageExpression(OCSendMessageExpression expr) {
        OCSendMessageExpression.ProbableResponders responders = expr.getProbableResponders();
        OCExpression receiver = expr.getReceiverExpression();
        if (expr.getArguments().size() == 0) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_message_selector_missing", "Message selector expected");
            return;
        }
        if (responders.isStaticnessMismatch()) {
            String message = responders.isStaticContext() ? "Instance method is called from the class context" : "Class method is called from the instance context";
            Annotation annotation = this.addErrorAnnotation(expr, OCInspections.StaticnessMismatch.class, "CIDR", message);
            if (responders.getAllResponders().size() == 1) {
                OCMethodSymbol responder = responders.getAllResponders().get(0);
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(responder, responders.isStaticContext()));
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (receiver instanceof OCReferenceExpression && containingMethod != null && ((OCReferenceExpression)receiver).getSelfSuperToken() != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)containingMethod.getSymbol(), !responders.isStaticContext()));
                }
            }
            return;
        }
        OCMethodSymbol knownResponder = responders.getKnownResponder();
        if (knownResponder != null && expr.isVarargCall() && !knownResponder.isVararg()) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_not_vararg_method", knownResponder.getNameWithKindUppercase() + " is not a vararg method");
            return;
        }
        String messageSelector = expr.getMessageSelector();
        OCMethodSymbol target = OCOperatorsChecker.findTargetMethod(expr, responders.getFilteredByStaticnessResponders());
        if (responders.getKnownResponder() == null) {
            for (OCMethodSymbol responder : responders.getAllResponders()) {
                OCFileSymbols.markSymbolAsUsed(expr.getContainingOCFile(), responder, expr);
            }
        }
        if (target == null) {
            return;
        }
        this.checkResponderIsKnown(expr, responders, target);
        this.checkSendMessageArguments(expr, target);
        if (!OCCompilerHelper.isArcEnabled(expr.getContainingFile())) {
            Annotation annotation;
            if (messageSelector.equals("dealloc")) {
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (containingMethod != null && containingMethod.getSelector().equals("dealloc") && receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER) {
                    return;
                }
                annotation = this.addWarningAnnotation(expr, OCInspections.CallDealloc.class, "CIDR", "Sending 'dealloc' directly");
                int selectorOffset = expr.getArgumentSelectors().get(0).getTextOffset();
                String message = "Send \"release\" message instead of \"dealloc\"";
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(expr.getContainingFile(), selectorOffset, "dealloc".length(), "release", message));
            } else if (OCElementUtil.isReleaseSelector(messageSelector)) {
                OCSymbol receiverSymbol = null;
                if (receiver instanceof OCReferenceExpression) {
                    receiverSymbol = ((OCReferenceExpression)receiver).resolveToSymbol();
                } else if (receiver instanceof OCQualifiedExpression) {
                    receiverSymbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
                }
                if (receiverSymbol instanceof OCInstanceVariableSymbol) {
                    receiverSymbol = ((OCInstanceVariableSymbol)receiverSymbol).getAssociatedProperty();
                }
                if (receiverSymbol instanceof OCPropertySymbol && !((OCPropertySymbol)receiverSymbol).isReadonly() && ((OCPropertySymbol)receiverSymbol).getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, receiverSymbol.getResolvedType(), expr) == OCPropertySymbol.PropertyAttribute.ASSIGN) {
                    annotation = this.addWarningAnnotation(expr, OCInspections.ReleasingOfAssignProperties.class, "CIDR", "Releasing of the property with 'assign' attribute");
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.RETAIN, null));
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.COPY, null));
                }
            }
        }
        this.checkReadonlyAccess(expr.getArgumentSelectors(), target, "Calling");
    }

    private void checkSendMessageArguments(OCSendMessageExpression expr, OCMethodSymbol target) {
        List<OCMessageArgument> arguments = expr.getArguments();
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        boolean requiresNil = OCType.isFunctionRequiringNil(target);
        int argPos = 0;
        for (OCMessageArgument arg : arguments) {
            OCExpression argument = arg.getArgumentExpression();
            if (argument == null) continue;
            OCType argumentType = argument.getResolvedType().getGuessedType();
            argumentTypes.add(argumentType);
            if (target.isVararg() && argPos >= target.getSelectors().size()) {
                if (argumentType.isVoid()) {
                    this.addErrorAnnotation(argument, "CIDR", "Invalid use of void expression");
                    continue;
                }
                if (!requiresNil || !expr.getMessageSelector().contains("Objects") || argumentType.isPointerToObjectCompatible()) continue;
                this.checkAssignment(argument, argument, OCIdType.pointerToID(argument.getProject()), argumentType, null, argumentType, true, "Parameter type mismatch: ");
                continue;
            }
            OCDeclaratorSymbol parameter = target.getSelectors().get(argPos++).getParameter();
            if (parameter == null) continue;
            OCType declType = parameter.getType().resolve(expr.getContainingFile());
            this.checkAssignment(argument, (PsiElement)argument, declType, argumentType, (OCSymbol)parameter, "Parameter type mismatch: ");
        }
        this.checkFormatSpecifiers(target, expr.getArgumentExpressions(), argumentTypes);
        if (requiresNil && arguments.size() > 0) {
            String text;
            OCMessageArgument lastArgument = arguments.get(arguments.size() - 1);
            OCExpression expression = lastArgument.getArgumentExpression();
            String string = text = expression != null ? expression.getTextWithMacros() : null;
            if (!OCCodeInsightUtil.isLikeNull(text)) {
                Annotation annotation = this.addWarningAnnotation(lastArgument, OCInspections.LastArgumentMustBeNull.class, "CIDR", "Last argument must be \"nil\"");
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(lastArgument.getContainingOCFile(), lastArgument.getTextRange().getEndOffset(), 0, ", nil", "Append \"nil\" argument"));
            }
        }
    }

    private void checkResponderIsKnown(OCSendMessageExpression expr, OCSendMessageExpression.ProbableResponders responders, final OCMethodSymbol target) {
        OCInterfaceSymbol receiverClass;
        OCFile file2 = expr.getContainingOCFile();
        OCExpression receiver = expr.getReceiverExpression();
        OCFileSymbols.markSymbolAsUsed(file2, target, expr);
        OCObjectType receiverType = responders.getReceiverType();
        OCType receiverOriginalType = responders.getReceiverOriginalType();
        OCInterfaceSymbol oCInterfaceSymbol = receiverClass = receiverType != null ? receiverType.getInterface() : null;
        if (receiverClass != null && !receiverClass.isPredeclaration()) {
            OCFileSymbols.markImportNeeded(file2, receiverClass);
        }
        if (responders.getKnownResponder() != null) {
            return;
        }
        if (receiverClass != null && receiverClass.isPredeclaration()) {
            String message = receiverClass.getNameWithKindUppercase() + " definition is not visible";
            Annotation annotation = this.addErrorAnnotation(receiver, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, receiverClass.getDefinitionSymbol()));
        } else if (receiverType instanceof OCIdType || receiverOriginalType != null && receiverOriginalType.isClassType()) {
            if (!OCFileSymbols.isSymbolImported(file2, target.getParent())) {
                Annotation annotation = this.addErrorAnnotation(expr, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", target.getNameWithKindUppercase() + " is not visible");
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, (OCSymbol)target.getParent()));
            }
        } else {
            OCClassSymbol containingClassSymbol;
            boolean isSameClassName = receiverClass != null && receiverClass.getName().equals(((OCClassSymbol)target.getParent()).getName());
            String message = receiverClass != null && !isSameClassName && ((OCClassSymbol)target.getParent()).isSubclass(receiverClass) ? target.getNameWithKindUppercase() + " is defined in subclass '" + ((OCClassSymbol)target.getParent()).getPresentableName() + "'" : target.getNameWithKindUppercase() + " is defined in class '" + ((OCClassSymbol)target.getParent()).getPresentableName() + "' and is not visible";
            Annotation annotation = OCCompilerHelper.isArcEnabled(file2) ? this.addErrorAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message) : this.addWarningAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver, (OCSymbol)target.getParent()));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            OCClassSymbol oCClassSymbol = containingClassSymbol = containingClass != null ? containingClass.getSymbol() : null;
            if (receiverClass != null) {
                this.registerQuickFix(annotation, new OCDeclareMethodInInterfaceIntentionAction(){

                    @Override
                    @NotNull
                    public String getText() {
                        String string = "Declare method in " + receiverClass.getNameWithKindLowercase();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "getText"));
                        }
                        return string;
                    }

                    @Override
                    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "getParent"));
                        }
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "getParent"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "getParent"));
                        }
                        return receiverClass;
                    }

                    @Override
                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "isAvailable"));
                        }
                        return OCSearchScope.isInProjectSources(target);
                    }

                    @Override
                    protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$5", "locateCandidate"));
                        }
                        return target;
                    }
                });
                if (receiver != null && !isSameClassName) {
                    OCPointerType targetType = OCPointerType.to(((OCClassSymbol)target.getParent()).getType().resolve(file2));
                    this.registerQuickFix(annotation, new OCInsertCastIntentionAction(receiver, targetType));
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(receiver, targetType));
                    this.registerQuickFix(annotation, new OCConvertTypeIntentionAction(receiver, targetType));
                    this.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(receiver, targetType, receiverType));
                }
            }
            if (receiverClass != null && containingClassSymbol != null && receiverClass.getImplementation() == containingClassSymbol) {
                this.registerQuickFix(annotation, new OCDeclareMethodInPrivateCategoryIntentionAction(){

                    @Override
                    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$6", "getParent"));
                        }
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$6", "getParent"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$6", "getParent"));
                        }
                        return receiverClass;
                    }

                    @Override
                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$6", "isAvailable"));
                        }
                        return OCSearchScope.isInProjectSources(target);
                    }

                    @Override
                    protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCOperatorsChecker$6", "locateCandidate"));
                        }
                        return target;
                    }
                });
            }
        }
    }

    public void checkForeach(OCForeachStatement statement) {
        OCSymbol varSymbol;
        OCElement varElement;
        OCType lType;
        OCDeclaration varDecl;
        OCElement varExprElement = statement.getVariableExpression();
        OCExpression varExpr = varExprElement instanceof OCExpressionStatement ? ((OCExpressionStatement)varExprElement).getExpression() : (OCExpression)varExprElement;
        OCExpression collExpr = statement.getCollectionExpression();
        OCElement varDeclElement = statement.getVariableDeclaration();
        OCDeclaration oCDeclaration = varDecl = varDeclElement instanceof OCDeclarationStatement ? ((OCDeclarationStatement)varDeclElement).getDeclaration() : (OCDeclaration)varDeclElement;
        if (varExpr != null) {
            if (!this.checkAssignable(varExpr)) {
                return;
            }
            lType = varExpr.getResolvedType();
            varElement = varExprElement;
            varSymbol = OCLValueVisitor.getSymbol(varExpr);
            if (!(statement.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                this.addErrorAnnotation(varExpr, "CIDR", "Expression has non-object type '" + lType.getName(varExpr) + "'");
            }
        } else if (varDecl != null) {
            varElement = varDecl;
            if (varDecl.getDeclarators().size() != 1) {
                Annotation annotation = this.addErrorAnnotation(varDecl, "err_toomany_element_decls", "Only one variable declarator is allowed");
                for (int i = varDecl.getDeclarators().size() - 1; i >= 1; --i) {
                    this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)varDecl.getDeclarators().get(i), "Remove extra declarators"));
                }
                return;
            }
            OCDeclarator declarator = varDecl.getDeclarators().get(0);
            varSymbol = declarator.getSymbol();
            lType = declarator.getResolvedType();
            if (declarator.getInitializer() != null) {
                this.addErrorAnnotation(declarator.getInitializer(), OCInspections.InitializerIssues.class, "CIDR", "Initializer is not allowed here");
            } else if (!(statement.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                this.addErrorAnnotation(declarator, "err_selector_element_type", "Variable has non-object type '" + lType.getName(varExpr) + "'");
            }
        } else {
            return;
        }
        if (collExpr == null) {
            return;
        }
        OCType rType = collExpr.getResolvedType().getGuessedType();
        if (rType.isUnknown()) {
            return;
        }
        if (statement.isCpp11Foreach()) {
            OCType elementType = OCCodeInsightUtil.getCollectionElementType(collExpr, rType);
            if (elementType != null) {
                this.checkAssignment(null, (PsiElement)varElement, lType, elementType, varSymbol, "");
            } else {
                this.addErrorAnnotation(collExpr, OCInspections.ArrayIssues.class, "err_for_range_invalid", "'" + rType.getBestNameInContext(collExpr) + "' is not a valid range type");
            }
        } else if (rType.isPointerToObjectCompatible()) {
            OCType refType = ((OCPointerType)rType).getRefType();
            if (!(refType instanceof OCObjectType)) {
                return;
            }
            OCObjectType objectType = (OCObjectType)refType;
            String enumFunction = "countByEnumeratingWithState:objects:count:";
            if (!(objectType instanceof OCIdType && objectType.getAllProtocols().isEmpty() || objectType.findMember("countByEnumeratingWithState:objects:count:", OCMethodSymbol.class) != null)) {
                String message = "Collection expression of type '" + rType.getName(collExpr) + "' doesn't respond to '" + "countByEnumeratingWithState:objects:count:" + "'";
                Annotation annotation = this.addWarningAnnotation(collExpr, OCInspections.UnresolvedCollectionMessage.class, "warn_collection_expr_type", message);
                if (objectType.getInterface() != null) {
                    this.registerQuickFix(annotation, new OCAddSuperProtocolIntentionAction(objectType.getInterface(), "NSFastEnumeration", false));
                }
            }
        } else {
            this.addErrorAnnotation(collExpr, "CIDR", "Expression has non-object type '" + rType.getName(collExpr) + "'");
        }
    }

    @Nullable
    public static OCMethodSymbol findTargetMethod(OCSendMessageExpression expr, List<OCMethodSymbol> targets) {
        List<OCMessageArgument> arguments = expr.getArguments();
        OCMethodSymbol best = null;
        int minValue = 0;
        block0: for (OCMethodSymbol target : targets) {
            int argPos = 0;
            int value = 0;
            for (OCMessageArgument arg : arguments) {
                OCDeclaratorSymbol parameter;
                OCExpression argument = arg.getArgumentExpression();
                if (argument == null) continue;
                OCType argumentType = argument.getResolvedType().getGuessedType();
                List<OCMethodSymbol.SelectorPartSymbol> parameters = target.getSelectors();
                if (target.isVararg()) {
                    if (argPos >= parameters.size()) {
                        continue;
                    }
                } else if (parameters.size() != arguments.size()) continue block0;
                if ((parameter = parameters.get(argPos).getParameter()) == null) continue;
                OCType declType = parameter.getType().resolve(expr.getContainingFile());
                OCType.TypeCheckState state = declType.checkCompatible(argumentType, argument, argument).getState();
                if (state.isError(expr)) {
                    value += 2000;
                } else if (state != OCType.TypeCheckState.OK) {
                    ++value;
                }
                ++argPos;
            }
            if (!OCFileSymbols.isSymbolImported(expr.getContainingOCFile(), target.getParent())) {
                value += 1000;
            }
            if (best != null && (value == -1 || value >= minValue)) continue;
            minValue = value;
            best = target;
        }
        return best;
    }

    public void checkQualifiedExpression(OCQualifiedExpression expression) {
        OCType type = expression.getQualifier().getResolvedType();
        if (type.isUnknown()) {
            return;
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCFile file2 = expression.getContainingOCFile();
        if (expression.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            Ref isSynthetic = new Ref((Object)false);
            OCType derefType = expression.getQualifierContainerType((Ref<Boolean>)isSynthetic);
            if (derefType == OCUnknownType.INSTANCE && ((Boolean)isSynthetic.get()).booleanValue()) {
                String message = "Applying '->' operator to '" + type.getName(expression) + "' instead of a pointer";
                Annotation annotation = this.addErrorAnnotation(expression.getQualifier(), OCInspections.PointerTypeRequired.class, "err_typecheck_member_reference_arrow", message);
                if (type instanceof OCStructType || type instanceof OCObjectType) {
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression.getQualifier(), OCPointerType.to(type)));
                }
                return;
            }
            Ref qualifierType = new Ref();
            expression.processTargets(expression.getName(), (Processor<OCSymbol>)new CommonProcessors.CollectProcessor(), true, null, false, false, (Ref<OCType>)qualifierType);
            OCType oCType = type = qualifierType.isNull() ? derefType : (OCType)qualifierType.get();
        }
        if (!(type.isUnknown() || type instanceof OCStructType || type.isClassType() || type instanceof OCObjectType || expression.getQualifyingTokenKind() == OCTokenTypes.DOT && type.isPointerToObject())) {
            this.addErrorAnnotation(expression.getQualifier(), "err_typecheck_member_reference_struct_union", "Structure type required instead of '" + type.getName(expression) + "'");
            return;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        expression.processTargets(expression.getName(), (Processor<OCSymbol>)finder, false, null, true, false, null);
        OCSymbol symbol = (OCSymbol)finder.getFoundValue();
        if (symbol == null) {
            expression.processTargets(expression.getName(), (Processor<OCSymbol>)finder, true, null, true, false, null);
            symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null) {
                OCFileSymbols.markSymbolAsUsed(file2, symbol, expression);
                boolean isStatic = symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isStatic();
                String message = isStatic ? "Class " + symbol.getNameWithKindLowercase() + " is accessed from the instance context" : "Instance " + symbol.getNameWithKindLowercase() + " is accessed from the class context";
                Annotation annotation = this.addErrorAnnotation(expression, OCInspections.StaticnessMismatch.class, "CIDR", message);
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCMethod.class});
                OCExpression qualifier = expression.getQualifier();
                if (symbol instanceof OCMethodSymbol) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)symbol, !isStatic));
                }
                if (containingMethod != null && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)containingMethod.getSymbol(), isStatic));
                }
            }
        } else {
            OCFileSymbols.markSymbolAsUsed(file2, symbol, expression);
            this.checkFieldVisibility(symbol, expression, type);
        }
    }

    public boolean checkFieldVisibility(OCSymbol field, PsiElement element, @Nullable OCType qualifierType) {
        String subjectName;
        if (!(field instanceof OCSymbolWithQualifiedName) && !(field instanceof OCInstanceVariableSymbol)) {
            return true;
        }
        OCSymbolWithParent symbol = (OCSymbolWithParent)field;
        OCVisibility declaredVisibility = OCVisibility.getDeclaredVisibility(symbol);
        String string = subjectName = symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false) : symbol.getNameWithParent();
        if (field instanceof OCFunctionSymbol && ((OCFunctionSymbol)field).isDelete()) {
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_ovl_deleted_member_call", "'" + subjectName + "' is deleted");
            Object funElement = symbol.locateDefinition();
            if (funElement instanceof OCDeclarator) {
                ASTNode deleteKeyword = (ASTNode)ContainerUtil.find((Object[])funElement.getNode().getChildren(null), (Condition)new Condition<ASTNode>(){

                    public boolean value(ASTNode node) {
                        return node.getElementType() == OCTokenTypes.DELETE_CPP_KEYWORD;
                    }
                });
                if (deleteKeyword != null) {
                    this.registerQuickFix(annotation, new OCChangeTextIntentionAction(deleteKeyword.getPsi().getContainingFile(), deleteKeyword.getStartOffset(), deleteKeyword.getTextLength(), "default", "Make " + field.getNameWithKindLowercase() + " default"));
                }
                this.registerQuickFix(annotation, new OCSafeDeleteIntentionAction((PsiElement)funElement, field.getNameWithKindLowercase() + " declaration"));
            }
            return false;
        }
        if (declaredVisibility == null) {
            return true;
        }
        OCVisibility visibility = OCVisibility.getVisibility(symbol, element, qualifierType);
        if (visibility.ordinal() >= declaredVisibility.ordinal()) {
            return true;
        }
        Annotation annotation = this.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_access", (Object)((Object)declaredVisibility) + " '" + subjectName + "' is inaccessible");
        if (visibility.ordinal() >= OCVisibility.PUBLIC.ordinal()) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PUBLIC));
        }
        if (symbol instanceof OCInstanceVariableSymbol) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PACKAGE));
        }
        if (visibility.ordinal() >= OCVisibility.PROTECTED.ordinal()) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PROTECTED));
            if (symbol instanceof OCInstanceVariableSymbol) {
                OCInterfaceSymbol intfSymbol;
                OCImplementation clazz = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCImplementation.class});
                OCImplementationSymbol implSymbol = clazz.getSymbol();
                OCInterfaceSymbol oCInterfaceSymbol = intfSymbol = implSymbol != null ? implSymbol.getInterface() : null;
                if (implSymbol != null) {
                    this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(symbol.getKind(), element, intfSymbol, symbol));
                }
            }
        }
        return false;
    }

    public void checkReturnStatement(OCReturnStatement stmt) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCCallable.class});
        OCExpression expr = stmt.getExpression();
        String callableKind = "function/method/block";
        if (callable == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDRillegal_return", "Return statement is outside of a " + callableKind + " declaration");
            return;
        }
        OCSymbol symbol = callable.getSymbol();
        OCType returnType = callable.getReturnType().resolve(stmt.getContainingFile());
        if (symbol != null) {
            callableKind = symbol.getKindLowercase();
            if (symbol.getKind().isConstructorOrDestructor()) {
                returnType = OCVoidType.instance();
            }
        }
        if (expr == null) {
            if (!(returnType instanceof OCVoidType)) {
                String message = "Returning 'void' from a " + callableKind + " returning '" + returnType.getName(stmt) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_missing_expr", message);
                if (symbol != null) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCVoidType.instance(), true));
                }
            }
            return;
        }
        OCType rType = expr.getResolvedType().getGuessedType();
        String message = "Returning '" + rType.getName(stmt) + "' from a " + callableKind + " returning '" + returnType.getName(stmt) + "'";
        if (returnType instanceof OCVoidType && !(rType instanceof OCVoidType)) {
            Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_has_expr", message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, rType, true));
        } else {
            this.checkAssignment(expr, (PsiElement)stmt, returnType, rType, symbol, message + ": ");
        }
    }

    public void checkSwitchStatement(OCSwitchStatement stmt) {
        List<Object> missingCases;
        boolean isEnumClass;
        OCType type;
        OCDeclarationOrExpression expr = stmt.getExpression();
        OCBlockStatement body = stmt.getBody();
        ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
        boolean wasDefaultOrUnresolved = true;
        Ref wasField = Ref.create((Object)false);
        OCType oCType = type = expr != null ? expr.getResolvedType() : null;
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        boolean bl = isEnumClass = type instanceof OCStructType && ((OCStructType)type).isEnumClass();
        if (body != null) {
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            wasDefaultOrUnresolved = OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
            missingCases = OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)wasField);
            final Ref wasDefault = Ref.create((Object)false);
            body.accept(new OCRecursiveVisitor(){

                @Override
                public void visitCaseStatement(OCCaseStatement stmt) {
                    Annotation annotation;
                    super.visitCaseStatement(stmt);
                    OCStatement statement = stmt.getStatement();
                    if (statement == null) {
                        OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Statement is expected");
                    } else if (statement instanceof OCDeclarationStatement && OCCodeInsightUtil.isInPlainOldC(stmt)) {
                        annotation = OCOperatorsChecker.this.addErrorAnnotation(statement, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
                        OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement, "Remove statement"));
                    }
                    if (stmt.isDefault()) {
                        if (((Boolean)wasDefault.get()).booleanValue()) {
                            OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "err_multiple_default_labels_defined", "Duplicate default label");
                        } else {
                            if (missingCases.isEmpty() && isEnumClass) {
                                annotation = OCOperatorsChecker.this.addWarningAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "CIDR", "Default case is useless: all cases are covered");
                                OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, "Remove statement"));
                            }
                            wasDefault.set((Object)true);
                        }
                    }
                }

                @Override
                public void visitSwitchStatement(OCSwitchStatement stmt) {
                }
            });
            block0: for (int i = 0; i < ranges.size(); ++i) {
                Pair range = (Pair)ranges.get(i);
                OCCaseStatement caseStatement = (OCCaseStatement)caseStmts.get(i);
                for (Pair pair : ranges) {
                    if (range == pair || Math.max((Integer)range.getFirst(), (Integer)pair.getFirst()) > Math.min((Integer)range.getSecond(), (Integer)pair.getSecond())) continue;
                    String message = ((Integer)range.getFirst()).equals(range.getSecond()) ? "Duplicate case value" : "Overlapping case range";
                    this.addErrorAnnotation(caseStatement, OCInspections.DuplicateSwitchCase.class, "err_duplicate_case", message);
                    continue block0;
                }
            }
        } else {
            missingCases = Collections.emptyList();
        }
        if (expr != null) {
            if (!(type.isUnknown() || type.isIntegerCompatible(expr) || type instanceof OCStructType && ((OCStructType)type).isEnumClass())) {
                String message = "Integer expression is required in switch instead of '" + type.getName(stmt) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IntegerTypeRequired.class, "err_typecheck_statement_requires_integer", message);
                OCExpression expression = expr.getExpression();
                if (expression != null) {
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression, OCIntType.CHAR));
                }
            }
            if (!wasDefaultOrUnresolved) {
                Annotation annotation;
                if (!(type.getTerminalType() instanceof OCStructType || ((Boolean)wasField.get()).booleanValue() || type.isUnknown())) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, "CIDRmissing_default_case", "Default case is not handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, true));
                }
                if (!missingCases.isEmpty()) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, OCClangMessageFinder.getInstance().getMissingCase(), "Not all switch cases were handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, false));
                }
            }
        }
    }
}

