/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCLargeFileHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    private static final String LANGUAGES_STRING = PlatformUtils.isAppCode() ? "C/Objective-C/C++" : "C/C++";
    private final PsiFile myFile;
    @NotNull
    private Collection<HighlightInfo> myHighlightInfos = Collections.emptyList();

    public OCLargeFileHighlighter(PsiFile file2, Document document) {
        super(file2.getProject(), document);
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter", "doCollectInformation"));
        }
        this.myHighlightInfos = Collections.emptyList();
        int textLength = this.myFile.getTextLength();
        if (OCCodeInsightUtil.isCodeInsightAvailable(textLength)) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        TextRange range = this.myFile.getTextRange();
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description("File length (" + textLength + ") " + "exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + "). " + "Code insight features are not available.").create();
        if (info == null) {
            return;
        }
        IntentionAction fix = new IntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                if ("Change the maximum file length" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1", "getText"));
                }
                return "Change the maximum file length";
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = LANGUAGES_STRING;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1", "getFamilyName"));
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1", "isAvailable"));
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1", "invoke"));
                }
                OCLargeFileHighlighter.this.adjustMaxFileSize();
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        info.registerFix(fix, Collections.<IntentionAction>emptyList(), "Change the maximum file length", range, null);
        infos.add(info);
        this.myHighlightInfos = infos;
    }

    private void adjustMaxFileSize() {
        String result2;
        int newValue;
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        if (initialValue == (newValue = StringUtil.parseInt((String)(result2 = Messages.showInputDialog((Project)this.myProject, (String)("Enter the new maximum length for " + LANGUAGES_STRING + " files in characters"), (String)"Maximum File Length", null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })), (int)initialValue))) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        this.applyToEditor(Collections.<HighlightInfo>emptyList());
        OCSymbolTablesBuildingActivity activity = OCSymbolTablesBuildingActivity.getInstance(this.myProject);
        if (activity != null) {
            activity.rebuildSymbols(false);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        this.applyToEditor(this.myHighlightInfos);
    }

    private void applyToEditor(@NotNull Collection<HighlightInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter", "applyToEditor"));
        }
        if (this.myDocument != null) {
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myDocument.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }
    }
}

