/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCCheckImplementedMethodsProcessor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCClearElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCopyElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateInterfaceIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementAllMethodsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementInterfaceIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementPropertyAccessorsQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCImplementationChecker
extends OCAnnotator {
    public static final int NON_IMPLEMENTED_METHODS_STRING_MAX_LENGTH = 70;
    public static final int DECLARED_IN_CLASSES_STRING_MAX_LENGTH = 30;

    private void checkImplementationMatchesInterface(OCImplementation implementation, OCInterface anInterface) {
        if (anInterface == null) {
            return;
        }
        OCSuperClassRef implSuperClassRef = implementation.getSuperClassRef();
        OCSuperClassRef intfSuperClassRef = anInterface.getSuperClassRef();
        if (implSuperClassRef.getFirstChild() != null && !OCElementUtil.areElementsEquivalent(implSuperClassRef, intfSuperClassRef, true)) {
            Annotation annotation = this.addErrorAnnotation(implSuperClassRef, "err_conflicting_super_class", "Implementation superclass is inconsistent with interface superclass");
            this.registerQuickFix(annotation, new OCCopyElementIntentionAction(intfSuperClassRef, implSuperClassRef, "Copy superclass from interface"));
            this.registerQuickFix(annotation, new OCCopyElementIntentionAction(implSuperClassRef, intfSuperClassRef, "Copy superclass to interface"));
            this.registerQuickFix(annotation, new OCClearElementIntentionAction(implSuperClassRef, "Remove superclass"));
        }
    }

    public void checkMethod(OCMethod method) {
        List<PsiElement> selectors = method.getSelectors();
        this.myDeclaratorChecker.checkDuplicates(method.getSelector(), method, selectors);
        OCType returnType = method.getReturnType().resolve(method.getContainingFile());
        final OCMethodSymbol symbol = (OCMethodSymbol)method.getSymbol();
        if (!returnType.isVoid()) {
            this.myDeclaratorChecker.checkInstanceable(returnType, method.getReturnTypeElement(), symbol, true);
        }
        if (symbol == null) {
            return;
        }
        if (!(symbol.getParent() instanceof OCImplementationSymbol)) {
            this.myOperatorsChecker.checkReadonlyAccess(selectors, symbol, "Declaring");
        }
        if (symbol.isDefinition() && OCCompilerHelper.supportsAutosynthesis(method.getContainingOCFile())) {
            OCPropertySymbol property;
            OCMethodSymbol associatedSymbol = symbol.getAssociatedSymbol();
            OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            if (property != null && !property.isReadonly() && property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ATOMIC, property.getType(), method) != OCPropertySymbol.PropertyAttribute.NONATOMIC && property.processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){
                int cnt;

                public boolean process(OCMethodSymbol symbol) {
                    return ++this.cnt < 2;
                }
            }, false)) {
                String message = "Writable atomic " + property.getNameWithKindLowercase() + " can't have a" + (symbol.isGetter() ? " defined getter and a synthesized setter" : " synthesized getter and a defined setter");
                List<Annotation> annotations = this.addWarningAnnotations(selectors, OCInspections.AccessorsWereOverridden.class, "warn_atomic_property_rule", message);
                this.registerQuickFixes(annotations, new OCImplementPropertyAccessorsQuickFix(property){

                    @Override
                    @NotNull
                    public String getText() {
                        String string = "Implement missing " + (symbol.isGetter() ? "setter" : "getter") + " method";
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/OCImplementationChecker$2", "getText"));
                        }
                        return string;
                    }
                });
                this.registerQuickFixes(annotations, new OCChangePropertyAttributeIntentionAction(property, OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.NONATOMIC, null));
                this.registerQuickFixes(annotations, new OCRemoveElementsIntentionAction((PsiElement)method, "Remove user-defined " + (symbol.isGetter() ? "getter" : "setter") + " method"));
            }
        }
    }

    private void checkClassContents(OCClassDeclaration<? extends OCClassSymbol> clazz) {
        Annotation annotation;
        OCInstanceVariablesList implVariables = clazz.getInstanceVariablesList();
        String categoryName = clazz.getCategory();
        if (categoryName != null) {
            if (!clazz.getSuperClassRef().isEmpty()) {
                annotation = this.addErrorAnnotation(clazz.getSuperClassRef(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Category can't have superclass");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getSuperClassRef(), "Remove superclass reference"));
            }
            if (!(implVariables.isEmpty() || OCCompilerHelper.supportsIvarsInCategories() && categoryName.isEmpty())) {
                annotation = this.addErrorAnnotation(implVariables, OCInspections.ConstructionIsNotAllowed.class, "err_misplaced_ivar", "Category can't have instance variables");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(implVariables, "Remove instance variable list"));
            }
        }
        if (clazz instanceof OCProtocol) {
            if (!clazz.getSuperClassRef().isEmpty()) {
                annotation = this.addErrorAnnotation(clazz.getSuperClassRef(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Protocol can't have superclass");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getSuperClassRef(), "Remove superclass reference"));
            }
            if (!implVariables.isEmpty() && implVariables.getDeclarations().size() > 0) {
                annotation = this.addErrorAnnotation(implVariables.getDeclarations().get(0), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Protocol can't have instance variables");
                this.registerQuickFix(annotation, new OCClearElementIntentionAction(implVariables, "Remove instance variable list"));
            }
            if (categoryName != null) {
                this.addErrorAnnotation(clazz.getNameIdentifier(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Protocol can't have category");
            }
        }
        if (clazz instanceof OCImplementation && !clazz.getProtocolList().isEmpty()) {
            annotation = this.addErrorAnnotation(clazz.getProtocolList(), OCInspections.ConstructionIsNotAllowed.class, "err_objc_unexpected_attr", "Implementation can't have protocols");
            this.registerQuickFix(annotation, new OCClearElementIntentionAction(clazz.getProtocolList(), "Remove protocols list"));
        }
        for (OCMethod method : clazz.getMethods()) {
            if (method.getBody() != null) {
                Annotation annotation2 = null;
                if (clazz instanceof OCInterface) {
                    annotation2 = this.addErrorAnnotation(method.getBody(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Interface can't have method implementations");
                }
                if (clazz instanceof OCProtocol) {
                    annotation2 = this.addErrorAnnotation(method.getBody(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Protocol can't have method implementations");
                }
                if (annotation2 == null) continue;
                this.registerQuickFix(annotation2, new OCRemoveElementsIntentionAction((PsiElement)method.getBody(), "Remove method body"));
                continue;
            }
            if (!(clazz instanceof OCImplementation)) continue;
            this.addErrorAnnotation(method.getNavigationElement(), null, "err_expected_method_body", "Implementation of this method is expected");
        }
    }

    public void checkSynthesize(OCSynthesizeProperty property) {
        OCReferenceElement ivarRef;
        OCImplementation implementation = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCImplementation.class});
        if (implementation == null) {
            Annotation annotation = this.addErrorAnnotation(property.getParent(), OCInspections.ConstructionIsNotAllowed.class, "CIDR", "'@synthesize'/'@dynamic' is outside of a class implementation");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(property.getParent(), "Remove '@synthesize'/'@dynamic' statement"));
            return;
        }
        if (implementation.getCategory() != null && property.isSynthesize()) {
            Annotation annotation = this.addErrorAnnotation(property.getParent(), OCInspections.ConstructionIsNotAllowed.class, "error_synthesize_category_decl", "'@synthesize' is not allowed in category's implementation");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(property.getParent(), "Remove '@synthesize' statement"));
            return;
        }
        OCReferenceElement propertyRef = property.getPropertyRef();
        if (propertyRef == null) {
            return;
        }
        OCClassSymbol classSymbol = implementation.getSymbol();
        OCPropertySymbol propertySymbol = (OCPropertySymbol)propertyRef.resolveToSymbol();
        OCReferenceElement oCReferenceElement = ivarRef = property.getInstanceVariableRef() != null ? property.getInstanceVariableRef() : propertyRef;
        if (classSymbol == null || ivarRef == null || propertySymbol == null) {
            return;
        }
        classSymbol = classSymbol.getInterface();
        OCFileSymbols.markImportNeeded(property.getContainingOCFile(), propertySymbol.getParent());
        OCInstanceVariableSymbol ivarSymbol = (OCInstanceVariableSymbol)ivarRef.resolveToSymbol(new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.INSTANCE_VARIABLE, classSymbol)));
        if (ivarSymbol == null) {
            return;
        }
        if (ivarSymbol.getGeneratedFromProperty() != null && property.isSynthesize()) {
            this.handleDynamicIvar(property, propertySymbol, ivarRef);
        }
        if (ivarSymbol.getGeneratedFromProperty() == null) {
            OCFileSymbols.markSymbolAsUsed(property.getContainingOCFile(), ivarSymbol, property);
        }
        this.checkDuplicateSynthesize(property, propertySymbol, propertyRef);
        this.checkDuplicateSynthesize(property, ivarSymbol, ivarRef);
        String propertyCategory = ((OCClassSymbol)propertySymbol.getParent()).getCategoryName();
        if (propertyCategory != null && !propertyCategory.isEmpty()) {
            Annotation annotation = this.addErrorAnnotation(propertyRef, OCInspections.ConstructionIsNotAllowed.class, "error_category_property", "Can't synthesize property declared in category");
            if (classSymbol != null) {
                this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.PROPERTY, property, classSymbol, propertySymbol));
            }
        }
        if (classSymbol != null && !((OCClassSymbol)ivarSymbol.getParent()).getName().equals(classSymbol.getName())) {
            String message = ivarSymbol.getNameWithKindUppercase() + " must be declared in class '" + implementation.getCanonicalName() + "'";
            Annotation annotation = this.addErrorAnnotation(ivarRef, "error_ivar_in_superclass_use", message);
            this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.INSTANCE_VARIABLE, property, classSymbol, ivarSymbol));
        }
    }

    private void handleDynamicIvar(OCSynthesizeProperty property, OCPropertySymbol propertySymbol, OCReferenceElement ivarRef) {
        for (OCAnnotatorHelper each : OCImplementationChecker.getAnnotatorHelpers()) {
            each.checkDynamicIVar(this, property, propertySymbol, ivarRef);
        }
    }

    private void checkDuplicateSynthesize(OCSynthesizeProperty stmt, final OCMemberSymbol symbol, final PsiElement reference) {
        final int stmtOffset = stmt.getTextOffset();
        Processor<OCSynthesizeSymbol> processor2 = new Processor<OCSynthesizeSymbol>(){

            public boolean process(OCSynthesizeSymbol synthesizeSymbol) {
                Object definition = synthesizeSymbol.locateDefinition();
                if (definition != null && definition.getTextOffset() < stmtOffset) {
                    String message = null;
                    OCPropertySymbol propertySymbol = synthesizeSymbol.getAssociatedProperty();
                    OCInstanceVariableSymbol ivarSymbol = synthesizeSymbol.getIvarSymbol();
                    String clangID = null;
                    if (symbol instanceof OCInstanceVariableSymbol && propertySymbol != null) {
                        message = symbol.getNameWithKindUppercase() + " was already used for synthesizing of " + propertySymbol.getNameWithKindLowercase();
                        clangID = "error_duplicate_ivar_use";
                    } else if (symbol instanceof OCPropertySymbol && ivarSymbol != null) {
                        message = "Accessors of " + symbol.getNameWithKindLowercase() + " were already synthesized with " + ivarSymbol.getNameWithKindLowercase();
                        clangID = "error_property_implemented";
                    }
                    if (message != null) {
                        OCImplementationChecker.this.addErrorAnnotation(reference, OCInspections.DuplicateDeclarations.class, clangID, message);
                    }
                    return false;
                }
                return true;
            }
        };
        if (symbol instanceof OCPropertySymbol) {
            ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)processor2);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            ((OCInstanceVariableSymbol)symbol).processSynthesizes(processor2);
        }
    }

    public void checkInterfaceDeclaration(OCInterface anInterface) {
        OCInterfaceSymbol mainInterface;
        this.checkClassContents(anInterface);
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        if (interfaceSymbol == null || interfaceSymbol.isPredeclaration()) {
            return;
        }
        if (this.checkCyclicInheritance(anInterface)) {
            return;
        }
        this.checkCategoryImport(anInterface, interfaceSymbol, interfaceSymbol.getResolvedType());
        OCImplementationSymbol implementationSymbol = interfaceSymbol.getImplementation();
        if (implementationSymbol != null) {
            if (!"CoreDataGeneratedAccessors".equals(interfaceSymbol.getCategoryName())) {
                OCCheckImplementedMethodsProcessor methodsProcessor = new OCCheckImplementedMethodsProcessor(this, implementationSymbol, null, false);
                interfaceSymbol.processMembers(OCMethodSymbol.class, methodsProcessor);
            }
        } else if (OCCodeInsightUtil.isValid(anInterface) && anInterface.getCategory() == null) {
            Annotation annotation = this.addWarningAnnotation(anInterface.getNameIdentifier(), OCInspections.InterfaceHasNoImplementation.class, "CIDR", "Interface '" + anInterface.getCanonicalName() + "' doesn't have an implementation");
            this.registerQuickFix(annotation, new OCImplementInterfaceIntentionAction(interfaceSymbol));
        }
        if ("".equals(anInterface.getCategory()) && (mainInterface = interfaceSymbol.getMainInterface()) != null && Comparing.equal((Object)interfaceSymbol.getContainingFile(), (Object)mainInterface.getContainingFile())) {
            this.addWarningAnnotation(anInterface.getNameIdentifier(), OCInspections.PrivateCategoryShouldBeNearImplementation.class, "CIDR", "Private category should not be declared in the same file with the public interface");
        }
    }

    private boolean checkCyclicInheritance(OCInterface anInterface) {
        OCInterfaceSymbol aClass = anInterface.getSymbol();
        HashSet<OCInterfaceSymbol> processed = new HashSet<OCInterfaceSymbol>();
        while (aClass != null) {
            if (!processed.add(aClass)) {
                this.addErrorAnnotation(anInterface.getNameIdentifier(), "err_recursive_superclass", "There's a loop in inheritance hierarchy");
                return true;
            }
            OCReferenceType superType = aClass.getSuperType();
            OCType type = superType.resolve(anInterface.getContainingOCFile());
            aClass = type instanceof OCObjectType ? ((OCObjectType)type).getInterface() : null;
        }
        return false;
    }

    public void checkInterfaceImplementation(OCImplementation implementation) {
        OCImplementationSymbol implementationSymbol = implementation.getSymbol();
        if (implementationSymbol == null) {
            return;
        }
        OCInterfaceSymbol interfaceSymbol = implementationSymbol.getInterface();
        this.checkClassContents(implementation);
        OCType type = implementationSymbol.getType().resolve(implementation.getContainingFile());
        this.checkCategoryImport(implementation, implementationSymbol, type);
        if (interfaceSymbol == null) {
            if (implementation.getCategory() == null) {
                String message = "Implementation of '" + implementation.getCanonicalName() + "' doesn't have an interface declaration";
                Annotation annotation = this.addWarningAnnotation(implementation.getNameIdentifier(), OCInspections.ImplementationHasNoInterface.class, "err_undef_interface", message);
                interfaceSymbol = implementationSymbol.getInterface(true, implementationSymbol.getCategoryName());
                if (interfaceSymbol != null) {
                    this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(implementation.getNameIdentifier(), interfaceSymbol));
                } else {
                    this.registerQuickFix(annotation, new OCCreateInterfaceIntentionAction(implementationSymbol, implementation.getNameIdentifier()));
                }
            }
            return;
        }
        if ("".equals(implementation.getCategory())) {
            this.addErrorAnnotation(implementation.getNameIdentifier(), OCInspections.ConstructionIsNotAllowed.class, "err_expected_unqualified_id", "Private category can't have an implementation");
        }
        OCInterface anInterface = (OCInterface)interfaceSymbol.locateDefinition();
        OCFileSymbols.markImportNeeded(implementation.getContainingOCFile(), interfaceSymbol);
        if (anInterface != null) {
            this.checkImplementationMatchesInterface(implementation, anInterface);
        }
        if (type instanceof OCObjectType && Comparing.equal((String)interfaceSymbol.getCategoryName(), (String)implementationSymbol.getCategoryName())) {
            OCObjectType objectType = (OCObjectType)type;
            OCCheckImplementedMethodsProcessor methodsProcessor = new OCCheckImplementedMethodsProcessor(this, implementationSymbol, ((OCObjectType)type).getSuperType(), true);
            objectType.processInterfaceMethods(interfaceSymbol, null, methodsProcessor, implementation, false);
            if (!methodsProcessor.wasUnimplementedProperty() && methodsProcessor.getUnimplementedMethods().length() > 0) {
                String message = "Class doesn't implement method(s) " + methodsProcessor.getUnimplementedMethods() + " declared in the " + methodsProcessor.getDeclaredInClasses();
                String clangID = OCClangMessageFinder.getInstance().getMethodNotImplemented();
                Annotation annotation = this.addWarningAnnotation(implementation.getNameIdentifier(), OCInspections.NotImplementedMethods.class, clangID, message);
                this.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction(implementationSymbol));
            }
        }
    }

    private void checkCategoryImport(OCClassDeclaration clazz, OCClassSymbol symbol, OCType type) {
        if (symbol.getCategoryName() != null) {
            if (type instanceof OCObjectType) {
                OCFileSymbols.markImportNeeded(clazz.getContainingOCFile(), ((OCObjectType)type).getInterface());
            } else {
                Annotation annotation = this.addErrorAnnotation(clazz.getNameIdentifier(), OCInspections.CannotResolve.class, "CIDR", "Can't resolve interface '" + symbol.getName() + "'");
                OCInterfaceSymbol interfaceDef = OCSymbolImpl.findSymbolDefinition(symbol.getName(), OCSymbolKind.INTERFACE, clazz.getProject(), symbol.getContainingFile(), new Condition<OCInterfaceSymbol>(){

                    public boolean value(OCInterfaceSymbol interfaceSymbol) {
                        return interfaceSymbol.getCategoryName() == null;
                    }
                });
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(clazz.getNameIdentifier(), interfaceDef, true, false));
            }
        }
    }

    public void checkProtocolDeclaration(OCProtocol protocol) {
        this.checkClassContents(protocol);
    }
}

