/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateFunctionPredeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCGenerateConstructorFix;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRenameSymbolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReuseDeclarationIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorChecker
extends OCAnnotator {
    public boolean checkDuplicates(PsiNameIdentifierOwner element) {
        return this.checkDuplicates(element.getName(), (PsiElement)element, Collections.singletonList(element.getNameIdentifier()));
    }

    public boolean checkDuplicates(String name, PsiElement element, List<? extends PsiElement> navigationElements) {
        return this.checkDuplicates(name, null, element, navigationElements);
    }

    public boolean checkDuplicates(String name, OCSymbol declaratorSymbol, PsiElement element, List<? extends PsiElement> navigationElements) {
        if (name == null) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        List<OCSymbol> result2 = OCSymbolReference.getLocalReference(name, element).resolveToSymbols(false, false, file2);
        Collections.sort(result2, new Comparator<OCSymbol>(){

            @Override
            public int compare(OCSymbol symbol, OCSymbol symbol1) {
                return OCSymbolOffsetUtil.compare(symbol1.getComplexOffset(), symbol.getComplexOffset());
            }
        });
        if (declaratorSymbol == null) {
            for (OCSymbol symbol : result2) {
                if (symbol.getComplexOffset() != OCSymbolOffsetUtil.getVirtualComplexOffset(element) || !Comparing.equal((Object)symbol.getContainingFile(), (Object)element.getContainingFile().getVirtualFile())) continue;
                declaratorSymbol = symbol;
                break;
            }
        }
        if (declaratorSymbol == null) {
            return true;
        }
        OCType declaratorType = declaratorSymbol.getType();
        for (OCSymbol symbol : result2) {
            String message;
            if (symbol.equals(declaratorSymbol) || symbol.getKind().isStructLike() != declaratorSymbol.getKind().isStructLike()) continue;
            if (symbol.getKind() == OCSymbolKind.UNDEF_MACRO) break;
            List<Annotation> annotations = null;
            List<Object> quickFixes = Collections.emptyList();
            if (symbol instanceof OCDeclaratorSymbol && declaratorSymbol instanceof OCDeclaratorSymbol && symbol.getScope() != null && symbol.getScope().isEmpty() && declaratorSymbol.getScope() != null && declaratorSymbol.getScope().equals((Object)symbol.getScope())) continue;
            if (OCResolveUtil.isDuplicate(symbol, declaratorSymbol)) {
                VirtualFile symbolFile = symbol.getContainingFile();
                String previousFile = "";
                if (symbolFile != null && !symbolFile.equals(element.getContainingFile().getVirtualFile())) {
                    previousFile = " in '" + symbolFile.getName() + "'";
                }
                if (symbol.getKind().isStructLike() && declaratorSymbol.getKind().isStructLike() && symbol.getKind() != declaratorSymbol.getKind()) {
                    message = "Duplicate declaration of tag '" + OCSymbolImpl.getTagOfStructLike(declaratorSymbol) + "' with different type";
                    annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_use_with_wrong_tag", message);
                } else if (OCDeclaratorChecker.isDefinition(declaratorSymbol) && OCDeclaratorChecker.isDefinition(symbol)) {
                    boolean symbolIsTypedef;
                    boolean declaratorIsTypedef = declaratorSymbol.getKind() == OCSymbolKind.TYPEDEF;
                    boolean bl = symbolIsTypedef = symbol.getKind() == OCSymbolKind.TYPEDEF;
                    if (declaratorIsTypedef && symbolIsTypedef || declaratorIsTypedef && symbol.getKind().isStructLike() || symbolIsTypedef && declaratorSymbol.getKind().isStructLike()) {
                        if (!(declaratorIsTypedef && symbolIsTypedef && declaratorSymbol.getResolvedType().getCanonicalName(element).equals(symbol.getType().resolve(file2).getCanonicalName(element)) || declaratorIsTypedef && declaratorSymbol.getResolvedType().getCanonicalName(element).equals(symbol.getName()) || symbolIsTypedef && symbol.getResolvedType().getCanonicalName(element).equals(declaratorSymbol.getName()))) {
                            annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_use_of_tag_name_without_tag", "Typedef redefinition with different types");
                        }
                    } else {
                        String nameWithKind = declaratorSymbol instanceof OCStructSymbol ? "tag '" + OCSymbolImpl.getTagOfStructLike(declaratorSymbol) + "'" : declaratorSymbol.getNameWithKindLowercase();
                        String message2 = "Duplicate declaration of " + nameWithKind + (!previousFile.isEmpty() ? "; previous one was" + previousFile : "");
                        annotations = symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null ? this.addWarningAnnotations(navigationElements, null, "warn_dup_category_def", message2) : (symbol instanceof OCMacroSymbol ? this.addWarningAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "err_redefinition", message2) : this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition", message2));
                    }
                } else {
                    String message3;
                    boolean checkConst;
                    OCType type = symbol.getType().resolve(file2);
                    String subject = "all declarations of '" + declaratorSymbol.getName() + "'";
                    OCResolveContext context = new OCResolveContext(declaratorSymbol.getContainingOCFile());
                    boolean bl = checkConst = !(type instanceof OCArrayType) || ((OCArrayType)type).hasLength() || !(declaratorType instanceof OCArrayType) || !(symbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)symbol).isExtern();
                    if (symbol instanceof OCClassSymbol != declaratorSymbol instanceof OCClassSymbol) {
                        message3 = declaratorSymbol.getNameWithKindUppercase() + " was redeclared with different kind of symbol, previous one was \"" + symbol.getKindUppercase() + "\"" + previousFile;
                        annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition_different_kind", message3);
                    } else if (!new OCTypeEqualityAfterResolvingVisitor(type, false, context).equal(declaratorType, checkConst)) {
                        message3 = declaratorSymbol.getNameWithKindUppercase() + " was redeclared with different type '" + declaratorType.getName(element) + "'; previous was '" + type.getName(element) + "'" + previousFile;
                        annotations = this.addErrorAnnotations(navigationElements, OCInspections.DuplicateDeclarations.class, "err_redefinition_different_type", message3);
                        if (declaratorSymbol instanceof OCSymbolWithQualifiedName && symbol instanceof OCSymbolWithQualifiedName) {
                            quickFixes = Arrays.asList(new OCChangeTypeIntentionAction(declaratorSymbol, symbol.getType(), subject), new OCChangeTypeIntentionAction(declaratorSymbol, declaratorType, subject));
                        }
                    }
                }
            } else if (declaratorSymbol instanceof OCDeclaratorSymbol) {
                annotations = this.checkDeclaratorAlias(navigationElements, declaratorSymbol, symbol, element);
            } else if (element instanceof OCMethod && declaratorSymbol instanceof OCMethodSymbol && symbol instanceof OCMethodSymbol) {
                this.checkMethodAlias((OCMethod)element, (OCMethodSymbol)declaratorSymbol, (OCMethodSymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCPropertySymbol && ((OCPropertySymbol)declaratorSymbol).getParent() != ((OCPropertySymbol)symbol).getParent()) {
                this.checkPropertyAlias((OCDeclaration)element.getParent(), (OCPropertySymbol)declaratorSymbol, (OCPropertySymbol)symbol);
            } else if (declaratorSymbol instanceof OCPropertySymbol && symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() == null) {
                Object definition = symbol.locateDefinition();
                final OCPropertySymbol property = (OCPropertySymbol)declaratorSymbol;
                CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                    protected boolean accept(OCMethodSymbol accessor) {
                        return accessor.getGeneratedFromProperty() == property;
                    }
                };
                ((OCClassSymbol)property.getParent()).processMembers(symbol.getName(), OCMethodSymbol.class, finder);
                if (definition instanceof OCMethod && finder.isFound()) {
                    this.checkMethodAlias((OCMethod)definition, (OCMethodSymbol)symbol, (OCMethodSymbol)finder.getFoundValue());
                }
            } else if (declaratorSymbol instanceof OCInstanceVariableSymbol && symbol instanceof OCInstanceVariableSymbol) {
                OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
                OCInstanceVariableSymbol declaratorIvar = (OCInstanceVariableSymbol)declaratorSymbol;
                if (!ivar.isClang4ImplicitIvar(file2) && !((OCClassSymbol)ivar.getParent()).isSameClass((OCClassSymbol)declaratorIvar.getParent()) && ivar.getVisibility() != OCVisibility.PRIVATE) {
                    message = declaratorIvar.getNameWithKindUppercase() + " overrides " + ivar.getNameWithKindLowercase() + " in inherited " + ((OCClassSymbol)ivar.getParent()).getNameWithKindLowercase();
                    annotations = this.addErrorAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "err_duplicate_member", message);
                }
            }
            for (IntentionAction quickFix : quickFixes) {
                this.registerQuickFixes(annotations, quickFix);
            }
            if (declaratorSymbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                this.registerQuickFixes(annotations, new OCReuseDeclarationIntentionAction(declaratorSymbol, "Reuse previous declaration of " + symbol.getNameWithKindLowercase()));
            } else {
                this.registerQuickFixes(annotations, new OCRemoveDeclarationIntentionAction(declaratorSymbol));
                this.registerQuickFixes(annotations, new OCRemoveDeclarationButInitializerIntentionAction(declaratorSymbol));
            }
            if (symbol.getKind() != OCSymbolKind.PARAMETER) {
                this.registerQuickFixes(annotations, new OCRemoveDeclarationIntentionAction("previous declaration", symbol));
                this.registerQuickFixes(annotations, new OCRemoveDeclarationButInitializerIntentionAction("previous declaration", symbol));
            }
            if (annotations == null) continue;
            return false;
        }
        return true;
    }

    private static boolean isDefinition(OCSymbol symbol) {
        return !symbol.isPredeclaration() || symbol instanceof OCMethodSymbol || (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriendFunction() || symbol instanceof OCDeclaratorSymbol) && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol;
    }

    @Nullable
    private List<Annotation> checkDeclaratorAlias(List<? extends PsiElement> navigationElements, OCSymbol declaratorSymbol, OCSymbol symbol, PsiElement element) {
        List<Annotation> annotations = null;
        if (symbol instanceof OCDeclaratorSymbol && declaratorSymbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            TextRange declaratorScope = declaratorSymbol.getScope();
            TextRange duplicateScope = symbol.getScope();
            if (declaratorScope != null && duplicateScope != null && duplicateScope.contains(declaratorScope)) {
                annotations = this.addWarningAnnotations(navigationElements, OCInspections.HidesUpperScope.class, "warn_decl_shadow", declaratorSymbol.getNameWithKindUppercase() + " hides previous declaration in the upper scope");
            }
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCClassSymbol ivarParent;
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCMethod.class});
            if (containingMethod == null) {
                return null;
            }
            OCMethodSymbol method = (OCMethodSymbol)containingMethod.getSymbol();
            String suffixMessage = "";
            if (method == null || method.isStatic() || !(method.getParent() instanceof OCImplementationSymbol)) {
                return null;
            }
            OCClassSymbol methodParent = (OCClassSymbol)method.getParent();
            if (!methodParent.isSameSymbol(ivarParent = (OCClassSymbol)ivar.getParent())) {
                suffixMessage = " declared in " + ivarParent.getNameWithKindLowercase();
                if (ivar.getVisibility() == OCVisibility.PRIVATE) {
                    return null;
                }
            }
            String message = declaratorSymbol.getNameWithKindUppercase() + " hides the " + symbol.getKind().getNameLowercase() + " with the same name" + suffixMessage;
            annotations = this.addWarningAnnotations(navigationElements, OCInspections.HidesClassScope.class, "warn_ivar_use_hidden", message);
        }
        this.registerQuickFixes(annotations, new OCRenameSymbolIntentionAction(declaratorSymbol));
        return annotations;
    }

    private void checkMethodAlias(OCMethod method, OCMethodSymbol declaratorMethod, OCMethodSymbol baseMethod) {
        String message;
        if (baseMethod.equals(declaratorMethod.getAssociatedSymbol())) {
            return;
        }
        if (declaratorMethod.isStatic() != baseMethod.isStatic()) {
            return;
        }
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        String messageSuffix = "";
        if (!Comparing.equal(declaratorMethod.getParent(), baseMethod.getParent())) {
            messageSuffix = "; " + (property != null ? "property" : "base method") + " was declared in " + ((OCClassSymbol)baseMethod.getParent()).getNameWithKindLowercase();
        }
        OCType declReturnType = declaratorMethod.getReturnType();
        OCType baseReturnType = baseMethod.getReturnType();
        if (!baseReturnType.isSuperType(declReturnType, method)) {
            Annotation annotation;
            if (property != null && OCNameSuggester.isObjCGetter(declaratorMethod.getName())) {
                message = "Return type (" + declReturnType.getName(method) + ") of getter method for " + property.getNameWithKindLowercase() + " doesn't match the type (" + property.getType().getName(method) + ") of property" + messageSuffix;
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, property.getType()));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declReturnType));
            } else if (property != null && OCNameSuggester.isObjCSetter(declaratorMethod.getName())) {
                message = "Return type of setter method must be 'void'";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declaratorMethod, OCVoidType.instance()));
            } else {
                message = "Return type (" + declReturnType.getName(method) + ") of overridden method doesn't match the return type (" + baseReturnType.getName(method) + ") of base method";
                annotation = this.addWarningAnnotation(method.getReturnTypeElement(), OCInspections.OverriddenTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declaratorMethod, baseReturnType, "overridden " + declaratorMethod.getNameWithKindLowercase()));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseMethod, declReturnType, "base " + baseMethod.getNameWithKindLowercase()));
            }
        }
        for (int i = 0; i < declaratorMethod.getSelectors().size(); ++i) {
            Annotation annotation;
            OCType baseParamType;
            OCType declParamType;
            OCDeclaratorSymbol declParameter = declaratorMethod.getSelectors().get(i).getParameter();
            OCDeclaratorSymbol baseParameter = baseMethod.getSelectors().get(i).getParameter();
            if (declParameter == null || baseParameter == null || (declParamType = declParameter.getType()).isSuperType(baseParamType = baseParameter.getType(), method)) continue;
            OCTypeElement typeElement = method.getParameters().get(i).getTypeElement();
            if (property != null) {
                message = "Parameter type (" + declParamType.getName(method) + ") of setter method for " + property.getNameWithKindLowercase() + " doesn't match the type (" + property.getType().getName(method) + ") of property" + messageSuffix;
                annotation = this.addWarningAnnotation(typeElement, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message);
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(declParameter, property.getType()));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, declParamType));
                continue;
            }
            message = "Parameter type (" + declParamType.getName(method) + ") of overridden method doesn't match the parameter type (" + baseParamType.getName(method) + ") of base method";
            annotation = this.addWarningAnnotation(typeElement, OCInspections.OverriddenTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)declParameter, baseParamType, "overridden " + declParameter.getNameWithKindLowercase()));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseParameter, declParamType, "base " + baseParameter.getNameWithKindLowercase()));
        }
    }

    private void checkPropertyAlias(OCDeclaration property, OCPropertySymbol declaratorProperty, OCPropertySymbol baseProperty) {
        OCType declaratorPropType = declaratorProperty.getResolvedType();
        OCType basePropType = baseProperty.getResolvedType();
        this.checkPropertyTypesMatch(baseProperty, "base property", declaratorProperty, "overridden property", property.getTypeElement(), OCInspections.OverriddenTypeMismatch.class);
        OCPropertySymbol.PropertyAttribute[] attrGroups = new OCPropertySymbol.PropertyAttribute[]{OCPropertySymbol.PropertyAttribute.ATOMIC, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.STRONG};
        OCClassSymbol declParent = (OCClassSymbol)declaratorProperty.getParent();
        OCClassSymbol baseParent = (OCClassSymbol)baseProperty.getParent();
        PsiElement attributesHighlightElement = property.getParent();
        Annotation annotation = null;
        if (((OCProperty)attributesHighlightElement).getPropertyAttributesList() != null) {
            attributesHighlightElement = ((OCProperty)attributesHighlightElement).getPropertyAttributesList();
        }
        for (OCPropertySymbol.PropertyAttribute attrGroup : attrGroups) {
            OCPropertySymbol.PropertyAttribute declValue = declaratorProperty.getAttributeOfGroup(attrGroup, declaratorPropType, property);
            OCPropertySymbol.PropertyAttribute baseValue = baseProperty.getAttributeOfGroup(attrGroup, basePropType, property);
            boolean incompatibility = false;
            boolean isError = false;
            String message = "Overridden property is " + declValue.toString().toLowerCase() + "; the base property is " + baseValue.toString().toLowerCase();
            String clangID = "err_objc_property_attr_mutually_exclusive";
            List<OCChangePropertyAttributeIntentionAction> quickFixes = Arrays.asList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, declValue, baseValue, null, "overridden property"), new OCChangePropertyAttributeIntentionAction(baseProperty, baseValue, declValue, null, "base property"));
            if (attrGroup == OCPropertySymbol.PropertyAttribute.ATOMIC) {
                incompatibility = declValue != baseValue;
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.READWRITE) {
                if ("".equals(declParent.getCategoryName()) && baseParent.getCategoryName() == null && declParent.getName().equals(baseParent.getName())) {
                    if (!baseProperty.isReadonly()) {
                        quickFixes = Arrays.asList(new OCChangePropertyAttributeIntentionAction(baseProperty, OCPropertySymbol.PropertyAttribute.READWRITE, OCPropertySymbol.PropertyAttribute.READONLY, null, "base property"));
                        message = "Overridden properties must be 'readonly' in the interface";
                        clangID = "err_use_continuation_class_redeclaration_readwrite";
                        isError = true;
                        incompatibility = true;
                    } else if (declaratorProperty.isReadonly()) {
                        quickFixes = Arrays.asList(new OCChangePropertyAttributeIntentionAction(declaratorProperty, OCPropertySymbol.PropertyAttribute.READONLY, OCPropertySymbol.PropertyAttribute.READWRITE, null, "category property"));
                        message = "Overridden properties must be 'readwrite' in the private category";
                        isError = true;
                        incompatibility = true;
                    }
                } else {
                    incompatibility = declaratorProperty.isReadonly() && !baseProperty.isReadonly();
                }
            } else if (attrGroup == OCPropertySymbol.PropertyAttribute.STRONG) {
                boolean bl = incompatibility = declValue.getSemanticsGroup() != baseValue.getSemanticsGroup();
            }
            if (!incompatibility) continue;
            annotation = isError ? this.addErrorAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, message) : this.addWarningAnnotation(attributesHighlightElement, OCInspections.OverriddenAttributeMismatch.class, clangID, message);
            for (IntentionAction intentionAction : quickFixes) {
                this.registerQuickFix(annotation, intentionAction);
            }
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("overridden part", declaratorProperty));
        }
    }

    public void checkDeclarator(@Nullable OCType lType, @NotNull PsiNameIdentifierOwner element, @Nullable OCDeclarator declarator, OCSymbol symbol) {
        OCParameterList paramsList;
        PsiElement function;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/daemon/OCDeclaratorChecker", "checkDeclarator"));
        }
        String name = element.getName();
        if (!this.checkDuplicates(element)) {
            return;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockExpression.class) == null && OCElementUtil.getSelfSuperToken(name, (PsiElement)element, new OCResolveContext((PsiElement)element)) != null) {
            Annotation annotation = this.addErrorAnnotation((PsiElement)element, "err_redefinition_different_type", "Can't create a variable with name '" + name + "' inside the method");
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol));
            return;
        }
        if (lType == null || symbol == null) {
            return;
        }
        OCFile file2 = (OCFile)element.getContainingFile();
        PsiElement declaratorParent = declarator != null ? declarator.getParent() : null;
        if (this.checkUnknownStructure(lType = lType.resolve(file2), declarator, symbol) || lType.isUnknown()) {
            return;
        }
        if (!(declarator == null || !OCDeclaratorChecker.requiresInitializer(lType, file2) || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern() || !declarator.getInitializers().isEmpty() || declaratorParent.getParent().getParent() instanceof OCLoopStatement)) {
            switch (symbol.getKind()) {
                case LOCAL_VARIABLE: 
                case GLOBAL_VARIABLE: 
                case GLOBAL_VARIABLE_PREDECLARATION: {
                    String message = "Declaration of " + (lType instanceof OCCppReferenceType ? "reference" : "const") + " variable requires an initializer";
                    if (lType instanceof OCStructType) {
                        message = message + " or an explicit default constructor";
                    }
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, "err_reference_var_requires_init", message);
                    this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, symbol));
                    if (!(lType instanceof OCStructType)) break;
                    this.registerQuickFix(annotation, new OCGenerateConstructorFix(((OCStructType)lType).getSymbol(), false));
                    break;
                }
                case INSTANCE_VARIABLE: {
                    if (!(lType instanceof OCCppReferenceType)) break;
                    Annotation annotation1 = this.addErrorAnnotation((PsiElement)element, "err_ivar_reference_type", "Instance variables can't have reference type");
                    this.registerQuickFix(annotation1, new OCChangeTypeIntentionAction(symbol, ((OCCppReferenceType)lType).getRefType()));
                }
            }
        }
        if (!file2.isCpp() && element.getNameIdentifier() == null && element.getParent() instanceof OCParameterDeclaration && element.getParent().getParent() instanceof OCParameterList && (function = (paramsList = (OCParameterList)element.getParent().getParent()).getParent().getParent()) instanceof OCFunctionDefinition && ((OCFunctionDefinition)function).getBody() != null && !(lType instanceof OCEllipsisType) && (!(lType instanceof OCVoidType) || paramsList.getParameterDeclarations().size() != 1)) {
            this.addErrorAnnotation(element.getParent(), "err_parameter_name_omitted", "Parameter name is omitted");
        }
        if (!(lType instanceof OCFunctionType) && !this.checkInstanceable(lType, element.getNameIdentifier(), symbol, false)) {
            return;
        }
        if (lType instanceof OCFunctionType) {
            PsiElement errorElement;
            OCType returnType = ((OCFunctionType)lType).getReturnType();
            PsiElement psiElement = errorElement = element.getParent() instanceof OCFunctionDefinition ? ((OCFunctionDefinition)element.getParent()).getReturnTypeElement() : element.getNameIdentifier();
            if (!returnType.isVoid() && !this.checkInstanceable(returnType, errorElement, symbol, true)) {
                return;
            }
        }
        this.checkDuplicateDeclarator(element, symbol, file2);
        if (file2.isCpp() && declaratorParent instanceof OCFunctionDeclaration && symbol instanceof OCFunctionSymbol) {
            this.myCppChecker.checkCppFunction((OCFunctionDeclaration)declaratorParent, (OCFunctionSymbol)symbol);
        }
        if (!this.checkDeclaratorARCTypes(lType, element, symbol, file2)) {
            return;
        }
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            this.checkPropertyDeclarator(element, property);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCPropertySymbol property = ivar.getAssociatedProperty();
            if (!(property == null || OCCompilerHelper.supportsAutosynthesis(file2) && property.hasAllAccessorsImplemented(false))) {
                this.checkPropertyTypesMatch(property, OCSymbolKind.PROPERTY.getNameLowercase(), ivar, OCSymbolKind.INSTANCE_VARIABLE.getNameLowercase(), (PsiElement)element, OCInspections.PropertyAndIvarTypeMismatch.class);
            }
            if (OCCompilerHelper.isArcEnabled(file2)) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute(file2), property);
            }
        }
        if (declarator == null) {
            return;
        }
        this.checkArrayLengths(declarator);
        OCExpression initializer = declarator.getInitializer();
        if (initializer != null && !this.checkDeclaratorInitializer(declarator, symbol, lType, element, null)) {
            return;
        }
        PsiReference constructorReference = declarator.getReference();
        OCSymbol constructorSymbol = null;
        if (file2.isCpp() && constructorReference instanceof OCReference && symbol.getKind() != OCSymbolKind.PARAMETER && symbol.getKind() != OCSymbolKind.CATCH_EXCEPTION_VARIABLE) {
            constructorSymbol = ((OCReference)constructorReference).resolveToSymbol();
            if (!this.myCppChecker.checkConstructorCall(declarator, declarator.getInitializers(), constructorSymbol, initializer == null)) {
                return;
            }
        }
        if (initializer == null) {
            this.checkDeclaratorInitializer(declarator, symbol, lType, element, constructorSymbol);
        }
    }

    protected static boolean requiresInitializer(OCType lType, OCFile file2) {
        if (lType instanceof OCCppReferenceType) {
            return true;
        }
        if (file2.isCpp() && lType.isConst() && !(lType instanceof OCArrayType)) {
            return !(lType instanceof OCStructType) || ((OCStructType)lType).getSymbol().processConstructors((Processor<? super OCFunctionSymbol>)new Processor<OCFunctionSymbol>(){

                public boolean process(OCFunctionSymbol symbol) {
                    return symbol.getNonInitializedParametersCount() > 0;
                }
            });
        }
        return false;
    }

    private boolean checkDeclaratorARCTypes(OCType lType, PsiNameIdentifierOwner element, OCSymbol symbol, OCFile file2) {
        if (OCCompilerHelper.isArcEnabled(file2)) {
            OCType type = symbol.getResolvedType();
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD && type.isPointerToObject() && !file2.isCpp()) {
                while (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type instanceof OCPointerType && ((OCPointerType)type).getARCAttribute() == null) {
                    String clangID = OCClangMessageFinder.getInstance().getUsageOfArcObjectInStruct();
                    Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, "Object struct fields must have an attribute in ARC");
                    for (ARCAttribute attribute : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute));
                    }
                }
                return false;
            }
            if (!this.myOperatorsChecker.checkARCPointerTypes(lType, (PsiElement)element, symbol)) {
                return false;
            }
        }
        return true;
    }

    private void checkDuplicateDeclarator(final PsiNameIdentifierOwner element, final OCSymbol symbol, final OCFile file2) {
        final OCResolveContext context = new OCResolveContext((PsiElement)element);
        if (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION || symbol instanceof OCDeclaratorSymbol) {
            symbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol _symbol) {
                    boolean isExternDeclarator;
                    if (!_symbol.isPredeclaration()) {
                        if (symbol.equals(_symbol) || OCResolveUtil.isEarlierInCode(symbol, _symbol)) {
                            return true;
                        }
                        if (symbol instanceof OCDeclaratorSymbol && _symbol instanceof OCDeclaratorSymbol && (!((OCDeclaratorSymbol)symbol).hasInitializer() || !((OCDeclaratorSymbol)_symbol).hasInitializer())) {
                            return true;
                        }
                        OCSymbolWithQualifiedName symbol1 = (OCSymbolWithQualifiedName)symbol;
                        OCSymbolWithQualifiedName symbol2 = (OCSymbolWithQualifiedName)_symbol;
                        OCSymbolWithQualifiedName owner1 = symbol1.getResolvedOwner();
                        OCSymbolWithQualifiedName owner2 = symbol2.getResolvedOwner();
                        if (symbol1.isTemplateSymbol() || symbol2.isTemplateSymbol()) {
                            return true;
                        }
                        if (owner1 instanceof OCStructSymbol && owner2 instanceof OCStructSymbol ? !owner1.getType().equals(owner2.getType(), false, context) : !Comparing.equal((Object)owner1, (Object)owner2)) {
                            return true;
                        }
                        if (symbol instanceof OCFunctionSymbol && _symbol instanceof OCFunctionSymbol && !symbol.getResolvedType().equals(_symbol.getResolvedType(), false, context)) {
                            return true;
                        }
                        String kind = symbol2.getResolvedKind().getNameUppercase();
                        OCQualifiedName qualifiedName = symbol1.getQualifiedName();
                        Annotation annotation = OCDeclaratorChecker.this.addErrorAnnotation((PsiElement)element, OCInspections.DuplicateDeclarations.class, "err_member_redeclared", kind + " " + qualifiedName + " was redefined");
                        OCDeclaratorChecker.this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("previous declaration", _symbol));
                    }
                    boolean bl = isExternDeclarator = _symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)_symbol).isExtern();
                    if (isExternDeclarator || _symbol instanceof OCFunctionSymbol) {
                        OCFileSymbols.markSymbolAsUsed(file2, _symbol, (PsiElement)element);
                    }
                    return true;
                }
            });
        }
    }

    private boolean checkUnknownStructure(OCType lType, OCDeclarator declarator, OCSymbol symbol) {
        int dimensions;
        int n = dimensions = declarator != null ? declarator.getArrayLengths().size() : 0;
        while (dimensions > 0 && lType instanceof OCPointerType) {
            --dimensions;
            lType = ((OCPointerType)lType).getRefType();
        }
        String lTypeName = lType.getName(declarator);
        if (lType instanceof OCReferenceType && (lTypeName.startsWith("struct") || lTypeName.startsWith("union") || lTypeName.startsWith("enum")) || lType instanceof OCStructType && ((OCStructType)lType).isPredeclaration()) {
            boolean isEnumWithBase;
            boolean isExtern = symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern();
            boolean bl = isEnumWithBase = lType instanceof OCStructType && ((OCStructType)lType).getKind() == OCSymbolKind.ENUM && !((OCStructType)lType).getSymbol().getBaseCppClasses(declarator).isEmpty();
            if (symbol.getKind() != OCSymbolKind.TYPEDEF && !isExtern && !isEnumWithBase) {
                OCStructSymbol struct;
                OCSymbol definitionSymbol;
                Annotation annotation = this.addErrorAnnotation(declarator, OCInspections.CannotResolve.class, "err_typecheck_decl_incomplete_type", "Instantiating an unknown structure without a reference");
                if (lType instanceof OCReferenceType && declarator != null) {
                    lType = lType.resolve(declarator.getContainingFile(), true);
                }
                if (lType instanceof OCStructType && (definitionSymbol = (struct = ((OCStructType)lType).getStructs().get(0)).getDefinitionSymbol()) != null && declarator != null) {
                    OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
                    this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(typeElement, definitionSymbol, false, false));
                }
                return true;
            }
        }
        return false;
    }

    private void checkPropertyDeclarator(PsiNameIdentifierOwner element, OCPropertySymbol property) {
        OCPropertySymbol categoryProperty;
        PsiFile file2 = element.getContainingFile();
        OCType type = property.getType().resolve(file2);
        if (type instanceof OCArrayType || type instanceof OCFunctionType) {
            this.addErrorAnnotation((PsiElement)element, "err_property_type", "Properties can't have the array or function type");
            return;
        }
        if (!(OCCompilerHelper.supportsExplicitAtomic(element.getContainingFile()) || !type.isPointerToObject() || property.hasAttribute(OCPropertySymbol.PropertyAttribute.STRONG) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.WEAK) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.ASSIGN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.UNSAFE_UNRETAINED) || property.hasAttribute(OCPropertySymbol.PropertyAttribute.READONLY))) {
            Annotation annotation = this.addWarningAnnotation(element.getParent().getParent(), OCInspections.NoAttributeForProperty.class, "warn_objc_property_no_assignment_attribute", "No 'strong', 'weak', 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed");
            if (OCCompilerHelper.isArcEnabled(file2)) {
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.STRONG, null));
                this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.WEAK, null));
            }
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.ASSIGN, null));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.RETAIN, null));
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, null, OCPropertySymbol.PropertyAttribute.COPY, null));
        }
        if (((OCClassSymbol)property.getParent()).getCategoryName() == null && (categoryProperty = property.getAssociatedPropertyInPrivateCategory()) != null) {
            this.checkPropertyAlias((OCDeclaration)element.getParent(), categoryProperty, property);
        }
        OCInstanceVariableSymbol ivar = property.getAssociatedIvar();
        if (OCCompilerHelper.isArcEnabled(file2)) {
            if (ivar != null) {
                this.checkARCCompatibleAttributes(element, ivar, ivar.getARCAttribute((PsiElement)file2), property);
            }
            if (type instanceof OCPointerType) {
                this.checkARCCompatibleAttributes(element, property, ((OCPointerType)type).getARCAttribute(), property);
            }
        }
        if (!OCCompilerHelper.supportsAutosynthesis(file2) || !property.hasAllAccessorsImplemented(false)) {
            this.checkPropertyTypesMatch(property, OCSymbolKind.PROPERTY.getNameLowercase(), ivar, OCSymbolKind.INSTANCE_VARIABLE.getNameLowercase(), (PsiElement)element, OCInspections.PropertyAndIvarTypeMismatch.class);
        }
    }

    private void checkARCCompatibleAttributes(PsiNameIdentifierOwner element, OCSymbol symbol, ARCAttribute arcAttribute, OCPropertySymbol property) {
        OCPropertySymbol.PropertyAttribute propAttr;
        OCType type;
        OCType oCType = type = property != null ? property.getResolvedType() : null;
        if (property != null && symbol != null && arcAttribute != null && type.isPointerToObjectCompatible() && arcAttribute != (propAttr = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)element)).getIvarCompatibleARCAttribute() && (propAttr != OCPropertySymbol.PropertyAttribute.ASSIGN || !property.isReadonly())) {
            String clangID;
            String message;
            if (symbol instanceof OCInstanceVariableSymbol) {
                message = "Ivar for " + propAttr.getTokenName() + " " + property.getNameWithKindLowercase() + " must be " + propAttr.getIvarCompatibleARCAttribute().getTokenName();
                clangID = "error_weak_property";
            } else if (symbol instanceof OCPropertySymbol) {
                message = "Attributes '" + propAttr.getTokenName() + "' and '" + arcAttribute.getTokenName() + "' are mutually exclusive";
                clangID = "err_objc_property_attr_mutually_exclusive";
            } else {
                return;
            }
            if (OCWorkspaceManager.getWorkspace(element.getProject()).isInSDK(symbol.getContainingFile())) {
                return;
            }
            Annotation annotation = this.addErrorAnnotation((PsiElement)element, OCInspections.ARCIssues.class, clangID, message);
            this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, propAttr.getIvarCompatibleARCAttribute()));
            OCPropertySymbol.PropertyAttribute attribute = arcAttribute.getPropertyCompatibleSemantics(type, (PsiElement)element).getPropertyAttribute();
            this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(property, propAttr, attribute, null));
        }
    }

    private boolean checkPropertyTypesMatch(OCPropertySymbol baseProperty, String baseSubject, OCSymbol overriddenSymbol, String overriddenSubject, PsiElement annotationElement, Class<? extends OCInspection> inspectionClass) {
        if (baseProperty == null || overriddenSymbol == null) {
            return true;
        }
        OCType baseType = baseProperty.getType().resolve(annotationElement.getContainingFile());
        OCType overriddenType = overriddenSymbol.getType().resolve(annotationElement.getContainingFile());
        String baseTypeName = baseType.getName(annotationElement);
        String overriddenTypeName = overriddenType.getName(annotationElement);
        String message = "The type of " + baseSubject + " (" + baseTypeName + ") isn't assignable from the type of " + overriddenSubject + " (" + overriddenTypeName + ")";
        OCType propertyRequiredType = overriddenType.transformType(OCArrayToPointerChanger.INSTANCE);
        Annotation annotation = this.checkAssignment(null, overriddenSymbol, overriddenSubject, annotationElement, baseType, overriddenType, baseProperty, baseSubject, propertyRequiredType, false, inspectionClass, "warn_property_types_are_incompatible", message);
        if (annotation != null || baseProperty.isReadonly()) {
            return true;
        }
        message = "The type of " + overriddenSubject + " (" + overriddenTypeName + ") isn't assignable from the type of " + baseSubject + " (" + baseTypeName + ") - probably you forgot to mark the " + baseSubject + " 'readonly'";
        OCType ivarRequiredType = baseType.transformType(OCArrayToPointerChanger.INSTANCE);
        annotation = this.checkAssignment(null, baseProperty, baseSubject, annotationElement, overriddenType, baseType, overriddenSymbol, overriddenSubject, ivarRequiredType, false, inspectionClass, "CIDRcovariant_properties", message);
        this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction(baseProperty, null, OCPropertySymbol.PropertyAttribute.READONLY, null));
        return false;
    }

    private boolean checkDeclaratorInitializer(OCDeclarator declarator, OCSymbol symbol, OCType lType, PsiNameIdentifierOwner element, OCSymbol constructorSymbol) {
        List<OCExpression> initializers = declarator.getInitializers();
        OCExpression initializer = (OCExpression)ContainerUtil.getFirstItem(initializers);
        if (!(lType instanceof OCStructType) && initializers.size() > 1) {
            this.addErrorAnnotation(initializers.get(1), "err_excess_initializers", "Only one initializer is permitted");
        }
        if (initializer == null) {
            return false;
        }
        if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern()) {
            Annotation annotation = this.addWarningAnnotation(initializer, OCInspections.IncompatibleInitializers.class, "warn_extern_init", "Extern variable can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
            return false;
        }
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCProperty.class, OCInstanceVariablesList.class, OCCallable.class, OCParameterList.class, OCStructLike.class});
        if (parent instanceof OCProperty) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_expected_semi_decl_list", "Property can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
            return false;
        }
        PsiElement declaration = element.getParent();
        if (initializer.getContainingOCFile().isCpp() && declaration instanceof OCFunctionDeclaration && declaration.getParent() instanceof OCStructLike) {
            return false;
        }
        if (declaration instanceof OCDeclaration && declaration.getParent() instanceof OCStructLike && ((OCStructLike)declaration.getParent()).getKind() != OCSymbolKind.ENUM && !((OCDeclaration)declaration).getContainingOCFile().isCpp()) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Structure field can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
            return false;
        }
        if (parent instanceof OCInstanceVariablesList) {
            Annotation annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Instance variable can't have an initializer");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove initializer"));
            return false;
        }
        if (OCCodeInsightUtil.isInPlainOldC(initializer) && (!(parent instanceof OCCallable) || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isStatic())) {
            this.validateConstExpression(initializer, "CIDR", "Initializer of the " + (parent instanceof OCCallable ? "static " : "") + symbol.getKind().getNameLowercase() + " must be const");
        }
        if (initializers.size() == 1 && !(initializer instanceof OCCompoundInitializer)) {
            if (!declarator.getContainingOCFile().isCpp() && OCParenthesesUtils.diveIntoParenthesesAndCasts(initializer) instanceof OCCompoundInitializer) {
                return true;
            }
            OCType rType = initializer.getResolvedType().getGuessedType();
            OCExpression innerInitializer = OCParenthesesUtils.diveIntoParentheses(initializer);
            if (lType.isCString() && innerInitializer instanceof OCLiteralExpression && rType.isCString()) {
                new OCAnnotator.MyArgumentsChecker().checkCharArrayInit(lType, (OCLiteralExpression)innerInitializer);
            } else if (lType instanceof OCArrayType) {
                this.addErrorAnnotation((PsiElement)element, OCInspections.ArrayIssues.class, "err_array_init_not_init_list", "Compound array initializer is expected");
                return false;
            }
            if (constructorSymbol == null) {
                OCType symbolRequiredType = rType.transformType(OCArrayToPointerChanger.INSTANCE);
                return this.checkAssignment(initializer, (PsiElement)element, lType, rType, symbol, symbolRequiredType) == null;
            }
        }
        return true;
    }

    public boolean checkInstanceable(OCType type, @Nullable PsiElement errorElement, OCSymbol symbol, boolean returnTypeMode) {
        if (errorElement == null) {
            return true;
        }
        if (type instanceof OCBlockPointerType && !(((OCBlockPointerType)type).getRefType() instanceof OCFunctionType)) {
            this.addErrorAnnotation(errorElement, "err_nonfunction_block_type", "Block pointer to non-function is invalid");
            return false;
        }
        if (!(symbol == null || symbol.getKind() == OCSymbolKind.TYPEDEF || type.isUnknown() || type.isInstanceable() || type instanceof OCEllipsisType && (symbol.getKind() == OCSymbolKind.PARAMETER || symbol.getKind() == OCSymbolKind.TEMPLATE_VALUE_PARAMETER))) {
            String clangID;
            String message;
            if (symbol.isCallable()) {
                message = "Can't return type '" + type.getName(errorElement) + "'";
                clangID = "err_object_cannot_be_passed_returned_by_value";
            } else {
                message = "Can't instantiate the variables of type '" + type.getName(errorElement) + "'";
                clangID = "err_statically_allocated_object";
            }
            if (type instanceof OCObjectType || type instanceof OCFunctionType) {
                message = message + " (probably you forgot '*')";
            }
            Annotation annotation = this.addErrorAnnotation(errorElement, OCInspections.PointerTypeRequired.class, clangID, message);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCPointerType.to(type), returnTypeMode));
            return false;
        }
        return true;
    }

    private void checkArrayLengths(OCDeclarator declarator) {
        boolean isFirstLengthExpr = true;
        for (OCExpression length : declarator.getArrayLengths()) {
            Number value;
            OCType type;
            if (length == null) {
                if (!isFirstLengthExpr) {
                    this.addErrorAnnotation(declarator, OCInspections.ArrayIssues.class, "err_illegal_decl_array_incomplete_type", "Empty array length is allowed only at the first dimension");
                    break;
                }
                if (PsiTreeUtil.getContextOfType((PsiElement)declarator, OCCallable.class, (boolean)true, (Class[])new Class[]{OCParameterList.class}) != null && declarator.getInitializer() == null && declarator.getInitializerList() == null) {
                    this.addErrorAnnotation(declarator, OCInspections.ArrayIssues.class, "err_typecheck_incomplete_array_needs_initializer", "Local incomplete array must be initialized");
                    break;
                }
                isFirstLengthExpr = false;
                continue;
            }
            if (PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCCallable.class}) == null && PsiTreeUtil.getContextOfType((PsiElement)declarator, (Class[])new Class[]{OCParameterList.class}) == null) {
                this.validateConstExpression(length, "err_vla_decl_in_file_scope", "Array length expression must be const");
            }
            if (!(type = length.getResolvedType()).isUnknown() && !type.isIntegerCompatible(declarator)) {
                String message = "Array length expression must have an integer type instead of '" + type.getName(declarator) + "'";
                Annotation annotation = this.addErrorAnnotation(length, OCInspections.IntegerTypeRequired.class, "err_array_size_non_int", message);
                this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(length, OCIntType.CHAR));
            }
            if ((value = OCExpressionEvaluator.evaluate(length)) != null && OCExpressionEvaluator.singAsInC(value) < 0) {
                this.addErrorAnnotation(length, OCInspections.ArrayIssues.class, "err_decl_negative_array_size", "Array length can't be negative");
            }
            isFirstLengthExpr = false;
        }
    }

    private void validateConstExpression(OCExpression expression, final String clangID, final String message) {
        expression.accept(new OCConstantExpressionVisitor(){

            @Override
            protected void nonConstExpression(OCExpression expression) {
                OCSymbol symbol;
                Annotation annotation = OCDeclaratorChecker.this.addErrorAnnotation(expression, OCInspections.ConstExpressionRequired.class, clangID, message);
                if (expression instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)expression).resolveToSymbol()) instanceof OCDeclaratorSymbol) {
                    OCDeclaratorChecker.this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction((OCDeclaratorSymbol)symbol, OCTokenTypes.CONST_KEYWORD));
                }
            }
        });
    }

    public void checkReferenceElement(final OCReferenceElement referenceElement) {
        Annotation annotation;
        OCSymbol symbol = referenceElement.resolveToSymbol();
        if (symbol == null) {
            return;
        }
        OCFile containingFile = referenceElement.getContainingOCFile();
        if (symbol.isGlobal() || symbol instanceof OCInstanceVariableSymbol) {
            OCFileSymbols.markSymbolAsUsed(containingFile, symbol, referenceElement.getParent());
        }
        if (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
            CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (OCResolveUtil.isEarlierInCode(symbol, referenceElement) || OCResolveUtil.isInSameStructInCode(symbol, referenceElement)) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (processor2.process((Object)symbol)) {
                ((OCSymbolWithQualifiedName)symbol).processSameSymbols((Processor<OCSymbol>)processor2, containingFile);
            }
            if (!processor2.isFound()) {
                annotation = null;
                if (containingFile.isCpp() && referenceElement.getParent() instanceof OCReferenceExpression) {
                    OCReferenceExpression referenceExpr = (OCReferenceExpression)referenceElement.getParent();
                    OCResolveContext context = new OCResolveContext((PsiElement)referenceElement.getContainingFile());
                    if (referenceExpr.getParent() instanceof OCCallExpression && !OCResolveUtil.isDependentCode((OCExpression)referenceExpr.getParent(), context)) {
                        annotation = this.addErrorAnnotation(referenceElement, OCInspections.CannotResolve.class, "CIDR", "Undeclared function '" + symbol.getName() + "'");
                    }
                } else {
                    annotation = this.addWarningAnnotation(referenceElement, OCInspections.FunctionImplicitDeclarationInspection.class, "ext_implicit_function_decl", "Implicit declaration of function '" + symbol.getName() + "'");
                }
                if (annotation != null) {
                    this.registerQuickFix(annotation, new OCCreateFunctionPredeclarationIntentionAction(referenceElement, (OCFunctionSymbol)symbol));
                    this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(OCSymbolKind.FUNCTION_DECLARATION, referenceElement, null, symbol, " above"));
                }
            }
        }
        if (!containingFile.isCpp() && symbol instanceof OCStructSymbol && !(referenceElement.getParent() instanceof OCStructLike)) {
            String keyword = symbol.getKind().getNameLowercase();
            annotation = this.addErrorAnnotation(referenceElement, "err_use_of_tag_name_without_tag", "Missing '" + keyword + "' keyword");
            OCChangeTextIntentionAction quickFix = new OCChangeTextIntentionAction(containingFile, referenceElement.getTextOffset(), 0, keyword + " ", "Insert '" + keyword + "'");
            this.registerQuickFix(annotation, quickFix);
            return;
        }
        if (!(symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() || this.myOperatorsChecker.checkFieldVisibility(symbol, referenceElement, null))) {
            return;
        }
        this.checkAccess(referenceElement, symbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAccess(OCReferenceElement referenceElement, OCSymbol symbol) {
        if (symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCPropertySymbol) {
            PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{OCMethod.class, OCSynthesizeProperty.class});
            if (parent == null) {
                this.addErrorAnnotation(referenceElement, OCInspections.ConstructionIsNotAllowed.class, "CIDR", symbol.getNameWithKindUppercase() + " is accessed outside of a method");
                return;
            } else {
                if (!(parent instanceof OCMethod) || ((OCMethod)parent).isInstanceMethod()) return;
                Annotation annotation = this.addErrorAnnotation(referenceElement, OCInspections.StaticnessMismatch.class, "error_ivar_use_in_class_method", symbol.getNameWithKindUppercase() + " is accessed from the class method");
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)((OCMethod)parent).getSymbol(), false));
            }
            return;
        } else {
            boolean isGetAddress;
            OCFunctionSymbol functionSymbol;
            if (referenceElement.getParent() instanceof OCCppUsingStatement) {
                return;
            }
            boolean isMember = false;
            OCStructSymbol declInParent = null;
            if (referenceElement.isCppThis()) {
                isMember = true;
            } else {
                if (!(symbol instanceof OCSymbolWithQualifiedName)) return;
                OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner();
                if (!(owner instanceof OCStructSymbol)) return;
                declInParent = (OCStructSymbol)owner;
            }
            OCSymbolDeclarator parent = (OCSymbolDeclarator)PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{OCFunctionDefinition.class, OCStruct.class});
            Object parentSymbol = parent != null ? parent.getSymbol() : null;
            OCFunctionSymbol oCFunctionSymbol = functionSymbol = parentSymbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)parentSymbol : null;
            if (functionSymbol != null) {
                OCSymbolWithQualifiedName parentClass = functionSymbol.getResolvedOwner();
                isMember = isMember || parentClass instanceof OCStructSymbol && declInParent.isAncestor((OCStructSymbol)parentClass);
            } else {
                isMember = OCCompilerHelper.supportsInClassInitialization(referenceElement.getContainingOCFile()) && parentSymbol instanceof OCStructSymbol ? isMember || declInParent.isAncestor(parentSymbol) : false;
            }
            PsiElement possibleGetAddress = referenceElement.getParent().getParent();
            boolean bl = isGetAddress = possibleGetAddress instanceof OCUnaryExpression && ((OCUnaryExpression)possibleGetAddress).isGetAddress();
            if (isMember && (functionSymbol == null || !functionSymbol.resolveIsStatic()) || !referenceElement.isCppThis() && !OCDeclaratorChecker.musBeStatic(symbol)) return;
            String message = symbol.getNameWithKindUppercase() + (isMember ? " is accessed from the static function" : " must be static");
            if (isGetAddress || possibleGetAddress instanceof OCSizeofExpression) return;
            Annotation annotation = this.addErrorAnnotation(referenceElement, OCInspections.StaticnessMismatch.class, "CIDR", message);
            if (isMember) {
                this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(functionSymbol.getDeclarationInParent(), OCTokenTypes.STATIC_KEYWORD));
            }
            if (symbol instanceof OCFunctionSymbol) {
                this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(((OCFunctionSymbol)symbol).getDeclarationInParent(), OCTokenTypes.STATIC_KEYWORD, false));
                return;
            } else {
                if (!(symbol instanceof OCDeclaratorSymbol)) return;
                this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction((OCSymbolWithQualifiedName)symbol, OCTokenTypes.STATIC_KEYWORD, false));
            }
        }
    }

    private static boolean musBeStatic(OCSymbol symbol) {
        if (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isCppConstructor() && !((OCFunctionSymbol)symbol).isCppOperator() && !((OCFunctionSymbol)symbol).resolveIsStatic()) {
            return true;
        }
        return symbol instanceof OCDeclaratorSymbol && !((OCDeclaratorSymbol)symbol).resolveIsStatic() && (symbol.getKind() == OCSymbolKind.STRUCT_FIELD || symbol.getKind().isGlobalVariable());
    }
}

