/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OCAnnotatorProfiler
extends OCVisitor
implements Annotator {
    private Map<Class<? extends PsiElement>, Long> stats = new HashMap();

    public abstract void doAnnotate(@NotNull PsiElement var1, @NotNull AnnotationHolder var2);

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/lang/daemon/OCAnnotatorProfiler", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/cidr/lang/daemon/OCAnnotatorProfiler", "annotate"));
        }
        long startTime = System.currentTimeMillis();
        this.doAnnotate(psiElement, holder);
        long curTime = System.currentTimeMillis() - startTime;
        Long value = this.stats.get(psiElement.getClass());
        if (value == null) {
            value = new Long(0L);
        }
        this.stats.put(psiElement.getClass(), value + curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void printStats() {
        ArrayList<Class<? extends PsiElement>> classes = new ArrayList<Class<? extends PsiElement>>(this.stats.keySet());
        Collections.sort(classes, new Comparator<Class<? extends PsiElement>>(){

            @Override
            public int compare(Class<? extends PsiElement> o1, Class<? extends PsiElement> o2) {
                return -((Long)OCAnnotatorProfiler.this.stats.get(o1)).compareTo((long)((Long)OCAnnotatorProfiler.this.stats.get(o2)));
            }
        });
        long totTime = 0L;
        for (Class clazz : classes) {
            totTime += this.stats.get(clazz).longValue();
        }
        Class<OCAnnotatorProfiler> clazz = OCAnnotatorProfiler.class;
        synchronized (OCAnnotatorProfiler.class) {
            void var5_6;
            System.out.println("\n" + ((Object)((Object)this)).getClass().getSimpleName() + ": Total time: " + totTime);
            boolean bl = false;
            while (var5_6 < 7 && var5_6 < classes.size()) {
                long time = this.stats.get(classes.get((int)var5_6));
                System.out.println("  " + ((Class)classes.get((int)var5_6)).getSimpleName() + ": " + time + " (" + new Double((double)time * 100.0 / (double)totTime).intValue() + "%)");
                ++var5_6;
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void visitOCFile(OCFile file2) {
        this.printStats();
    }
}

