/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCAutoImportHelper {
    public static final ExtensionPointName<OCAutoImportHelper> EP_NAME = ExtensionPointName.create((String)"cidr.lang.autoImportHelper");

    public boolean supports(@NotNull OCResolveRootAndConfiguration var1);

    public boolean processPathSpecificationToInclude(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3, @NotNull OCResolveRootAndConfiguration var4, @NotNull Processor<ImportSpecification> var5);

    public void addHeaderSearchPath(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3);

    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3);

    public static class ImportSpecification {
        @NotNull
        private final String myPath;
        @NotNull
        private final Kind myKind;
        @NotNull
        private final EnumSet<OCIncludeDirective.Delimiters> myPossibleDelimiters;

        public ImportSpecification(@NotNull String path, @NotNull Kind kind) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "<init>"));
            }
            this.myPath = path;
            this.myKind = kind;
            EnumSet<OCIncludeDirective.Delimiters> possibleDelimiters = kind == Kind.SYSTEM_HEADER_SEARCH_PATH ? EnumSet.of(OCIncludeDirective.Delimiters.ANGLE_BRACKETS, OCIncludeDirective.Delimiters.QUOTES) : EnumSet.of(OCIncludeDirective.Delimiters.QUOTES);
            possibleDelimiters.add(OCIncludeDirective.Delimiters.NONE);
            this.myPossibleDelimiters = possibleDelimiters;
            assert (this.myPossibleDelimiters.contains((Object)this.getPreferredDelimiters()));
        }

        @NotNull
        public String getImportText() {
            String string = this.getImportText(this.getPreferredDelimiters());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getImportText"));
            }
            return string;
        }

        @NotNull
        public String getImportText(@NotNull OCIncludeDirective.Delimiters delimiters) {
            int dotIndex;
            if (delimiters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiters", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getImportText"));
            }
            String importText = this.getImportPath();
            if (delimiters == OCIncludeDirective.Delimiters.NONE && (dotIndex = importText.lastIndexOf(46)) > 0) {
                importText = importText.substring(0, dotIndex);
            }
            String string = delimiters.getBeforeText() + importText + delimiters.getAfterText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getImportText"));
            }
            return string;
        }

        @NotNull
        public String getImportPath() {
            String string = this.myPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getImportPath"));
            }
            return string;
        }

        @NotNull
        public Kind getKind() {
            Kind kind = this.myKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getKind"));
            }
            return kind;
        }

        public boolean areDelimitersAllowed(OCIncludeDirective.Delimiters d) {
            return this.myPossibleDelimiters.contains((Object)d);
        }

        @NotNull
        public OCIncludeDirective.Delimiters getPreferredDelimiters() {
            OCIncludeDirective.Delimiters delimiters = this.myKind == Kind.SYSTEM_HEADER_SEARCH_PATH ? OCIncludeDirective.Delimiters.ANGLE_BRACKETS : OCIncludeDirective.Delimiters.QUOTES;
            if (delimiters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification", "getPreferredDelimiters"));
            }
            return delimiters;
        }

        public static enum Kind {
            PROJECT_HEADER,
            USER_HEADER_SEARCH_PATH,
            SYSTEM_HEADER_SEARCH_PATH;

        }
    }
}

