/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.InplaceButton;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettingsListener;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileWithSelectedExtensionAction<T extends CreateFileDialog>
extends OCNewFileActionBase<T> {
    private static final String DEFAULT_H_EXT = "h";
    private static final String NEW_CPP_HELP_TOPIC_ID = "New_C_C++_File_Dialog";

    protected OCNewFileWithSelectedExtensionAction(@Nullable FileType type, String text, String description, Icon icon) {
        super(type, text, description, icon);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled() && this.myHelper != null && !this.myHelper.canChangeDir()) {
            IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            presentation.setEnabled(view != null && view.getDirectories().length != 0);
        }
    }

    @NotNull
    protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> getExtensions(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "getExtensions"));
        }
        OCCodeStyleSettings codeStyle = (OCCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCustomSettings(OCCodeStyleSettings.class);
        ImmutableList<OCCodeStyleSettings.FileExtensionPair> immutableList = codeStyle.FILE_EXTENSION_PAIRS_ORDERED;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "getExtensions"));
        }
        return immutableList;
    }

    @NotNull
    private String findSourceExt(@NotNull Project project, @NotNull String headerExt, @NotNull OCLanguageKind headerKind) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findSourceExt"));
        }
        if (headerExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerExt", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findSourceExt"));
        }
        if (headerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerKind", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findSourceExt"));
        }
        for (OCCodeStyleSettings.FileExtensionPair pair : this.getExtensions(project)) {
            OCLanguageKind sourceKind;
            if (!pair.myHeaderExt.equals(headerExt) || (sourceKind = OCLanguageKindCalculator.tryFileExtension(project, "." + pair.mySourceExt)) == null || headerKind.isCpp() != sourceKind.isCpp()) continue;
            String string = pair.mySourceExt;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findSourceExt"));
            }
            return string;
        }
        String string = headerKind.getDefaultSourceExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findSourceExt"));
        }
        return string;
    }

    @NotNull
    private String findHeaderExt(@NotNull Project project, @NotNull String sourceExt) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findHeaderExt"));
        }
        if (sourceExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceExt", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findHeaderExt"));
        }
        for (OCCodeStyleSettings.FileExtensionPair pair : this.getExtensions(project)) {
            if (!pair.mySourceExt.equals(sourceExt)) continue;
            String string = pair.myHeaderExt;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findHeaderExt"));
            }
            return string;
        }
        if (DEFAULT_H_EXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "findHeaderExt"));
        }
        return DEFAULT_H_EXT;
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull OCFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "determineExtensions"));
        }
        Couple<String> couple = this.determineExtensions(file2, null, null);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "determineExtensions"));
        }
        return couple;
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull OCFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        if (sampleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleFile", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "determineExtensions"));
        }
        Project project = sampleFile.getProject();
        if (preferredSourceExt == null && preferredHeaderExt == null) {
            if (sampleFile.isHeader()) {
                preferredHeaderExt = FileUtilRt.getExtension((String)sampleFile.getName());
                OCFile implFile = sampleFile.getAssociatedFile();
                if (implFile != null) {
                    preferredSourceExt = FileUtilRt.getExtension((String)implFile.getName());
                }
            } else {
                preferredSourceExt = FileUtilRt.getExtension((String)sampleFile.getName());
            }
        }
        if (preferredSourceExt == null) {
            preferredSourceExt = this.findSourceExt(project, preferredHeaderExt, sampleFile.getKind());
        } else if (preferredHeaderExt == null) {
            preferredHeaderExt = this.findHeaderExt(project, preferredSourceExt);
        }
        Couple couple = Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction", "determineExtensions"));
        }
        return couple;
    }

    @Override
    protected boolean isValidName(String selectedName) {
        return selectedName.length() > 0 && VirtualFile.isValidName((String)selectedName);
    }

    @Override
    protected T createDialog(String defaultName) {
        return (T)((Object)new CreateFileDialog(defaultName));
    }

    protected class CreateFileDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        protected OCCodeStyleSettings.FileExtensionPair myFileExtensionPair;
        protected TemplateKindCombo myKindCombo;
        @NotNull
        protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> pairs;

        public CreateFileDialog(String defaultName) {
            this("New " + this$0.getTemplatePresentation().getText(), defaultName);
        }

        public CreateFileDialog(String title, String defaultName) {
            super(title, defaultName, PlatformUtils.isCLion() ? OCNewFileWithSelectedExtensionAction.NEW_CPP_HELP_TOPIC_ID : null);
            this.pairs = ContainerUtil.immutableList((Object[])new OCCodeStyleSettings.FileExtensionPair[0]);
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, true);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.createFileTypesCombo(formBuilder);
        }

        protected void createFileTypesCombo(FormBuilder formBuilder) {
            ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(OCFileExtensionsSettingsListener.TOPIC, (Object)new OCFileExtensionsSettingsListener(){

                @Override
                public void settingsUpdated() {
                    CreateFileDialog.this.reloadExtensions();
                }
            });
            JPanel panel = new JPanel(new BorderLayout(5, 0));
            this.myKindCombo = new TemplateKindCombo();
            panel.add((Component)((Object)this.myKindCombo), "Center");
            panel.add((Component)this.createPreferencesButton(), "East");
            formBuilder.addLabeledComponent(OCBundle.message("create.field.type", new Object[0]), (JComponent)panel);
            this.reloadExtensions();
            ((JComboBox)this.myKindCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    int selectedIndex;
                    if (event.getStateChange() == 1 && (selectedIndex = CreateFileDialog.this.myKindCombo.getComboBox().getSelectedIndex()) < CreateFileDialog.this.pairs.size()) {
                        CreateFileDialog.this.myFileExtensionPair = (OCCodeStyleSettings.FileExtensionPair)CreateFileDialog.this.pairs.get(selectedIndex);
                    }
                    CreateFileDialog.this.validateOkAction();
                }
            });
            this.myKindCombo.registerUpDownHint(this.myNameField);
        }

        protected void reloadExtensions() {
            OCCodeStyleSettings.FileExtensionPair previousPair = this.myFileExtensionPair;
            this.myKindCombo.clear();
            HashSet processedNames = ContainerUtil.newHashSet();
            ArrayList filteredPairs = ContainerUtil.newArrayList();
            for (OCCodeStyleSettings.FileExtensionPair pair : OCNewFileWithSelectedExtensionAction.this.getExtensions(OCNewFileWithSelectedExtensionAction.this.myProject)) {
                String presentableName = this.getPresentableName(pair);
                if (!processedNames.add(presentableName)) continue;
                this.myKindCombo.addItem(presentableName, null, presentableName);
                filteredPairs.add(pair);
            }
            if (!filteredPairs.isEmpty()) {
                this.pairs = ContainerUtil.immutableList((List)filteredPairs);
                this.myFileExtensionPair = previousPair != null && processedNames.contains(this.getPresentableName(previousPair)) ? previousPair : (OCCodeStyleSettings.FileExtensionPair)this.pairs.get(0);
                this.myKindCombo.setSelectedName(this.getPresentableName(this.myFileExtensionPair));
            }
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (this.myKindCombo.getComboBox().getItemCount() == 0) {
                return OCBundle.message("fileExtensions.noCompatibleTypes", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction$CreateFileDialog", "getPresentableName"));
            }
            String string = pair.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction$CreateFileDialog", "getPresentableName"));
            }
            return string;
        }

        @NotNull
        private InplaceButton createPreferencesButton() {
            InplaceButton inplaceButton = new InplaceButton(OCBundle.message("fileExtensions.editFileTypesTooltip", new Object[0]), AllIcons.General.Settings, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String configurableId = "preferences.sourceCode." + OCLanguage.getInstance().getDisplayName();
                    final Configurable configurable = new ConfigurableVisitor.ByID(configurableId).find(ShowSettingsUtilImpl.getConfigurableGroups(OCNewFileWithSelectedExtensionAction.this.myProject, true));
                    OCLog.LOG.assertTrue(configurable != null);
                    ShowSettingsUtil.getInstance().editConfigurable(OCNewFileWithSelectedExtensionAction.this.myProject, configurable, new Runnable(){

                        @Override
                        public void run() {
                            CodeStyleMainPanel codeStyleMainPanel = (CodeStyleMainPanel)configurable.createComponent();
                            OCLog.LOG.assertTrue(codeStyleMainPanel != null);
                            for (NewCodeStyleSettingsPanel p : codeStyleMainPanel.getPanels()) {
                                CodeStyleAbstractPanel selectedPanel = p.getSelectedPanel();
                                OCLog.LOG.assertTrue(selectedPanel != null);
                                ((TabbedLanguageCodeStylePanel)selectedPanel).changeTab(OCBundle.message("fileExtensions.tabName", new Object[0]));
                            }
                        }
                    });
                }
            });
            if (inplaceButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileWithSelectedExtensionAction$CreateFileDialog", "createPreferencesButton"));
            }
            return inplaceButton;
        }
    }
}

