/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCLanguageStandard {
    C89(OCLanguageKind.C),
    C99(OCLanguageKind.C),
    C11(OCLanguageKind.C),
    CPP98(OCLanguageKind.CPP),
    CPP11(OCLanguageKind.CPP),
    CPP14(OCLanguageKind.CPP),
    CPP17(OCLanguageKind.CPP),
    UNKNOWN(null);

    @Nullable
    private final OCLanguageKind myKind;

    private OCLanguageStandard(OCLanguageKind kind) {
        this.myKind = kind;
    }

    public boolean supports(@NotNull OCLanguageStandard standard) {
        if (standard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standard", "com/jetbrains/cidr/lang/OCLanguageStandard", "supports"));
        }
        return Comparing.equal((Object)this.myKind, (Object)standard.myKind) && this.ordinal() >= standard.ordinal();
    }
}

